<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Bridge\Doctrine\Tests\Fixtures;

use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;

#[Entity]
class SingleStringCastableIdEntity
{
    #[Id, Column(type: 'string'), GeneratedValue(strategy: 'NONE')]
    protected StringCastableObjectIdentity $id;

    public function __construct(
        int $id,

        #[Column(nullable: true)]
        public ?string $name,
    ) {
        $this->id = new StringCastableObjectIdentity($id);
    }

    public function __toString(): string
    {
        return (string) $this->name;
    }
}

class StringCastableObjectIdentity
{
    public function __construct(
        protected readonly int $id,
    ) {
    }

    public function __toString(): string
    {
        return (string) $this->id;
    }
}
