% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctions.R
\name{findTemplateFile}
\alias{findTemplateFile}
\title{Find a batchtools Template File}
\usage{
findTemplateFile(template)
}
\arguments{
\item{template}{[\code{character(1)}]\cr
Either a path to a \pkg{brew} template file (with extension \dQuote{tmpl}), or a short descriptive name enabling the following heuristic for the file lookup:
\enumerate{
  \item \dQuote{batchtools.[template].tmpl} in the path specified by the environment variable \dQuote{R_BATCHTOOLS_SEARCH_PATH}.
  \item \dQuote{batchtools.[template].tmpl} in the current working directory.
  \item \dQuote{[template].tmpl} in the user config directory (see \code{\link[rappdirs]{user_config_dir}}); on linux this is usually \dQuote{~/.config/batchtools/[template].tmpl}.
  \item \dQuote{.batchtools.[template].tmpl} in the home directory.
  \item \dQuote{[template].tmpl} in the package installation directory in the subfolder \dQuote{templates}.
}}
}
\value{
[\code{character}] Path to the file or \code{NA} if no template template file was found.
}
\description{
This functions returns the path to a template file on the file system.
}
\keyword{internal}
