#!/bin/bash

pkglib_dir() {
    for _dir in /usr/libexec $libdirs; do
        if [ -x "${dracutsysrootdir-}$_dir/plymouth/plymouth-populate-initrd" ]; then
            echo "$_dir/plymouth"
            return
        fi
    done
}

read_setting_from_config() {
    local setting="$1"
    local config_file="$2"
    [[ -f $config_file ]] \
        && sed -n "s/^${setting}= *\([^ ]\+\) */\1/p" "$config_file"
}

use_simpledrm() {
    local config use_simpledrm config_dirs=()
    if [[ $hostonly ]]; then
        config_dirs+=("${dracutsysrootdir-}/etc/plymouth/plymouthd.conf")
    fi
    for config in "${config_dirs[@]}" "${dracutsysrootdir-}/usr/share/plymouth/plymouthd.defaults"; do
        use_simpledrm=$(read_setting_from_config UseSimpledrm "$config")
        if [[ $use_simpledrm -ge 1 ]]; then
            return 0
        fi
        if [[ $use_simpledrm == "0" ]]; then
            return 1
        fi
    done
    return 1
}

# called by dracut
check() {
    [[ "$mount_needs" ]] && return 1
    [[ $(pkglib_dir) ]] || return 1

    require_binaries plymouthd plymouth || return 1

    return 0
}

# called by dracut
depends() {
    if use_simpledrm; then
        echo simpledrm
    else
        echo drm
    fi
}

# called by dracut
install() {
    PKGLIBDIR=$(pkglib_dir)
    PLYMOUTH_POPULATE_SOURCE_FUNCTIONS="$dracutfunctions" \
        "${dracutsysrootdir-}${PKGLIBDIR}"/plymouth-populate-initrd -t "$initdir" 2> /dev/null

    inst_hook emergency 50 "$moddir"/plymouth-emergency.sh

    inst_multiple readlink

    inst_multiple plymouthd plymouth

    if ! dracut_module_included "systemd"; then
        inst_hook pre-trigger 10 "$moddir"/plymouth-pretrigger.sh
        inst_hook pre-pivot 90 "$moddir"/plymouth-newroot.sh
    fi
}
