/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.hostchooser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.util.HostSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalHostStatusTracker {
    private static final Map<HostSpec, HostSpecStatus> hostStatusMap = new HashMap<HostSpec, HostSpecStatus>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportHostStatus(HostSpec hostSpec, HostStatus hostStatus) {
        long now = System.currentTimeMillis();
        Map<HostSpec, HostSpecStatus> map = hostStatusMap;
        synchronized (map) {
            HostSpecStatus oldStatus = hostStatusMap.get(hostSpec);
            if (oldStatus == null || GlobalHostStatusTracker.updateStatusFromTo(oldStatus.status, hostStatus)) {
                hostStatusMap.put(hostSpec, new HostSpecStatus(hostSpec, hostStatus, now));
            }
        }
    }

    private static boolean updateStatusFromTo(HostStatus oldStatus, HostStatus newStatus) {
        if (oldStatus == null) {
            return true;
        }
        if (newStatus == HostStatus.ConnectOK) {
            return oldStatus != HostStatus.Master && oldStatus != HostStatus.Slave;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<HostSpecStatus> getCandidateHosts(HostSpec[] hostSpecs, HostRequirement targetServerType, long hostRecheckMillis) {
        ArrayList<HostSpecStatus> candidates = new ArrayList<HostSpecStatus>(hostSpecs.length);
        long latestAllowedUpdate = System.currentTimeMillis() - hostRecheckMillis;
        Map<HostSpec, HostSpecStatus> map = hostStatusMap;
        synchronized (map) {
            for (HostSpec hostSpec : hostSpecs) {
                HostSpecStatus hostInfo = hostStatusMap.get(hostSpec);
                if (hostInfo == null || hostInfo.lastUpdated < latestAllowedUpdate) {
                    hostInfo = new HostSpecStatus(hostSpec, null, Long.MAX_VALUE);
                }
                if (hostInfo.status != null && !targetServerType.allowConnectingTo(hostInfo.status)) continue;
                candidates.add(hostInfo);
            }
        }
        return candidates;
    }

    static class HostSpecStatus {
        final HostSpec host;
        final HostStatus status;
        final long lastUpdated;

        HostSpecStatus(HostSpec host, HostStatus hostStatus, long lastUpdated) {
            this.host = host;
            this.status = hostStatus;
            this.lastUpdated = lastUpdated;
        }

        public String toString() {
            return this.host.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

