/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol.authentication;

import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.SendClearPasswordAuthPacket;
import org.mariadb.jdbc.internal.packet.send.SendGssApiAuthPacket;
import org.mariadb.jdbc.internal.packet.send.SendNativePasswordAuthPacket;
import org.mariadb.jdbc.internal.packet.send.SendOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.packet.send.SendPamAuthPacket;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class DefaultAuthenticationProvider {
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String MYSQL_CLEAR_PASSWORD = "mysql_clear_password";
    public static final String GSSAPI_CLIENT = "auth_gssapi_client";
    public static final String DIALOG = "dialog";

    public static InterfaceAuthSwitchSendResponsePacket processAuthPlugin(ReadPacketFetcher packetFetcher, String plugin, String password, byte[] authData, int seqNo) throws QueryException {
        switch (plugin) {
            case "mysql_native_password": {
                return new SendNativePasswordAuthPacket(password, authData, seqNo);
            }
            case "mysql_old_password": {
                return new SendOldPasswordAuthPacket(password, Utils.copyWithLength(authData, 8), seqNo);
            }
            case "mysql_clear_password": {
                return new SendClearPasswordAuthPacket(password, authData, seqNo);
            }
            case "dialog": {
                return new SendPamAuthPacket(packetFetcher, password, authData, seqNo);
            }
            case "auth_gssapi_client": {
                return new SendGssApiAuthPacket(packetFetcher, password, authData, seqNo);
            }
        }
        throw new QueryException("Client does not support authentication protocol requested by server. Consider upgrading MariaDB client. plugin was = " + plugin, 1251, "08004");
    }
}

