/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.MethodSignature;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.ReadOnlyList;
import oracle.jdbc.proxy.Utils;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class MethodGenerator {
    private static long ids = 0L;
    private final String methodObject = "methodObject" + ids++;
    private final String proxyName;
    private final String ifaceName;
    private final String superclassName;
    private final String proxyType;
    private final String ifaceType;
    private final Method method;
    private final ClassGenerator.AnnotationsForIface annotationsForIface;
    private final boolean callDelegate;
    private final boolean returns;
    private final Class[] parameterTypes;
    private final Class[] exceptionTypes;
    private final Class returnType;
    private final String methodName;
    private final String signature;
    private final String[] throwables;
    private final List<Class> exceptionsToCatch = new ReadOnlyList<Class>(){

        @Override
        public Class get(int n2) {
            return 0 == n2 ? RuntimeException.class : MethodGenerator.this.exceptionTypes[n2 - 1];
        }

        @Override
        public int size() {
            return MethodGenerator.this.exceptionTypes.length + 1;
        }
    };

    MethodGenerator(ClassGenerator classGenerator, Method method, boolean bl) {
        this.proxyName = classGenerator.getProxyName();
        this.ifaceName = classGenerator.getIfaceName();
        this.superclassName = classGenerator.getSuperclassName();
        this.ifaceType = classGenerator.getIfaceType();
        this.proxyType = classGenerator.getProxyType();
        this.method = method;
        this.annotationsForIface = classGenerator.getAnnotationsForIface();
        this.callDelegate = bl;
        this.parameterTypes = method.getParameterTypes();
        this.exceptionTypes = method.getExceptionTypes();
        this.returnType = method.getReturnType();
        this.returns = !"void".equals(this.returnType.getName());
        this.methodName = method.getName();
        this.signature = Utils.makeSignature(this.parameterTypes, this.returnType);
        this.throwables = Utils.makeThrowables(this.exceptionTypes);
    }

    String getMethodObject() {
        return this.methodObject;
    }

    private Method getMethodPre() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        return value.getMethodPre(this.annotationsForIface.getIface(), new MethodSignature(this.method));
    }

    private boolean isResultProxied() {
        if (!this.hasAssignableProxyForReturnType(this.returnType, this.annotationsForIface.getRegistry().keySet())) {
            return false;
        }
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return false;
        }
        boolean bl = value.belongsToIfaceToProxy(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        return bl && ProxyResultPolicy.MANUAL != this.getProxyResultPolicy();
    }

    private final boolean hasAssignableProxyForReturnType(Class clazz, Set<Class> set) {
        for (Class clazz2 : set) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodPreDefined() {
        return null != this.getMethodPre();
    }

    private Method getMethodVoidPost() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        return value.getMethodVoidPost(this.annotationsForIface.getIface(), new MethodSignature(this.method));
    }

    private boolean isMethodVoidPostDefined() {
        return null != this.getMethodVoidPost();
    }

    private Method getMethodReturningPost() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        return value.getMethodReturningPost(this.annotationsForIface.getIface(), new MethodSignature(this.method));
    }

    private boolean isMethodReturningPostDefined() {
        return null != this.getMethodReturningPost();
    }

    private Method getMethodVoidOnError(Class clazz) {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        Map<Class, Method> map = value.getMapVoidOnError(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        if (null == map) {
            return null;
        }
        return map.get(clazz);
    }

    private boolean isMethodVoidOnErrorDefined() {
        boolean bl = false;
        for (Class clazz : this.exceptionsToCatch) {
            if (null == this.getMethodVoidOnError(clazz)) continue;
            bl = true;
        }
        return bl;
    }

    private Method getMethodReturningOnError(Class clazz) {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        Map<Class, Method> map = value.getMapReturningOnError(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        if (null == map) {
            return null;
        }
        return map.get(clazz);
    }

    private boolean isMethodReturningOnErrorDefined() {
        boolean bl = false;
        for (Class clazz : this.exceptionsToCatch) {
            if (null == this.getMethodReturningOnError(clazz)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isMethodOnErrorDefined() {
        return this.returns ? this.isMethodReturningOnErrorDefined() : this.isMethodVoidOnErrorDefined();
    }

    private boolean isMethodPostDefined() {
        return this.returns ? this.isMethodReturningPostDefined() : this.isMethodVoidPostDefined();
    }

    final Method getMethodPost() {
        return this.returns ? this.getMethodReturningPost() : this.getMethodVoidPost();
    }

    boolean isAnyInterceptorDefined() {
        return this.isMethodPreDefined() || this.isMethodVoidPostDefined() || this.isMethodReturningPostDefined() || this.isMethodVoidOnErrorDefined() || this.isMethodReturningOnErrorDefined();
    }

    ProxyResultPolicy getProxyResultPolicy() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return ProxyResultPolicy.CACHE;
        }
        return value.getProxyResultPolicy(this.method);
    }

    void generate(ClassWriter classWriter) {
        Label[] labelArray;
        Label[] labelArray2;
        Label[] labelArray3;
        GenericDeclaration genericDeclaration;
        int n2;
        MethodVisitor methodVisitor = classWriter.visitMethod(this.method.isVarArgs() ? 129 : 1, this.methodName, this.signature, null, this.throwables);
        methodVisitor.visitCode();
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        int n3 = 1;
        Class[] classArray = this.parameterTypes;
        int n4 = classArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            genericDeclaration = classArray[n2];
            n3 += Utils.varSize((Class)genericDeclaration);
        }
        int n5 = n3;
        if (this.isMethodOnErrorDefined()) {
            n3 = this.exceptionsToCatch.size();
            labelArray3 = new Label[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Method method;
                Class clazz = this.exceptionsToCatch.get(i2);
                Method method2 = method = this.returns ? this.getMethodReturningOnError(clazz) : this.getMethodVoidOnError(clazz);
                if (null == method) continue;
                labelArray3[i2] = new Label();
                methodVisitor.visitTryCatchBlock(label3, label4, labelArray3[i2], Utils.makeSlashed(this.exceptionsToCatch.get(i2)));
            }
        } else {
            labelArray3 = null;
        }
        methodVisitor.visitLabel(label);
        methodVisitor.visitLabel(label3);
        if (this.isMethodPreDefined()) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
            methodVisitor.visitVarInsn(25, 0);
            n3 = this.parameterTypes.length;
            if (this.method.isVarArgs() && 1 == n3) {
                methodVisitor.visitVarInsn(25, 1);
            } else if (0 == n3) {
                methodVisitor.visitFieldInsn(178, this.proxyName, "zeroLengthObjectArray", "[Ljava/lang/Object;");
            } else {
                Utils.loadConst(methodVisitor, n3);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                int n6 = 1;
                for (n4 = 0; n4 < n3; ++n4) {
                    Class clazz = this.parameterTypes[n4];
                    methodVisitor.visitInsn(89);
                    Utils.loadConst(methodVisitor, n4);
                    methodVisitor.visitVarInsn(Utils.loadOpcode(clazz), n6);
                    Utils.autoBox(methodVisitor, clazz);
                    methodVisitor.visitInsn(83);
                    n6 += Utils.varSize(clazz);
                }
            }
            methodVisitor.visitMethodInsn(183, this.superclassName, this.getMethodPre().getName(), "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)V");
        }
        if (this.isMethodPostDefined()) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
        }
        n3 = this.isResultProxied() ? 1 : 0;
        if (this.returns && n3 != 0) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()));
        }
        methodVisitor.visitVarInsn(25, 0);
        if (this.callDelegate) {
            methodVisitor.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
        }
        this.loadDelegateParams(methodVisitor);
        methodVisitor.visitMethodInsn(this.callDelegate ? 185 : 183, this.callDelegate ? this.ifaceName : this.superclassName, this.methodName, this.signature);
        if (this.returns && n3 != 0) {
            String string;
            Utils.cast(methodVisitor, this.returnType, Object.class);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.proxyName, "proxyCache", "Ljava/util/Map;");
            methodVisitor.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
            switch (this.getProxyResultPolicy()) {
                case CREATE: {
                    string = "proxyForCreate";
                    break;
                }
                case CACHE: {
                    string = "proxyForCache";
                    break;
                }
                case CREATE_CACHE: {
                    string = "proxyForCreateCache";
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            methodVisitor.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class.getName()), string, "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Map;Ljava/lang/reflect/Method;)Ljava/lang/Object;");
        }
        if (this.isMethodPostDefined()) {
            if (this.returns) {
                Utils.cast(methodVisitor, n3 != 0 ? Object.class : this.returnType, this.getMethodPost().getParameterTypes()[1]);
            }
            methodVisitor.visitMethodInsn(182, this.superclassName, this.getMethodPost().getName(), "(Ljava/lang/reflect/Method;" + (this.returns ? Utils.makeType(this.getMethodPost().getParameterTypes()[1]) : "") + ")" + Utils.makeType(this.getMethodPost().getReturnType()));
            if (this.returns) {
                Utils.cast(methodVisitor, this.getMethodPost().getReturnType(), this.returnType);
            }
        } else if (this.returns) {
            Utils.cast(methodVisitor, n3 != 0 ? Object.class : this.returnType, this.returnType);
        }
        methodVisitor.visitLabel(label4);
        methodVisitor.visitInsn(Utils.returnOpcode(this.returnType));
        if (this.isMethodOnErrorDefined()) {
            int n7 = this.exceptionsToCatch.size();
            labelArray2 = new Label[n7];
            labelArray = new Label[n7];
            for (n4 = 0; n4 < n7; ++n4) {
                Class clazz = this.exceptionsToCatch.get(n4);
                GenericDeclaration genericDeclaration2 = genericDeclaration = this.returns ? this.getMethodReturningOnError(clazz) : this.getMethodVoidOnError(clazz);
                if (null == genericDeclaration) continue;
                methodVisitor.visitLabel(labelArray3[n4]);
                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{Utils.makeSlashed(clazz)});
                methodVisitor.visitVarInsn(58, n5);
                labelArray2[n4] = new Label();
                methodVisitor.visitLabel(labelArray2[n4]);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
                if (this.returns && this.isMethodPostDefined()) {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
                }
                methodVisitor.visitVarInsn(25, n5);
                methodVisitor.visitMethodInsn(182, this.superclassName, ((Method)genericDeclaration).getName(), "(Ljava/lang/reflect/Method;" + Utils.makeType(((Method)genericDeclaration).getParameterTypes()[1].getName()) + ")" + Utils.makeType(((Method)genericDeclaration).getReturnType().getName()));
                if (this.returns && this.isMethodPostDefined()) {
                    Utils.cast(methodVisitor, ((Method)genericDeclaration).getReturnType(), this.getMethodPost().getParameterTypes()[1]);
                    methodVisitor.visitMethodInsn(182, this.superclassName, this.getMethodPost().getName(), "(Ljava/lang/reflect/Method;" + Utils.makeType(this.getMethodPost().getParameterTypes()[1].getName()) + ")" + Utils.makeType(this.getMethodPost().getReturnType().getName()));
                    Utils.cast(methodVisitor, this.getMethodPost().getReturnType(), this.returnType);
                } else {
                    Utils.cast(methodVisitor, ((Method)genericDeclaration).getReturnType(), this.returnType);
                }
                methodVisitor.visitInsn(Utils.returnOpcode(this.returnType));
                labelArray[n4] = new Label();
                methodVisitor.visitLabel(labelArray[n4]);
            }
        } else {
            labelArray = null;
            labelArray2 = null;
        }
        methodVisitor.visitLabel(label2);
        int n8 = 0;
        methodVisitor.visitLocalVariable("this", this.proxyType, null, label, label2, n8++);
        for (n4 = 0; n4 < this.parameterTypes.length; ++n4) {
            methodVisitor.visitLocalVariable("arg" + n4, Utils.makeType(this.parameterTypes[n4]), null, label, label2, n8);
            n8 += Utils.varSize(this.parameterTypes[n4]);
        }
        if (this.isMethodOnErrorDefined()) {
            if (n5 != n8) {
                throw new RuntimeException("wrong exception index");
            }
            n4 = this.exceptionsToCatch.size();
            for (n2 = 0; n2 < n4; ++n2) {
                Method method;
                genericDeclaration = this.exceptionsToCatch.get(n2);
                Method method3 = method = this.returns ? this.getMethodReturningOnError((Class)genericDeclaration) : this.getMethodVoidOnError((Class)genericDeclaration);
                if (null == method) continue;
                methodVisitor.visitLocalVariable("e", Utils.makeType(this.exceptionsToCatch.get(n2)), null, labelArray2[n2], labelArray[n2], n5);
            }
        }
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void loadDelegateParams(MethodVisitor methodVisitor) {
        String string = Utils.makeSlashed(_Proxy_.class.getName());
        int n2 = 1;
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            Class clazz = this.parameterTypes[i2];
            String string2 = Utils.makeSlashed(clazz.getName());
            boolean bl = false;
            block1: for (AnnotationsRegistry.Value value : this.annotationsForIface.getRegistry().values()) {
                for (Class clazz2 : value.getIfacesToProxy()) {
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    bl = true;
                    continue block1;
                }
            }
            if (bl) {
                AnnotationsRegistry.Value value;
                methodVisitor.visitVarInsn(Utils.loadOpcode(clazz), n2);
                methodVisitor.visitTypeInsn(193, string);
                Label label = new Label();
                methodVisitor.visitJumpInsn(153, label);
                methodVisitor.visitVarInsn(Utils.loadOpcode(clazz), n2);
                methodVisitor.visitTypeInsn(192, string);
                methodVisitor.visitMethodInsn(185, string, "_getDelegate_", "()Ljava/lang/Object;");
                methodVisitor.visitTypeInsn(192, string2);
                value = new Label();
                methodVisitor.visitJumpInsn(167, (Label)value);
                methodVisitor.visitLabel(label);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitVarInsn(Utils.loadOpcode(clazz), n2);
                methodVisitor.visitLabel((Label)value);
                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{string2});
            } else {
                methodVisitor.visitVarInsn(Utils.loadOpcode(clazz), n2);
            }
            n2 += Utils.varSize(this.parameterTypes[i2]);
        }
    }

    void initializeMethodObject(MethodVisitor methodVisitor) {
        int n2 = this.parameterTypes.length;
        methodVisitor.visitLdcInsn((Object)Type.getType((String)Utils.makeType(this.method.getDeclaringClass().getName())));
        methodVisitor.visitLdcInsn((Object)this.methodName);
        Utils.loadConst(methodVisitor, n2);
        methodVisitor.visitTypeInsn(189, "java/lang/Class");
        for (int i2 = 0; i2 < n2; ++i2) {
            methodVisitor.visitInsn(89);
            Utils.loadConst(methodVisitor, i2);
            Utils.loadClass(methodVisitor, this.parameterTypes[i2]);
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        methodVisitor.visitFieldInsn(179, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
    }
}

