/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.AddReplicaPropertyRequestBody;
import org.apache.solr.client.api.model.AsyncJerseyResponse;
import org.apache.solr.client.api.model.CreateAliasRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.CreateCollectionSnapshotRequestBody;
import org.apache.solr.client.api.model.CreateCollectionSnapshotResponse;
import org.apache.solr.client.api.model.CreateReplicaRequestBody;
import org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse;
import org.apache.solr.client.api.model.InstallShardDataRequestBody;
import org.apache.solr.client.api.model.ListAliasesResponse;
import org.apache.solr.client.api.model.ListCollectionSnapshotsResponse;
import org.apache.solr.client.api.model.ListCollectionsResponse;
import org.apache.solr.client.api.model.ReplaceNodeRequestBody;
import org.apache.solr.client.api.model.SetClusterPropertyRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.api.model.UpdateAliasPropertiesRequestBody;
import org.apache.solr.client.api.model.UpdateCollectionPropertyRequestBody;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.DistributedCollectionConfigSetCommandRunner;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.handler.admin.RebalanceLeaders;
import org.apache.solr.handler.admin.api.AddReplicaProperty;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.AliasProperty;
import org.apache.solr.handler.admin.api.BalanceReplicas;
import org.apache.solr.handler.admin.api.BalanceShardUnique;
import org.apache.solr.handler.admin.api.ClusterProperty;
import org.apache.solr.handler.admin.api.CollectionProperty;
import org.apache.solr.handler.admin.api.CollectionStatus;
import org.apache.solr.handler.admin.api.CreateAlias;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.handler.admin.api.CreateCollectionBackup;
import org.apache.solr.handler.admin.api.CreateCollectionSnapshot;
import org.apache.solr.handler.admin.api.CreateReplica;
import org.apache.solr.handler.admin.api.CreateShard;
import org.apache.solr.handler.admin.api.DeleteAlias;
import org.apache.solr.handler.admin.api.DeleteCollection;
import org.apache.solr.handler.admin.api.DeleteCollectionBackup;
import org.apache.solr.handler.admin.api.DeleteCollectionSnapshot;
import org.apache.solr.handler.admin.api.DeleteNode;
import org.apache.solr.handler.admin.api.DeleteReplica;
import org.apache.solr.handler.admin.api.DeleteReplicaProperty;
import org.apache.solr.handler.admin.api.DeleteShard;
import org.apache.solr.handler.admin.api.ForceLeader;
import org.apache.solr.handler.admin.api.InstallShardData;
import org.apache.solr.handler.admin.api.ListAliases;
import org.apache.solr.handler.admin.api.ListCollectionBackups;
import org.apache.solr.handler.admin.api.ListCollectionSnapshots;
import org.apache.solr.handler.admin.api.ListCollections;
import org.apache.solr.handler.admin.api.MigrateDocsAPI;
import org.apache.solr.handler.admin.api.MigrateReplicas;
import org.apache.solr.handler.admin.api.ModifyCollectionAPI;
import org.apache.solr.handler.admin.api.MoveReplicaAPI;
import org.apache.solr.handler.admin.api.RebalanceLeadersAPI;
import org.apache.solr.handler.admin.api.ReloadCollectionAPI;
import org.apache.solr.handler.admin.api.RenameCollection;
import org.apache.solr.handler.admin.api.ReplaceNode;
import org.apache.solr.handler.admin.api.RestoreCollection;
import org.apache.solr.handler.admin.api.SplitShardAPI;
import org.apache.solr.handler.admin.api.SyncShard;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.tracing.TraceUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    private final Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionConfigSetCommandRunner;
    static final Set<String> KNOWN_ROLES = Set.of("overseer");
    public static long DEFAULT_COLLECTION_OP_TIMEOUT = 180000L;

    public CollectionsHandler() {
        this(null);
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.distributedCollectionConfigSetCommandRunner = coreContainer != null ? coreContainer.getDistributedCollectionCommandRunner() : Optional.empty();
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String action = ctx.getParams().get("action");
        if (action == null) {
            return PermissionNameProvider.Name.COLL_READ_PERM;
        }
        CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)action);
        if (collectionAction == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + action);
        }
        return collectionAction.isWrite ? PermissionNameProvider.Name.COLL_EDIT_PERM : PermissionNameProvider.Name.COLL_READ_PERM;
    }

    @Override
    public final void init(NamedList<?> args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.checkErrors();
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)a);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
        }
        String collection = params.get("collection");
        MDCLoggingContext.setCollection(collection);
        TraceUtils.setDbInstance(req, collection);
        if (log.isDebugEnabled()) {
            log.debug("Invoked Collection Action: {} with params {}", (Object)action.toLower(), (Object)req.getParamString());
        }
        CollectionOperation operation = CollectionOperation.get(action);
        this.invokeAction(req, rsp, cores, action, operation);
        rsp.setHttpCaching(false);
    }

    protected CoreContainer checkErrors() {
        CoreContainer cores = this.getCoreContainer();
        AdminAPIBase.validateZooKeeperAwareCoreContainer(cores);
        return cores;
    }

    void invokeAction(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer cores, CollectionParams.CollectionAction action, CollectionOperation operation) throws Exception {
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid request. collections can be accessed only in SolrCloud mode");
        }
        Map<String, Object> props = operation.execute(req, rsp, this);
        if (props == null) {
            return;
        }
        String asyncId = req.getParams().get("async");
        if (asyncId != null) {
            props.put("async", asyncId);
        }
        props.put("operation", operation.action.toLower());
        ZkNodeProps zkProps = new ZkNodeProps(props);
        SolrResponse overseerResponse = this.submitCollectionApiCommand(zkProps, operation.action, operation.timeOut);
        rsp.getValues().addAll(overseerResponse.getResponse());
        Exception exp = overseerResponse.getException();
        if (exp != null) {
            rsp.setException(exp);
        }
    }

    public SolrResponse submitCollectionApiCommand(ZkNodeProps m, CollectionParams.CollectionAction action) throws KeeperException, InterruptedException {
        return this.submitCollectionApiCommand(m, action, DEFAULT_COLLECTION_OP_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrResponse submitCollectionApiCommand(CoreContainer coreContainer, Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionConfigSetCommandRunner, ZkNodeProps m, CollectionParams.CollectionAction action, long timeout) throws KeeperException, InterruptedException {
        if (distributedCollectionConfigSetCommandRunner.isPresent()) {
            return distributedCollectionConfigSetCommandRunner.get().runCollectionCommand(m, action, timeout);
        }
        String operation = m.getStr("operation");
        if (operation == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing key operation");
        }
        if (m.get("async") != null) {
            String asyncId = m.getStr("async");
            NamedList r = new NamedList();
            if (coreContainer.getZkController().claimAsyncId(asyncId)) {
                boolean success = false;
                try {
                    coreContainer.getZkController().getOverseerCollectionQueue().offer((MapWriter)m);
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            coreContainer.getZkController().clearAsyncId(asyncId);
                        }
                        catch (Exception e) {
                            log.error("Unable to release async ID={}", (Object)asyncId, (Object)e);
                            SolrZkClient.checkInterrupted((Throwable)e);
                        }
                    }
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Task with the same requestid already exists. (" + asyncId + ")");
            r.add("requestid", m.get("async"));
            return new OverseerSolrResponse((NamedList<Object>)r);
        }
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            return OverseerSolrResponseSerializer.deserialize(event.getBytes());
        }
        if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
        }
        if (event.getWatchedEvent() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + String.valueOf(event.getWatchedEvent().getState()) + " type " + String.valueOf(event.getWatchedEvent().getType()) + "]");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unknown case");
    }

    public SolrResponse submitCollectionApiCommand(ZkNodeProps m, CollectionParams.CollectionAction action, long timeout) throws KeeperException, InterruptedException {
        return CollectionsHandler.submitCollectionApiCommand(this.coreContainer, this.distributedCollectionConfigSetCommandRunner, m, action, timeout);
    }

    private boolean overseerCollectionQueueContains(String asyncId) throws KeeperException, InterruptedException {
        OverseerTaskQueue collectionQueue = this.coreContainer.getZkController().getOverseerCollectionQueue();
        return collectionQueue.containsTaskWithRequestId("async", asyncId);
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            String[] values = params.getParams(param);
            if (values.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one value can be present for parameter " + param);
            }
            props.put(param, values[0]);
        }
        return props;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    private static void addStatusToResponse(NamedList<Object> results, RequestStatusState state, String msg) {
        SimpleOrderedMap status = new SimpleOrderedMap();
        status.add("state", (Object)state.getKey());
        status.add("msg", (Object)msg);
        results.add("status", (Object)status);
    }

    public static void waitForActiveCollection(String collectionName, CoreContainer cc, SolrResponse createCollResponse) throws KeeperException, InterruptedException {
        if (createCollResponse.getResponse().get("exception") != null) {
            if (log.isInfoEnabled()) {
                log.info("Not waiting for active collection due to exception: {}", createCollResponse.getResponse().get("exception"));
            }
            return;
        }
        int replicaFailCount = createCollResponse.getResponse().get("failure") != null ? ((NamedList)createCollResponse.getResponse().get("failure")).size() : 0;
        CloudConfig ccfg = cc.getConfig().getCloudConfig();
        Integer seconds = ccfg.getCreateCollectionWaitTimeTillActive();
        Boolean checkLeaderOnly = ccfg.isCreateCollectionCheckLeaderActive();
        if (log.isInfoEnabled()) {
            log.info("Wait for new collection to be active for at most {} seconds. Check all shard {}", (Object)seconds, (Object)(checkLeaderOnly != false ? "leaders" : "replicas"));
        }
        try {
            cc.getZkController().getZkStateReader().waitForState(collectionName, (long)seconds.intValue(), TimeUnit.SECONDS, (n, c) -> {
                if (c == null) {
                    return true;
                }
                if (c.getSlices() != null) {
                    Collection shards = c.getSlices();
                    int replicaNotAliveCnt = 0;
                    for (Slice shard : shards) {
                        ArrayList<Replica> replicas;
                        if (!checkLeaderOnly.booleanValue()) {
                            replicas = shard.getReplicas();
                        } else {
                            replicas = new ArrayList<Replica>();
                            replicas.add(shard.getLeader());
                        }
                        for (Replica replica : replicas) {
                            Replica.State state = replica.getState();
                            if (log.isDebugEnabled()) {
                                log.debug("Checking replica status, collection={} replica={} state={}", new Object[]{collectionName, replica.getCoreUrl(), state});
                            }
                            if (n.contains(replica.getNodeName()) && state.equals((Object)Replica.State.ACTIVE)) continue;
                            ++replicaNotAliveCnt;
                            return false;
                        }
                    }
                    return replicaNotAliveCnt == 0 || replicaNotAliveCnt <= replicaFailCount;
                }
                return false;
            });
        }
        catch (InterruptedException | TimeoutException e) {
            String error = "Timeout waiting for active collection " + collectionName + " with timeout=" + seconds;
            throw new ZkController.NotInClusterStateException(SolrException.ErrorCode.SERVER_ERROR, error);
        }
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(CreateReplica.class, AddReplicaProperty.class, BalanceShardUnique.class, CollectionStatus.class, CreateAlias.class, CreateCollection.class, CreateCollectionBackup.class, CreateShard.class, DeleteAlias.class, DeleteCollectionBackup.class, DeleteCollection.class, DeleteReplica.class, DeleteReplicaProperty.class, DeleteShard.class, ForceLeader.class, InstallShardData.class, ListCollections.class, ListCollectionBackups.class, ReloadCollectionAPI.class, RenameCollection.class, ReplaceNode.class, MigrateReplicas.class, BalanceReplicas.class, RestoreCollection.class, SyncShard.class, CollectionProperty.class, DeleteNode.class, ListAliases.class, AliasProperty.class, ListCollectionSnapshots.class, CreateCollectionSnapshot.class, DeleteCollectionSnapshot.class, ClusterProperty.class);
    }

    @Override
    public Collection<Api> getApis() {
        ArrayList<Api> apis = new ArrayList<Api>();
        apis.addAll(AnnotatedApi.getApis(new SplitShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new MigrateDocsAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new ModifyCollectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new MoveReplicaAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RebalanceLeadersAPI(this)));
        return apis;
    }

    static Map<String, Object> copy(SolrParams source, Map<String, Object> sink, Collection<String> paramNames) {
        if (sink == null) {
            sink = new LinkedHashMap<String, Object>();
        }
        for (String param : paramNames) {
            String[] v = source.getParams(param);
            if (v == null || v.length <= 0) continue;
            if (v.length == 1) {
                sink.put(param, v[0]);
                continue;
            }
            sink.put(param, v);
        }
        return sink;
    }

    static Map<String, Object> copy(SolrParams source, Map<String, Object> sink, String ... paramNames) {
        return CollectionsHandler.copy(source, sink, paramNames == null ? Collections.emptyList() : Arrays.asList(paramNames));
    }

    static interface CollectionOp {
        public Map<String, Object> execute(SolrQueryRequest var1, SolrQueryResponse var2, CollectionsHandler var3) throws Exception;
    }

    public static enum CollectionOperation implements CollectionOp
    {
        CREATE_OP(CollectionParams.CollectionAction.CREATE, (req, rsp, h) -> {
            CreateCollectionRequestBody requestBody = CreateCollection.createRequestBodyFromV1Params(req.getParams(), true);
            CreateCollection createApi = new CreateCollection(h.coreContainer, req, rsp);
            SubResponseAccumulatingJerseyResponse response = createApi.createCollection(requestBody);
            if (rsp != null) {
                V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
            }
            return null;
        }),
        COLSTATUS_OP(CollectionParams.CollectionAction.COLSTATUS, (req, rsp, h) -> {
            Map<String, Object> props = CollectionsHandler.copy(req.getParams(), null, "collection", "coreInfo", "segments", "fieldInfo", "rawSize", "rawSizeSummary", "rawSizeDetails", "rawSizeSamplingPercent", "sizeInfo");
            CollectionStatus.populateColStatusData(h.coreContainer, new ZkNodeProps(props), rsp.getValues());
            return null;
        }),
        DELETE_OP(CollectionParams.CollectionAction.DELETE, (req, rsp, h) -> {
            RequiredSolrParams requiredParams = req.getParams().required();
            DeleteCollection deleteCollectionAPI = new DeleteCollection(h.coreContainer, req, rsp);
            SubResponseAccumulatingJerseyResponse deleteCollResponse = deleteCollectionAPI.deleteCollection(requiredParams.get("name"), req.getParams().getBool("followAliases"), req.getParams().get("async"));
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteCollResponse);
            return null;
        }),
        RELOAD_OP(CollectionParams.CollectionAction.RELOAD, (req, rsp, h) -> {
            ReloadCollectionAPI.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        RENAME_OP(CollectionParams.CollectionAction.RENAME, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name", "target");
            return CollectionsHandler.copy(req.getParams(), map, "followAliases");
        }),
        REINDEXCOLLECTION_OP(CollectionParams.CollectionAction.REINDEXCOLLECTION, (req, rsp, h) -> {
            Map<String, Object> m = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            CollectionsHandler.copy(req.getParams(), m, "cmd", "removeSource", "target", "configName", "numShards", "nrtReplicas", "pullReplicas", "tlogReplicas", "replicationFactor", "createNodeSet", "createNodeSet.shuffle", "shards", "rows", "q", "fl", "followAliases");
            if (req.getParams().get("collection.configName") != null) {
                m.put("configName", req.getParams().get("collection.configName"));
            }
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), m, "router.");
            return m;
        }),
        SYNCSHARD_OP(CollectionParams.CollectionAction.SYNCSHARD, (req, rsp, h) -> {
            SyncShard.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        CREATEALIAS_OP(CollectionParams.CollectionAction.CREATEALIAS, (req, rsp, h) -> {
            CreateAliasRequestBody reqBody = CreateAlias.createFromSolrParams(req.getParams());
            SolrJerseyResponse response = new CreateAlias(h.coreContainer, req, rsp).createAlias(reqBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
            return null;
        }),
        DELETEALIAS_OP(CollectionParams.CollectionAction.DELETEALIAS, (req, rsp, h) -> {
            DeleteAlias deleteAliasAPI = new DeleteAlias(h.coreContainer, req, rsp);
            SolrJerseyResponse response = deleteAliasAPI.deleteAlias(req.getParams().required().get("name"), req.getParams().get("async"));
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
            return null;
        }),
        ALIASPROP_OP(CollectionParams.CollectionAction.ALIASPROP, (req, rsp, h) -> {
            String name = req.getParams().required().get("name");
            Map<String, Object> properties = CollectionOperation.collectToMap(req.getParams(), "property");
            UpdateAliasPropertiesRequestBody requestBody = new UpdateAliasPropertiesRequestBody();
            requestBody.properties = properties;
            requestBody.async = req.getParams().get("async");
            AliasProperty aliasPropertyAPI = new AliasProperty(h.coreContainer, req, rsp);
            SolrJerseyResponse getAliasesResponse = aliasPropertyAPI.updateAliasProperties(name, requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, getAliasesResponse);
            return null;
        }),
        LISTALIASES_OP(CollectionParams.CollectionAction.LISTALIASES, (req, rsp, h) -> {
            ListAliases getAliasesAPI = new ListAliases(h.coreContainer, req, rsp);
            ListAliasesResponse getAliasesResponse = getAliasesAPI.getAliases();
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, getAliasesResponse);
            return null;
        }),
        SPLITSHARD_OP(CollectionParams.CollectionAction.SPLITSHARD, DEFAULT_COLLECTION_OP_TIMEOUT * 5L, (req, rsp, h) -> {
            String name = req.getParams().required().get("collection");
            String shard = req.getParams().get("shard");
            String rangesStr = req.getParams().get("ranges");
            String splitKey = req.getParams().get("split.key");
            String numSubShards = req.getParams().get("numSubShards");
            String fuzz = req.getParams().get("splitFuzz");
            if (splitKey == null && shard == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of shard, or split.key should be specified.");
            }
            if (splitKey != null && shard != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
            }
            if (splitKey != null && rangesStr != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
            }
            if (numSubShards != null && (splitKey != null || rangesStr != null)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numSubShards can not be specified with split.key or ranges parameters");
            }
            if (fuzz != null && (splitKey != null || rangesStr != null)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "fuzz can not be specified with split.key or ranges parameters");
            }
            Map<String, Object> map = CollectionsHandler.copy(req.getParams(), null, "collection", "shard", "split.key", "ranges", "waitForFinalState", "timing", "splitMethod", "numSubShards", "splitFuzz", "splitByPrefix", "followAliases", "createNodeSet");
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
        }),
        DELETESHARD_OP(CollectionParams.CollectionAction.DELETESHARD, (req, rsp, h) -> {
            DeleteShard.invokeWithV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        FORCELEADER_OP(CollectionParams.CollectionAction.FORCELEADER, (req, rsp, h) -> {
            ForceLeader.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        CREATESHARD_OP(CollectionParams.CollectionAction.CREATESHARD, (req, rsp, h) -> {
            CreateShard.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        DELETEREPLICA_OP(CollectionParams.CollectionAction.DELETEREPLICA, (req, rsp, h) -> {
            DeleteReplica.invokeWithV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        MIGRATE_OP(CollectionParams.CollectionAction.MIGRATE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection", "split.key", "target.collection");
            return CollectionsHandler.copy(req.getParams(), map, "forward.timeout", "followAliases");
        }),
        ADDROLE_OP(CollectionParams.CollectionAction.ADDROLE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "role", "node");
            if (!KNOWN_ROLES.contains(map.get("role"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + String.valueOf(KNOWN_ROLES));
            }
            return map;
        }),
        REMOVEROLE_OP(CollectionParams.CollectionAction.REMOVEROLE, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "role", "node");
            if (!KNOWN_ROLES.contains(map.get("role"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + String.valueOf(KNOWN_ROLES));
            }
            return map;
        }),
        CLUSTERPROP_OP(CollectionParams.CollectionAction.CLUSTERPROP, (req, rsp, h) -> {
            ClusterProperty clusterProperty = new ClusterProperty(req.getCoreContainer(), req, rsp);
            SetClusterPropertyRequestBody setClusterPropertyRequestBody = new SetClusterPropertyRequestBody();
            String name = req.getParams().required().get("name");
            setClusterPropertyRequestBody.value = req.getParams().get("val");
            clusterProperty.createOrUpdateClusterProperty(name, setClusterPropertyRequestBody);
            return null;
        }),
        COLLECTIONPROP_OP(CollectionParams.CollectionAction.COLLECTIONPROP, (req, rsp, h) -> {
            String collection = req.getParams().required().get("name");
            String propName = req.getParams().required().get("propertyName");
            String val = req.getParams().get("propertyValue");
            CollectionProperty setCollPropApi = new CollectionProperty(h.coreContainer, req, rsp);
            SolrJerseyResponse setPropRsp = val != null ? setCollPropApi.createOrUpdateCollectionProperty(collection, propName, new UpdateCollectionPropertyRequestBody(val)) : setCollPropApi.deleteCollectionProperty(collection, propName);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, setPropRsp);
            return null;
        }),
        REQUESTSTATUS_OP(CollectionParams.CollectionAction.REQUESTSTATUS, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"requestid"});
            CoreContainer coreContainer = h.coreContainer;
            String requestId = req.getParams().get("requestid");
            ZkController zkController = coreContainer.getZkController();
            NamedList status = new NamedList();
            if (coreContainer.getDistributedCollectionCommandRunner().isEmpty()) {
                if (zkController.getOverseerRunningMap().contains(requestId)) {
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.RUNNING, "found [" + requestId + "] in running tasks");
                } else if (zkController.getOverseerCompletedMap().contains(requestId)) {
                    byte[] mapEntry = zkController.getOverseerCompletedMap().get(requestId);
                    rsp.getValues().addAll(OverseerSolrResponseSerializer.deserialize(mapEntry).getResponse());
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.COMPLETED, "found [" + requestId + "] in completed tasks");
                } else if (zkController.getOverseerFailureMap().contains(requestId)) {
                    byte[] mapEntry = zkController.getOverseerFailureMap().get(requestId);
                    rsp.getValues().addAll(OverseerSolrResponseSerializer.deserialize(mapEntry).getResponse());
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.FAILED, "found [" + requestId + "] in failed tasks");
                } else if (h.overseerCollectionQueueContains(requestId)) {
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.SUBMITTED, "found [" + requestId + "] in submitted tasks");
                } else {
                    CollectionsHandler.addStatusToResponse((NamedList<Object>)status, RequestStatusState.NOT_FOUND, "Did not find [" + requestId + "] in any tasks queue");
                }
            } else {
                String message;
                Pair<RequestStatusState, OverseerSolrResponse> sr = coreContainer.getDistributedCollectionCommandRunner().get().getAsyncTaskRequestStatus(requestId);
                switch ((RequestStatusState)sr.first()) {
                    case COMPLETED: {
                        message = "found [" + requestId + "] in completed tasks";
                        rsp.getValues().addAll(((OverseerSolrResponse)((Object)((Object)sr.second()))).getResponse());
                        break;
                    }
                    case FAILED: {
                        message = "found [" + requestId + "] in failed tasks";
                        rsp.getValues().addAll(((OverseerSolrResponse)((Object)((Object)sr.second()))).getResponse());
                        break;
                    }
                    case RUNNING: {
                        message = "found [" + requestId + "] in running tasks";
                        break;
                    }
                    case SUBMITTED: {
                        message = "found [" + requestId + "] in submitted tasks";
                        break;
                    }
                    default: {
                        message = "Did not find [" + requestId + "] in any tasks queue";
                    }
                }
                CollectionsHandler.addStatusToResponse((NamedList<Object>)status, (RequestStatusState)sr.first(), message);
            }
            rsp.getValues().addAll(status);
            return null;
        }),
        DELETESTATUS_OP(CollectionParams.CollectionAction.DELETESTATUS, new CollectionOp(){

            @Override
            public Map<String, Object> execute(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                boolean flush = req.getParams().getBool("flush", false);
                if (requestId == null && !flush) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either requestid or flush parameter must be specified.");
                }
                if (requestId != null && flush) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both requestid and flush parameters can not be specified together.");
                }
                if (coreContainer.getDistributedCollectionCommandRunner().isEmpty()) {
                    if (flush) {
                        Collection<String> completed = zkController.getOverseerCompletedMap().keys();
                        Collection<String> failed = zkController.getOverseerFailureMap().keys();
                        for (String asyncId : completed) {
                            zkController.getOverseerCompletedMap().remove(asyncId);
                            zkController.clearAsyncId(asyncId);
                        }
                        for (String asyncId : failed) {
                            zkController.getOverseerFailureMap().remove(asyncId);
                            zkController.clearAsyncId(asyncId);
                        }
                        rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                    } else if (zkController.getOverseerCompletedMap().remove(requestId)) {
                        zkController.clearAsyncId(requestId);
                        rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                    } else if (zkController.getOverseerFailureMap().remove(requestId)) {
                        zkController.clearAsyncId(requestId);
                        rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                    } else {
                        rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                    }
                } else if (flush) {
                    coreContainer.getDistributedCollectionCommandRunner().get().deleteAllAsyncIds();
                    rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                } else if (coreContainer.getDistributedCollectionCommandRunner().get().deleteSingleAsyncId(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else {
                    rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                }
                return null;
            }
        }),
        ADDREPLICA_OP(CollectionParams.CollectionAction.ADDREPLICA, (req, rsp, h) -> {
            SolrParams params = req.getParams();
            params.required().check(new String[]{"collection", "shard"});
            CreateReplica api = new CreateReplica(h.coreContainer, req, rsp);
            CreateReplicaRequestBody requestBody = CreateReplica.createRequestBodyFromV1Params(req.getParams());
            SubResponseAccumulatingJerseyResponse response = api.createReplica(params.get("collection"), params.get("shard"), requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
            return null;
        }),
        OVERSEERSTATUS_OP(CollectionParams.CollectionAction.OVERSEERSTATUS, (req, rsp, h) -> new LinkedHashMap()),
        DISTRIBUTEDAPIPROCESSING_OP(CollectionParams.CollectionAction.DISTRIBUTEDAPIPROCESSING, (req, rsp, h) -> {
            NamedList results = new NamedList();
            boolean isDistributedApi = h.coreContainer.getDistributedCollectionCommandRunner().isPresent();
            results.add("isDistributedApi", (Object)isDistributedApi);
            rsp.getValues().addAll(results);
            return null;
        }),
        LIST_OP(CollectionParams.CollectionAction.LIST, (req, rsp, h) -> {
            ListCollections listCollectionsAPI = new ListCollections(h.coreContainer, req, rsp);
            ListCollectionsResponse listCollectionsResponse = listCollectionsAPI.listCollections();
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, listCollectionsResponse);
            return null;
        }),
        CLUSTERSTATUS_OP(CollectionParams.CollectionAction.CLUSTERSTATUS, (req, rsp, h) -> {
            new ClusterStatus(h.coreContainer.getZkController().getZkStateReader(), req.getParams()).getClusterStatus(rsp.getValues(), req.getHttpSolrCall().getUserAgentSolrVersion());
            return null;
        }),
        ADDREPLICAPROP_OP(CollectionParams.CollectionAction.ADDREPLICAPROP, (req, rsp, h) -> {
            RequiredSolrParams requiredParams = req.getParams().required();
            AddReplicaPropertyRequestBody requestBody = new AddReplicaPropertyRequestBody();
            requestBody.value = requiredParams.get("property.value");
            requestBody.shardUnique = req.getParams().getBool("shardUnique");
            String propName = requiredParams.get("property");
            String trimmedPropName = propName.startsWith("property.") ? propName.substring("property.".length()) : propName;
            AddReplicaProperty addReplicaPropertyAPI = new AddReplicaProperty(h.coreContainer, req, rsp);
            SolrJerseyResponse addReplicaPropResponse = addReplicaPropertyAPI.addReplicaProperty(requiredParams.get("collection"), requiredParams.get("shard"), requiredParams.get("replica"), trimmedPropName, requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, addReplicaPropResponse);
            return null;
        }),
        DELETEREPLICAPROP_OP(CollectionParams.CollectionAction.DELETEREPLICAPROP, (req, rsp, h) -> {
            DeleteReplicaProperty api = new DeleteReplicaProperty(h.coreContainer, req, rsp);
            SolrJerseyResponse deleteReplicaPropResponse = DeleteReplicaProperty.invokeUsingV1Inputs(api, req.getParams());
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteReplicaPropResponse);
            return null;
        }),
        BALANCESHARDUNIQUE_OP(CollectionParams.CollectionAction.BALANCESHARDUNIQUE, (req, rsp, h) -> {
            BalanceShardUnique.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        REBALANCELEADERS_OP(CollectionParams.CollectionAction.REBALANCELEADERS, (req, rsp, h) -> {
            new RebalanceLeaders(req, rsp, h).execute();
            return null;
        }),
        MODIFYCOLLECTION_OP(CollectionParams.CollectionAction.MODIFYCOLLECTION, (req, rsp, h) -> {
            Map<String, Object> m = CollectionsHandler.copy(req.getParams(), null, CollectionAdminRequest.MODIFIABLE_COLLECTION_PROPERTIES);
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), m, "property.");
            if (m.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)"no supported values provided {0}", (Object[])new Object[]{CollectionAdminRequest.MODIFIABLE_COLLECTION_PROPERTIES.toString()}));
            }
            CollectionsHandler.copy((SolrParams)req.getParams().required(), m, "collection");
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                String prop = entry.getKey();
                if ("".equals(entry.getValue())) {
                    entry.setValue(null);
                }
                DocCollection.verifyProp(m, (String)prop);
            }
            if (m.get("replicationFactor") != null) {
                m.put("nrtReplicas", m.get("replicationFactor"));
            }
            return m;
        }),
        BACKUP_OP(CollectionParams.CollectionAction.BACKUP, (req, rsp, h) -> {
            SolrJerseyResponse response = CreateCollectionBackup.invokeFromV1Params(req, rsp, h.coreContainer);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
            return null;
        }),
        RESTORE_OP(CollectionParams.CollectionAction.RESTORE, (req, rsp, h) -> {
            SolrJerseyResponse response = RestoreCollection.invokeFromV1Params(req, rsp, h.coreContainer);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
            return null;
        }),
        INSTALLSHARDDATA_OP(CollectionParams.CollectionAction.INSTALLSHARDDATA, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "shard"});
            String collectionName = req.getParams().get("collection");
            String shardName = req.getParams().get("shard");
            InstallShardDataRequestBody reqBody = new InstallShardDataRequestBody();
            reqBody.async = req.getParams().get("async");
            reqBody.repository = req.getParams().get("repository");
            reqBody.location = req.getParams().get("location");
            InstallShardData installApi = new InstallShardData(h.coreContainer, req, rsp);
            AsyncJerseyResponse installResponse = installApi.installShardData(collectionName, shardName, reqBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, installResponse);
            return null;
        }),
        DELETEBACKUP_OP(CollectionParams.CollectionAction.DELETEBACKUP, (req, rsp, h) -> {
            DeleteCollectionBackup.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        LISTBACKUP_OP(CollectionParams.CollectionAction.LISTBACKUP, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name"});
            ListCollectionBackups.invokeFromV1Params(h.coreContainer, req, rsp);
            return null;
        }),
        CREATESNAPSHOT_OP(CollectionParams.CollectionAction.CREATESNAPSHOT, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "commitName"});
            String extCollectionName = req.getParams().get("collection");
            boolean followAliases = req.getParams().getBool("followAliases", false);
            String commitName = req.getParams().get("commitName");
            String asyncId = req.getParams().get("async");
            CreateCollectionSnapshot createCollectionSnapshotAPI = new CreateCollectionSnapshot(h.coreContainer, req, rsp);
            CreateCollectionSnapshotRequestBody requestBody = new CreateCollectionSnapshotRequestBody();
            requestBody.followAliases = followAliases;
            requestBody.async = asyncId;
            CreateCollectionSnapshotResponse createSnapshotResponse = createCollectionSnapshotAPI.createCollectionSnapshot(extCollectionName, commitName, requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, createSnapshotResponse);
            return null;
        }),
        DELETESNAPSHOT_OP(CollectionParams.CollectionAction.DELETESNAPSHOT, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "commitName"});
            String extCollectionName = req.getParams().get("collection");
            String commitName = req.getParams().get("commitName");
            boolean followAliases = req.getParams().getBool("followAliases", false);
            String asyncId = req.getParams().get("async");
            DeleteCollectionSnapshot deleteCollectionSnapshotAPI = new DeleteCollectionSnapshot(h.coreContainer, req, rsp);
            DeleteCollectionSnapshotResponse deleteSnapshotResponse = deleteCollectionSnapshotAPI.deleteCollectionSnapshot(extCollectionName, commitName, followAliases, asyncId);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteSnapshotResponse);
            return null;
        }),
        LISTSNAPSHOTS_OP(CollectionParams.CollectionAction.LISTSNAPSHOTS, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection"});
            ListCollectionSnapshots listCollectionSnapshotsAPI = new ListCollectionSnapshots(h.coreContainer, req, rsp);
            ListCollectionSnapshotsResponse response = listCollectionSnapshotsAPI.listSnapshots(req.getParams().get("collection"));
            NamedList snapshots = new NamedList();
            for (Object meta : response.snapshots.values()) {
                CollectionSnapshotMetaData metaTyped = (CollectionSnapshotMetaData)meta;
                snapshots.add(metaTyped.getName(), metaTyped.toNamedList());
            }
            rsp.add("snapshots", snapshots);
            return null;
        }),
        REPLACENODE_OP(CollectionParams.CollectionAction.REPLACENODE, (req, rsp, h) -> {
            SolrParams params = req.getParams();
            RequiredSolrParams requiredParams = req.getParams().required();
            ReplaceNodeRequestBody requestBody = new ReplaceNodeRequestBody();
            requestBody.targetNodeName = params.get("targetNode");
            requestBody.waitForFinalState = params.getBool("waitForFinalState");
            requestBody.async = params.get("async");
            ReplaceNode replaceNodeAPI = new ReplaceNode(h.coreContainer, req, rsp);
            SolrJerseyResponse replaceNodeResponse = replaceNodeAPI.replaceNode(requiredParams.get("sourceNode"), requestBody);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, replaceNodeResponse);
            return null;
        }),
        MOVEREPLICA_OP(CollectionParams.CollectionAction.MOVEREPLICA, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection");
            return CollectionsHandler.copy(req.getParams(), map, "fromNode", "sourceNode", "targetNode", "waitForFinalState", "inPlaceMove", "replica", "shard", "followAliases");
        }),
        DELETENODE_OP(CollectionParams.CollectionAction.DELETENODE, (req, rsp, h) -> {
            DeleteNode deleteNodeAPI = new DeleteNode(h.coreContainer, req, rsp);
            SolrJerseyResponse deleteNodeResponse = DeleteNode.invokeUsingV1Inputs(deleteNodeAPI, req.getParams());
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteNodeResponse);
            return null;
        }),
        MOCK_COLL_TASK_OP(CollectionParams.CollectionAction.MOCK_COLL_TASK, (req, rsp, h) -> {
            Map<String, Object> map = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "collection");
            return CollectionsHandler.copy(req.getParams(), map, "sleep");
        });

        public final CollectionOp fun;
        final CollectionParams.CollectionAction action;
        final long timeOut;

        private static Map<String, Object> collectToMap(SolrParams params, String prefix) {
            LinkedHashMap<String, Object> sink = new LinkedHashMap<String, Object>();
            Iterator iter = params.getParameterNamesIterator();
            while (iter.hasNext()) {
                String param = (String)iter.next();
                if (!param.startsWith(prefix)) continue;
                sink.put(param.substring(prefix.length() + 1), params.get(param));
            }
            return sink;
        }

        private CollectionOperation(CollectionParams.CollectionAction action, CollectionOp fun) {
            this(action, DEFAULT_COLLECTION_OP_TIMEOUT, fun);
        }

        private CollectionOperation(CollectionParams.CollectionAction action, long timeOut, CollectionOp fun) {
            this.action = action;
            this.timeOut = timeOut;
            this.fun = fun;
        }

        public static CollectionOperation get(CollectionParams.CollectionAction action) {
            for (CollectionOperation op : CollectionOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action " + String.valueOf(action));
        }

        @Override
        public Map<String, Object> execute(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
            return this.fun.execute(req, rsp, h);
        }
    }
}

