/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.handler;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.crossdc.common.ConfUtil;
import org.apache.solr.crossdc.common.KafkaCrossDcConf;
import org.apache.solr.crossdc.common.KafkaMirroringSink;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroringConfigSetsHandler
extends ConfigSetsHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private KafkaMirroringSink sink;

    public MirroringConfigSetsHandler(CoreContainer coreContainer) {
        this(coreContainer, null);
    }

    public MirroringConfigSetsHandler(CoreContainer coreContainer, KafkaMirroringSink sink) {
        super(coreContainer);
        log.info("Using MirroringCollectionsHandler.");
        if (sink == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            try {
                SolrZkClient zkClient = null;
                if (coreContainer.getZkController() != null) {
                    zkClient = coreContainer.getZkController().getZkClient();
                }
                ConfUtil.fillProperties(zkClient, properties);
                ConfUtil.verifyProperties(properties);
                KafkaCrossDcConf conf = new KafkaCrossDcConf(properties);
                this.sink = new KafkaMirroringSink(conf);
            }
            catch (Exception e) {
                log.error("Exception configuring Kafka sink - mirroring disabled!", (Throwable)e);
                this.sink = null;
            }
        } else {
            this.sink = sink;
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        boolean doMirroring = req.getParams().getBool("shouldMirror", true);
        if (!doMirroring) {
            log.info(" -- doMirroring=false, skipping...");
            super.handleRequestBody(req, rsp);
            return;
        }
        LocalSolrQueryRequest localReq = new LocalSolrQueryRequest(req.getCore(), req.getParams());
        ArrayList<ContentStream> contentStreams = null;
        if (req.getContentStreams() != null) {
            contentStreams = new ArrayList<ContentStream>();
            for (ContentStream cs : req.getContentStreams()) {
                MirroredSolrRequest.ExposedByteArrayContentStream stream = MirroredSolrRequest.ExposedByteArrayContentStream.of(cs);
                contentStreams.add((ContentStream)stream);
            }
            localReq.setContentStreams(contentStreams);
        }
        this.baseHandleRequestBody((SolrQueryRequest)localReq, rsp);
        if (rsp.getException() != null) {
            return;
        }
        if (this.sink == null) {
            return;
        }
        SolrRequest.METHOD method = SolrRequest.METHOD.valueOf((String)req.getHttpMethod().toUpperCase(Locale.ROOT));
        MirroredSolrRequest.MirroredConfigSetRequest configSetRequest = new MirroredSolrRequest.MirroredConfigSetRequest(method, req.getParams(), contentStreams);
        this.sink.submit(new MirroredSolrRequest(MirroredSolrRequest.Type.CONFIGSET, configSetRequest));
    }

    @VisibleForTesting
    public void baseHandleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        super.handleRequestBody(req, rsp);
    }
}

