/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.ComponentColorModel;
import java.awt.image.RasterFormatException;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.feature.Resources;

final class ScaledColorModel
extends ComponentColorModel {
    private static final int MASK = 255;
    static final int RANGE = 256;
    private final ScaledColorSpace cs;

    ScaledColorModel(ScaledColorSpace scaledColorSpace, int n) {
        super(scaledColorSpace, false, false, 2, n);
        this.cs = scaledColorSpace;
    }

    final ScaledColorModel createSubsetColorModel(int[] nArray) {
        return new ScaledColorModel(new ScaledColorSpace(this.cs, nArray), this.transferType);
    }

    @Override
    public int getRed(int n) {
        return this.getRGB(n) >>> 16 & 0xFF;
    }

    @Override
    public int getRed(Object object) {
        return this.getRGB(object) >>> 16 & 0xFF;
    }

    @Override
    public int getGreen(int n) {
        return this.getRGB(n) >>> 8 & 0xFF;
    }

    @Override
    public int getGreen(Object object) {
        return this.getRGB(object) >>> 8 & 0xFF;
    }

    @Override
    public int getBlue(int n) {
        return this.getRGB(n) & 0xFF;
    }

    @Override
    public int getBlue(Object object) {
        return this.getRGB(object) & 0xFF;
    }

    @Override
    public int getAlpha(int n) {
        return 255;
    }

    @Override
    public int getTransparency() {
        return ImageUtilities.isIntegerType(this.transferType) ? 1 : 2;
    }

    @Override
    public int getAlpha(Object object) {
        int n = this.cs.visibleBand;
        switch (this.transferType) {
            case 4: {
                return Float.isNaN(((float[])object)[n]) ? 0 : 255;
            }
            case 5: {
                return Double.isNaN(((double[])object)[n]) ? 0 : 255;
            }
        }
        return 255;
    }

    @Override
    public int getRGB(Object object) {
        double d;
        int n = this.cs.visibleBand;
        switch (this.transferType) {
            case 0: {
                d = Byte.toUnsignedInt(((byte[])object)[n]);
                break;
            }
            case 1: {
                d = Short.toUnsignedInt(((short[])object)[n]);
                break;
            }
            case 2: {
                d = ((short[])object)[n];
                break;
            }
            case 3: {
                d = ((int[])object)[n];
                break;
            }
            case 4: {
                d = ((float[])object)[n];
                break;
            }
            case 5: {
                d = ((double[])object)[n];
                break;
            }
            default: {
                throw new RasterFormatException(Resources.format((short)69, this.transferType));
            }
        }
        if (Double.isNaN(d)) {
            return 0;
        }
        int n2 = Math.max(0, Math.min(255, (int)((d - this.cs.offset) * this.cs.scale)));
        return n2 | n2 << 8 | n2 << 16 | 0xFF000000;
    }

    @Override
    public int getRGB(int n) {
        int n2 = Math.max(0, Math.min(255, (int)(((double)n - this.cs.offset) * this.cs.scale)));
        return n2 | n2 << 8 | n2 << 16 | 0xFF000000;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScaledColorModel) {
            ScaledColorModel scaledColorModel = (ScaledColorModel)object;
            return this.transferType == scaledColorModel.getTransferType() && this.cs.equals(scaledColorModel.cs);
        }
        return false;
    }
}

