\name{LabelMapContourOverlayImageFilter}
\alias{LabelMapContourOverlayImageFilter}
\title{LabelMapContourOverlayImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Apply a colormap to the contours (outlines) of each object in a label
map and superimpose it on top of the feature image.
LabelMapContourOverlayImageFilter}
\details{
The feature image is typically the image from which the labeling was
produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.
Apply a colormap to a label map and put it on top of the input image.
The set of colors is a good selection of distinct colors. The opacity
of the label map can be defined by the user. A background label
produce a gray pixel with the same intensity than the input one.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
LabelMapOverlayImageFilter , LabelOverlayImageFilter , LabelOverlayFunctor
LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter ,
LabelMapContourOverlay for the procedural interface
itk::LabelMapContourOverlayImageFilter for the Doxygen on the original ITK class.
LabelMapContourOverlayImageFilter}
%C++ includes: sitkLabelMapContourOverlayImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &labelMapImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{std::vector< uint8_t > GetColormap() const:}{}
\item{std::vector< unsigned int > GetContourThickness() const:}{
Set/Get the contour thickness - 1 by default.
}
\item{ContourTypeType GetContourType() const:}{
Set/Get the overlay type - CONTOUR is used by default.
}
\item{std::vector< unsigned int > GetDilationRadius() const:}{
Set/Get the object dilation radius - 0 by default.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOpacity() const:}{
Set/Get the opacity of the colored label image. The value must be
between 0 and 1
}
\item{PriorityType GetPriority() const:}{
Set/Get the object priority - HIGH_LABEL_ON_TOP by default.
}
\item{unsigned int GetSliceDimension() const:}{
Set/Get the slice dimension - defaults to image dimension - 1.
}
\item{ LabelMapContourOverlayImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetColormap(std::vector< uint8_t > Colormap):}{}
\item{Self SetContourThickness(std::vector< unsigned int > ContourThickness):}{
Set/Get the contour thickness - 1 by default.
}
\item{Self SetContourType(ContourTypeType ContourType):}{
Set/Get the overlay type - CONTOUR is used by default.
}
\item{Self SetDilationRadius(std::vector< unsigned int > DilationRadius):}{
Set/Get the object dilation radius - 0 by default.
}
\item{Self SetDilationRadius(unsigned int value):}{
Set the values of the DilationRadius vector all to value
}
\item{Self SetOpacity(double Opacity):}{
Set/Get the opacity of the colored label image. The value must be
between 0 and 1
}
\item{Self SetPriority(PriorityType Priority):}{
Set/Get the object priority - HIGH_LABEL_ON_TOP by default.
}
\item{Self SetSliceDimension(unsigned int SliceDimension):}{
Set/Get the slice dimension - defaults to image dimension - 1.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelMapContourOverlayImageFilter():}{
Destructor
}
}
}
