/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Blotter;
import net.sourceforge.plantuml.sequencediagram.teoz.CommonTile;
import net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import net.sourceforge.plantuml.sequencediagram.teoz.EmptyTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LifeEventTile;
import net.sourceforge.plantuml.sequencediagram.teoz.NewpageTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.sequencediagram.teoz.TileParallel;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class GroupingTile
extends AbstractTile {
    public static final int EXTERNAL_MARGINX1 = 3;
    public static final int EXTERNAL_MARGINX2 = 9;
    private static final int MARGINX = 16;
    private static final int MARGINY_MAGIC = 20;
    private List<Tile> tiles = new ArrayList<Tile>();
    private final Real min;
    private final Real max;
    private final GroupingStart start;
    private final YGauge yGauge;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Display display;
    private double bodyHeight;
    private final TileArguments tileArguments;

    @Override
    public Event getEvent() {
        return this.start;
    }

    @Override
    public double getContactPointRelative() {
        return 0.0;
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    public GroupingTile(Iterator<Event> it, GroupingStart start, TileArguments tileArgumentsBackColorChanged, TileArguments tileArgumentsOriginal, YGauge currentY) {
        super(tileArgumentsBackColorChanged.getStringBounder(), currentY);
        Object ev;
        this.tileArguments = tileArgumentsOriginal;
        Real firstY = currentY.getMax();
        StringBounder stringBounder = tileArgumentsOriginal.getStringBounder();
        this.start = start;
        this.display = start.getTitle().equals("group") ? Display.create(start.getComment()) : Display.create(start.getTitle(), start.getComment());
        this.skin = tileArgumentsOriginal.getSkin();
        this.skinParam = tileArgumentsBackColorChanged.getSkinParam();
        ArrayList<Real> min2 = new ArrayList<Real>();
        ArrayList<Real> max2 = new ArrayList<Real>();
        ArrayList<Tile> allElses = new ArrayList<Tile>();
        XDimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        double h = dim1.getHeight() + 10.0;
        currentY = YGauge.create(currentY.getMax().addAtLeast(h), 0.0);
        while (it.hasNext() && (!((ev = it.next()) instanceof GroupingLeaf) || ((Grouping)ev).getType() != GroupingType.END)) {
            for (Tile tile : TileBuilder.buildOne(it, tileArgumentsOriginal, (Event)ev, this, currentY)) {
                this.tiles.add(tile);
            }
        }
        this.tiles = GroupingTile.mergeParallel(this.getStringBounder(), this.tiles);
        for (Tile tile : this.tiles) {
            this.bodyHeight += tile.getPreferredHeight();
            Event ev2 = tile.getEvent();
            if (ev2 instanceof GroupingLeaf && ((Grouping)ev2).getType() == GroupingType.ELSE) {
                allElses.add(tile);
                continue;
            }
            min2.add(tile.getMinX().addFixed(-16.0));
            Real m = tile.getMaxX();
            max2.add(m.addFixed(16.0));
        }
        double width = dim1.getWidth();
        if (min2.size() == 0) {
            min2.add(tileArgumentsOriginal.getXOrigin());
        }
        this.min = RealUtils.min(min2);
        for (Tile anElse : allElses) {
            max2.add(anElse.getMaxX());
        }
        max2.add(this.min.addFixed(width + 16.0));
        this.max = RealUtils.max(max2);
        this.yGauge = YGauge.create(firstY, this.getPreferredHeight());
    }

    protected Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.start.getUsedStyles(), ComponentType.GROUPING_HEADER_TEOZ, null, this.skinParam, this.display);
        return comp;
    }

    private XDimension2D getPreferredDimensionIfEmpty(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Area area = this.getArea(stringBounder);
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        if (((Context2D)((Object)ug)).isBackground()) {
            this.drawBackground(ug, area);
            return;
        }
        comp.drawU(ug.apply(UTranslate.dx(this.minCurrentValueForDrawing())), area, (Context2D)((Object)ug));
        this.drawAllElses(ug);
        double h = dim1.getHeight() + 10.0;
        for (Tile tile : this.tiles) {
            ((UDrawable)((Object)tile)).drawU(ug.apply(UTranslate.dy(h)));
            double preferredHeight = tile.getPreferredHeight();
            h += preferredHeight;
        }
    }

    protected Area getArea(StringBounder stringBounder) {
        Area area = Area.create(this.max.getCurrentValue() - this.min.getCurrentValue(), this.getTotalHeight(stringBounder));
        return area;
    }

    protected double minCurrentValueForDrawing() {
        return this.min.getCurrentValue();
    }

    private void drawBackground(UGraphic ug, Area area) {
        Style style = this.start.getUsedStyles()[0];
        HColor back = style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        double round = style.value(PName.RoundCorner).asDouble();
        this.drawCompBackground(ug, area, back, round);
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        double h = dim1.getHeight() + 10.0;
        for (Tile tile : this.tiles) {
            ((UDrawable)((Object)tile)).drawU(ug.apply(UTranslate.dy(h)));
            double preferredHeight = tile.getPreferredHeight();
            h += preferredHeight;
        }
    }

    protected void drawCompBackground(UGraphic ug, Area area, HColor back, double round) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        Blotter blotter = new Blotter(dimensionToUse, back, round);
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            double ypos = elseTile.getTimeHook().getValue() - this.getTimeHook().getValue() + 10.0;
            blotter.addChange(ypos + 1.0, elseTile.getBackColorGeneral());
        }
        blotter.closeChanges();
        blotter.drawU(ug.apply(UTranslate.dx(this.min.getCurrentValue())));
    }

    protected final double getTotalHeight(StringBounder stringBounder) {
        XDimension2D dimIfEmpty = this.getPreferredDimensionIfEmpty(stringBounder);
        return this.bodyHeight + dimIfEmpty.getHeight() + 10.0;
    }

    private void drawAllElses(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrayList<Double> ys = new ArrayList<Double>();
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            double ypos = elseTile.getTimeHook().getValue() - this.getTimeHook().getValue() + 10.0;
            ys.add(ypos);
        }
        double totalHeight = this.getTotalHeight(stringBounder);
        ys.add(totalHeight);
        int i = 0;
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            Component comp = elseTile.getComponent(stringBounder);
            Area area = Area.create(this.max.getCurrentValue() - this.min.getCurrentValue(), (Double)ys.get(i + 1) - (Double)ys.get(i));
            comp.drawU(ug.apply(new UTranslate(this.min.getCurrentValue(), (Double)ys.get(i))), area, (Context2D)((Object)ug));
            ++i;
        }
    }

    @Override
    public double getPreferredHeight() {
        XDimension2D dim1 = this.getPreferredDimensionIfEmpty(this.getStringBounder());
        return dim1.getHeight() + this.bodyHeight + 20.0;
    }

    @Override
    public void addConstraints() {
        for (Tile tile : this.tiles) {
            tile.addConstraints();
        }
    }

    @Override
    public Real getMinX() {
        return this.min.addFixed(-3.0);
    }

    @Override
    public Real getMaxX() {
        return this.max.addFixed(9.0);
    }

    public static TimeHook fillPositionelTiles(StringBounder stringBounder, TimeHook y, List<Tile> tiles, List<CommonTile> local, List<CommonTile> full) {
        for (Tile tile : GroupingTile.mergeParallel(stringBounder, tiles)) {
            tile.callbackY(y);
            local.add((CommonTile)tile);
            full.add((CommonTile)tile);
            if (tile instanceof GroupingTile) {
                GroupingTile groupingTile = (GroupingTile)tile;
                GroupingTile.fillPositionalSubGroupTiles(stringBounder, y, full, groupingTile);
            }
            if (tile instanceof TileParallel) {
                TileParallel tileParallel = (TileParallel)tile;
                GroupingTile.fillPositionalParallelTiles(stringBounder, y, full, tileParallel);
            }
            y = new TimeHook(y.getValue() + tile.getPreferredHeight());
        }
        return y;
    }

    private static void fillPositionalSubGroupTiles(StringBounder stringBounder, TimeHook y, List<CommonTile> full, GroupingTile groupingTile) {
        double headerHeight = groupingTile.getHeaderHeight(stringBounder);
        ArrayList<CommonTile> local2 = new ArrayList<CommonTile>();
        GroupingTile.fillPositionelTiles(stringBounder, new TimeHook(y.getValue() + headerHeight), groupingTile.tiles, local2, full);
    }

    private static void fillPositionalParallelTiles(StringBounder stringBounder, TimeHook yArg, List<CommonTile> full, TileParallel tileParallel) {
        double yPointAll = tileParallel.getContactPointRelative();
        for (Tile tile : tileParallel.getTiles()) {
            double yPoint = tile.getContactPointRelative();
            double adjustment = yPointAll - yPoint;
            TimeHook yAdjusted = new TimeHook(yArg.getValue() + adjustment);
            tile.callbackY(yAdjusted);
            full.add((CommonTile)tile);
            if (!(tile instanceof GroupingTile)) continue;
            GroupingTile.fillPositionalSubGroupTiles(stringBounder, yAdjusted, full, (GroupingTile)tile);
        }
    }

    private double getHeaderHeight(StringBounder stringBounder) {
        return this.getPreferredDimensionIfEmpty(stringBounder).getHeight() + 10.0;
    }

    private static List<Tile> mergeParallel(StringBounder stringBounder, List<Tile> tiles) {
        TileParallel pending = null;
        tiles = GroupingTile.removeEmptyCloseToParallel(tiles);
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            if (!GroupingTile.isParallel(tile) || result.size() == 0) {
                result.add(tile);
                if (tile instanceof LifeEventTile) continue;
                pending = null;
                continue;
            }
            if (pending == null) {
                pending = new TileParallel(stringBounder, null);
                GroupingTile.moveRecentParallelTilesToPending(result, pending);
                pending.add(tile);
                result.add(pending);
                continue;
            }
            GroupingTile.moveRecentParallelTilesToPending(result, pending);
            pending.add(tile);
        }
        return result;
    }

    private static void moveRecentParallelTilesToPending(List<Tile> result, TileParallel pending) {
        int i;
        if (result.size() == 0) {
            return;
        }
        int capture = 1;
        while (result.get(result.size() - capture) instanceof LifeEventTile) {
            ++capture;
        }
        if (result.get(result.size() - capture) == pending) {
            --capture;
        }
        for (i = result.size() - capture; i < result.size(); ++i) {
            pending.add(result.get(i));
        }
        for (i = 1; i <= capture; ++i) {
            result.remove(result.size() - 1);
        }
    }

    private static List<Tile> removeEmptyCloseToParallel(List<Tile> tiles) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            if (GroupingTile.isParallel(tile)) {
                GroupingTile.removeHeadEmpty(result);
            }
            result.add(tile);
        }
        return result;
    }

    private static void removeHeadEmpty(List<Tile> tiles) {
        while (tiles.size() > 0 && tiles.get(tiles.size() - 1) instanceof EmptyTile) {
            tiles.remove(tiles.size() - 1);
        }
    }

    public static boolean isParallel(Tile tile) {
        return !(tile instanceof TileParallel) && tile.getEvent().isParallel();
    }

    void addYNewPages(Collection<Double> yNewPages) {
        for (Tile tile : this.tiles) {
            if (tile instanceof GroupingTile) {
                ((GroupingTile)tile).addYNewPages(yNewPages);
            }
            if (!(tile instanceof NewpageTile)) continue;
            double y = ((NewpageTile)tile).getTimeHook().getValue();
            yNewPages.add(y);
        }
    }

    public GroupingStart getGroupingStart() {
        return this.start;
    }

    public TileArguments getTileArguments() {
        return this.tileArguments;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }
}

