/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.sequencediagram.teoz.Step;

public class Stairs {
    private final List<Step> values = new ArrayList<Step>();

    public void addStep(Step step) {
        if (step.getIndent() < 0) {
            throw new IllegalArgumentException();
        }
        if (this.values.size() > 0) {
            double lastY = this.values.get(this.values.size() - 1).getValue();
            if (step.getValue() < lastY) {
                return;
            }
        }
        this.values.add(step);
    }

    public int getMaxIndent() {
        int max = Integer.MIN_VALUE;
        for (Step step : this.values) {
            int v = step.getIndent();
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public Collection<Step> getSteps() {
        return Collections.unmodifiableCollection(this.values);
    }
}

