/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.opensearch.sql.calcite.type.AbstractExprRelDataType;
import org.opensearch.sql.calcite.type.ExprBinaryType;
import org.opensearch.sql.calcite.type.ExprDateType;
import org.opensearch.sql.calcite.type.ExprIPType;
import org.opensearch.sql.calcite.type.ExprTimeStampType;
import org.opensearch.sql.calcite.type.ExprTimeType;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.OpenSearchTypeSystem;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.lang.PPLLangSpec;
import org.opensearch.sql.storage.Table;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class OpenSearchTypeFactory
extends JavaTypeFactoryImpl {
    public static final OpenSearchTypeFactory TYPE_FACTORY = new OpenSearchTypeFactory(OpenSearchTypeSystem.INSTANCE);

    private OpenSearchTypeFactory(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        if (type instanceof AbstractExprRelDataType) {
            AbstractExprRelDataType udt = (AbstractExprRelDataType)type;
            return udt.createWithNullability(this, nullable);
        }
        return super.createTypeWithNullability(type, nullable);
    }

    public RelDataType createTypeWithCharsetAndCollation(RelDataType type, Charset charset, SqlCollation collation) {
        if (type instanceof AbstractExprRelDataType) {
            AbstractExprRelDataType udt = (AbstractExprRelDataType)type;
            return udt.createWithCharsetAndCollation(this, charset, collation);
        }
        return super.createTypeWithCharsetAndCollation(type, charset, collation);
    }

    public RelDataType createSqlType(SqlTypeName typeName, boolean nullable) {
        return this.createTypeWithNullability(super.createSqlType(typeName), nullable);
    }

    public RelDataType createStructType(List<RelDataType> typeList, List<String> fieldNameList, boolean nullable) {
        return this.createTypeWithNullability(super.createStructType(typeList, fieldNameList), nullable);
    }

    public RelDataType createMultisetType(RelDataType type, long maxCardinality, boolean nullable) {
        return this.createTypeWithNullability(super.createMultisetType(type, maxCardinality), nullable);
    }

    public RelDataType createMapType(RelDataType keyType, RelDataType valueType, boolean nullable) {
        return this.createTypeWithNullability(super.createMapType(keyType, valueType), nullable);
    }

    public RelDataType createUDT(ExprUDT typeName) {
        AbstractExprRelDataType udt = switch (typeName.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ExprDateType(this);
            case 1 -> new ExprTimeType(this);
            case 2 -> new ExprTimeStampType(this);
            case 3 -> new ExprBinaryType(this);
            case 4 -> new ExprIPType(this);
        };
        return this.canonize(SqlTypeUtil.addCharsetAndCollation((RelDataType)udt, (RelDataTypeFactory)this));
    }

    public RelDataType createUDT(ExprUDT typeName, boolean nullable) {
        return this.createTypeWithNullability(this.createUDT(typeName), nullable);
    }

    public static RelDataType convertExprTypeToRelDataType(ExprType field) {
        return OpenSearchTypeFactory.convertExprTypeToRelDataType(field, true);
    }

    public static RelDataType convertExprTypeToRelDataType(ExprType fieldType, boolean nullable) {
        if (fieldType instanceof ExprCoreType) {
            switch ((ExprCoreType)fieldType) {
                case UNDEFINED: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.NULL, nullable);
                }
                case BYTE: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.TINYINT, nullable);
                }
                case SHORT: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.SMALLINT, nullable);
                }
                case INTEGER: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER, nullable);
                }
                case LONG: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.BIGINT, nullable);
                }
                case FLOAT: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.REAL, nullable);
                }
                case DOUBLE: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.DOUBLE, nullable);
                }
                case IP: {
                    return TYPE_FACTORY.createUDT(ExprUDT.EXPR_IP, nullable);
                }
                case STRING: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR, nullable);
                }
                case BOOLEAN: {
                    return TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN, nullable);
                }
                case DATE: {
                    return TYPE_FACTORY.createUDT(ExprUDT.EXPR_DATE, nullable);
                }
                case TIME: {
                    return TYPE_FACTORY.createUDT(ExprUDT.EXPR_TIME, nullable);
                }
                case TIMESTAMP: {
                    return TYPE_FACTORY.createUDT(ExprUDT.EXPR_TIMESTAMP, nullable);
                }
                case ARRAY: {
                    return TYPE_FACTORY.createArrayType(TYPE_FACTORY.createSqlType(SqlTypeName.ANY, nullable), -1L);
                }
                case STRUCT: {
                    RelDataType relKey = TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR);
                    return TYPE_FACTORY.createMapType(relKey, TYPE_FACTORY.createSqlType(SqlTypeName.ANY), nullable);
                }
            }
            throw new IllegalArgumentException("Unsupported conversion for OpenSearch Data type: " + fieldType.typeName());
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("binary")) {
            return TYPE_FACTORY.createUDT(ExprUDT.EXPR_BINARY, nullable);
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("timestamp")) {
            return TYPE_FACTORY.createUDT(ExprUDT.EXPR_TIMESTAMP, nullable);
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("date")) {
            return TYPE_FACTORY.createUDT(ExprUDT.EXPR_DATE, nullable);
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("time")) {
            return TYPE_FACTORY.createUDT(ExprUDT.EXPR_TIME, nullable);
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("geo_point")) {
            return TYPE_FACTORY.createSqlType(SqlTypeName.GEOMETRY, nullable);
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("text")) {
            return TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR, nullable);
        }
        if (fieldType.legacyTypeName().equalsIgnoreCase("ip")) {
            return TYPE_FACTORY.createUDT(ExprUDT.EXPR_IP, nullable);
        }
        if (fieldType.getOriginalPath().isPresent()) {
            return OpenSearchTypeFactory.convertExprTypeToRelDataType(fieldType.getOriginalExprType(), nullable);
        }
        throw new IllegalArgumentException("Unsupported conversion for OpenSearch Data type: " + fieldType.typeName());
    }

    public static ExprType convertSqlTypeNameToExprType(SqlTypeName sqlTypeName) {
        return switch (sqlTypeName) {
            case SqlTypeName.TINYINT -> ExprCoreType.BYTE;
            case SqlTypeName.SMALLINT -> ExprCoreType.SHORT;
            case SqlTypeName.INTEGER -> ExprCoreType.INTEGER;
            case SqlTypeName.BIGINT -> ExprCoreType.LONG;
            case SqlTypeName.FLOAT, SqlTypeName.REAL -> ExprCoreType.FLOAT;
            case SqlTypeName.DOUBLE, SqlTypeName.DECIMAL -> ExprCoreType.DOUBLE;
            case SqlTypeName.CHAR, SqlTypeName.VARCHAR -> ExprCoreType.STRING;
            case SqlTypeName.BOOLEAN -> ExprCoreType.BOOLEAN;
            case SqlTypeName.DATE -> ExprCoreType.DATE;
            case SqlTypeName.TIME, SqlTypeName.TIME_TZ, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE -> ExprCoreType.TIME;
            case SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIMESTAMP_TZ -> ExprCoreType.TIMESTAMP;
            case SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_YEAR_MONTH, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeName.INTERVAL_SECOND -> ExprCoreType.INTERVAL;
            case SqlTypeName.ARRAY -> ExprCoreType.ARRAY;
            case SqlTypeName.MAP -> ExprCoreType.STRUCT;
            case SqlTypeName.GEOMETRY -> ExprCoreType.GEO_POINT;
            case SqlTypeName.NULL, SqlTypeName.ANY, SqlTypeName.OTHER -> ExprCoreType.UNDEFINED;
            default -> ExprCoreType.UNKNOWN;
        };
    }

    public static String getLegacyTypeName(RelDataType relDataType, QueryType queryType) {
        ExprType type = OpenSearchTypeFactory.convertRelDataTypeToExprType(relDataType);
        return (queryType == QueryType.PPL ? PPLLangSpec.PPL_SPEC.typeName(type) : type.legacyTypeName()).toUpperCase(Locale.ROOT);
    }

    public static ExprType convertRelDataTypeToExprType(RelDataType type) {
        if (OpenSearchTypeFactory.isUserDefinedType(type)) {
            AbstractExprRelDataType udt = (AbstractExprRelDataType)type;
            return udt.getExprType();
        }
        ExprType exprType = OpenSearchTypeFactory.convertSqlTypeNameToExprType(type.getSqlTypeName());
        if (exprType == ExprCoreType.UNKNOWN) {
            throw new IllegalArgumentException("Unsupported conversion for Relational Data type: " + String.valueOf(type.getSqlTypeName()));
        }
        return exprType;
    }

    /*
     * Exception decompiling
     */
    public static ExprValue getExprValueByExprType(ExprType type, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=3,583
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static RelDataType convertSchema(Table table) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        LinkedHashMap<String, ExprType> fieldTypes = new LinkedHashMap<String, ExprType>(table.getFieldTypes());
        fieldTypes.putAll(table.getReservedFieldTypes());
        for (Map.Entry entry : fieldTypes.entrySet()) {
            if (((ExprType)entry.getValue()).getOriginalPath().isPresent()) continue;
            fieldNameList.add((String)entry.getKey());
            typeList.add(OpenSearchTypeFactory.convertExprTypeToRelDataType((ExprType)entry.getValue()));
        }
        return TYPE_FACTORY.createStructType(typeList, fieldNameList, true);
    }

    public Type getJavaClass(RelDataType type) {
        if (type instanceof AbstractExprRelDataType) {
            AbstractExprRelDataType exprRelDataType = (AbstractExprRelDataType)type;
            return exprRelDataType.getJavaType();
        }
        return super.getJavaClass(type);
    }

    public static boolean isUserDefinedType(RelDataType type) {
        return type instanceof AbstractExprRelDataType;
    }

    public static boolean isNumericType(RelDataType fieldType) {
        SqlTypeName sqlType = fieldType.getSqlTypeName();
        if (sqlType == SqlTypeName.INTEGER || sqlType == SqlTypeName.BIGINT || sqlType == SqlTypeName.SMALLINT || sqlType == SqlTypeName.TINYINT || sqlType == SqlTypeName.FLOAT || sqlType == SqlTypeName.DOUBLE || sqlType == SqlTypeName.DECIMAL || sqlType == SqlTypeName.REAL) {
            return true;
        }
        if (sqlType == SqlTypeName.VARCHAR || sqlType == SqlTypeName.CHAR) {
            return true;
        }
        if (OpenSearchTypeFactory.isUserDefinedType(fieldType)) {
            AbstractExprRelDataType exprType = (AbstractExprRelDataType)fieldType;
            ExprType udtType = exprType.getExprType();
            return ExprCoreType.numberTypes().contains(udtType);
        }
        return false;
    }

    public static boolean isTimeBasedType(RelDataType fieldType) {
        SqlTypeName sqlType = fieldType.getSqlTypeName();
        if (sqlType == SqlTypeName.TIMESTAMP || sqlType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE || sqlType == SqlTypeName.DATE || sqlType == SqlTypeName.TIME || sqlType == SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE) {
            return true;
        }
        if (OpenSearchTypeFactory.isUserDefinedType(fieldType)) {
            AbstractExprRelDataType exprType = (AbstractExprRelDataType)fieldType;
            ExprType udtType = exprType.getExprType();
            return udtType == ExprCoreType.TIMESTAMP || udtType == ExprCoreType.DATE || udtType == ExprCoreType.TIME;
        }
        return fieldType.toString().contains("EXPR_TIMESTAMP");
    }

    public static enum ExprUDT {
        EXPR_DATE(ExprCoreType.DATE),
        EXPR_TIME(ExprCoreType.TIME),
        EXPR_TIMESTAMP(ExprCoreType.TIMESTAMP),
        EXPR_BINARY(ExprCoreType.BINARY),
        EXPR_IP(ExprCoreType.IP);

        private final ExprCoreType exprCoreType;

        private ExprUDT(ExprCoreType exprCoreType) {
            this.exprCoreType = exprCoreType;
        }

        @Generated
        public ExprCoreType getExprCoreType() {
            return this.exprCoreType;
        }
    }
}

