/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.cryptacular.CryptUtil;
import org.cryptacular.CryptoException;
import org.cryptacular.bean.FactoryBean;

public class KeyStoreBasedKeyFactoryBean<T extends Key>
implements FactoryBean<T> {
    private final KeyStore keyStore;
    private final String alias;
    private final String password;

    public KeyStoreBasedKeyFactoryBean(KeyStore keyStore, String alias, String password) {
        this.keyStore = CryptUtil.assertNotNullArg(keyStore, "KeyStore cannot be null");
        this.alias = alias;
        this.password = password;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public T newInstance() {
        Key key;
        try {
            key = this.keyStore.getKey(this.alias, this.password.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoException("Error accessing keystore entry " + this.alias, e);
        }
        return (T)key;
    }
}

