/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ConstMatNode extends ImplicitNode {

	public ConstMatNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Sets the matrix value of the node
	 *
	 * @param value the value
	 * @throws Lib3MFException
	 */
	public void setMatrix(Matrix4x4 value) throws Lib3MFException {
		Pointer bufferValue = new Memory(Matrix4x4.SIZE);
		value.writeToPointer(bufferValue, 0);
		mWrapper.checkError(this, mWrapper.lib3mf_constmatnode_setmatrix.invokeInt(new java.lang.Object[]{mHandle, bufferValue}));
	}

	/**
	 * Retrieves the matrix value of the node
	 *
	 * @return the matrix
	 * @throws Lib3MFException
	 */
	public Matrix4x4 getMatrix() throws Lib3MFException {
		Pointer bufferValue = new Memory(Matrix4x4.SIZE);
		mWrapper.checkError(this, mWrapper.lib3mf_constmatnode_getmatrix.invokeInt(new java.lang.Object[]{mHandle, bufferValue}));
		Matrix4x4 value = new Matrix4x4();
		value.readFromPointer(bufferValue, 0);
		return value;
	}

	/**
	 * Retrieves the output
	 *
	 * @return the output
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputMatrix() throws Lib3MFException {
		Pointer bufferMatrix = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_constmatnode_getoutputmatrix.invokeInt(new java.lang.Object[]{mHandle, bufferMatrix}));
		Pointer valueMatrix = bufferMatrix.getPointer(0);
		ImplicitPort matrix = null;
		if (valueMatrix == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Matrix was a null pointer");
		}
		matrix = mWrapper.PolymorphicFactory(valueMatrix, ImplicitPort.class);
		return matrix;
	}


}

