/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import java.util.HashMap;
import java.util.Map;

public class Lib3MFException extends Exception {

	// Error Constants for Lib3MF
	public static final int LIB3MF_SUCCESS = 0;
	public static final int LIB3MF_ERROR_NOTIMPLEMENTED = 1;
	public static final int LIB3MF_ERROR_INVALIDPARAM = 2;
	public static final int LIB3MF_ERROR_INVALIDCAST = 3;
	public static final int LIB3MF_ERROR_BUFFERTOOSMALL = 4;
	public static final int LIB3MF_ERROR_GENERICEXCEPTION = 5;
	public static final int LIB3MF_ERROR_COULDNOTLOADLIBRARY = 6;
	public static final int LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT = 7;
	public static final int LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION = 8;
	public static final int LIB3MF_ERROR_CALCULATIONABORTED = 10;
	public static final int LIB3MF_ERROR_SHOULDNOTBECALLED = 11;
	public static final int LIB3MF_ERROR_READERCLASSUNKNOWN = 100;
	public static final int LIB3MF_ERROR_WRITERCLASSUNKNOWN = 101;
	public static final int LIB3MF_ERROR_ITERATORINVALIDINDEX = 102;
	public static final int LIB3MF_ERROR_INVALIDMODELRESOURCE = 103;
	public static final int LIB3MF_ERROR_RESOURCENOTFOUND = 104;
	public static final int LIB3MF_ERROR_INVALIDMODEL = 105;
	public static final int LIB3MF_ERROR_INVALIDOBJECT = 106;
	public static final int LIB3MF_ERROR_INVALIDMESHOBJECT = 107;
	public static final int LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT = 108;
	public static final int LIB3MF_ERROR_INVALIDCOMPONENT = 109;
	public static final int LIB3MF_ERROR_INVALIDBUILDITEM = 110;
	public static final int LIB3MF_ERROR_INVALIDBASEMATERIALGROUP = 111;
	public static final int LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE = 112;
	public static final int LIB3MF_ERROR_INVALIDTEXTURERESOURCE = 113;
	public static final int LIB3MF_ERROR_INVALIDCOLORGROUP = 114;
	public static final int LIB3MF_ERROR_INVALIDTEXTURE2DGROUP = 115;
	public static final int LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS = 116;
	public static final int LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP = 117;
	public static final int LIB3MF_ERROR_INVALIDRESOURCEINDEX = 120;
	public static final int LIB3MF_ERROR_ATTACHMENTNOTFOUND = 121;
	public static final int LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE = 130;
	public static final int LIB3MF_ERROR_INVALIDATTACHMENTSTREAM = 131;
	public static final int LIB3MF_ERROR_INVALIDPROPERTYCOUNT = 132;
	public static final int LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER = 140;
	public static final int LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT = 141;
	public static final int LIB3MF_ERROR_INVALIDRESOURCE = 142;
	public static final int LIB3MF_ERROR_INVALIDLEVELSET = 143;
	public static final int LIB3MF_ERROR_COULDNOTFINDTRIANGLESET = 144;
	public static final int LIB3MF_ERROR_INVALIDTRIANGLESETINDEX = 145;
	public static final int LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE = 2000;
	public static final int LIB3MF_ERROR_INVALIDKEYSTORE = 3000;
	public static final int LIB3MF_ERROR_INVALIDKEYSTORECONSUMER = 3001;
	public static final int LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND = 3002;
	public static final int LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND = 3003;
	public static final int LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED = 3004;
	public static final int LIB3MF_ERROR_INVALIDKEYSIZE = 3005;
	public static final int LIB3MF_ERROR_INCOMPATIBLEPORTTYPES = 4000;
	public static final int LIB3MF_ERROR_GRAPHISCYCLIC = 4001;
	public static final int LIB3MF_ERROR_INPUTNOTSET = 4002;
	public static final int LIB3MF_ERROR_INVALIDNODECONFIGURATION = 4003;

	public static final Map<Integer, String> ErrorCodeMap = new HashMap<Integer, String>();
	public static final Map<Integer, String> ErrorDescriptionMap = new HashMap<Integer, String>();

	static {
		ErrorCodeMap.put(LIB3MF_ERROR_NOTIMPLEMENTED, "LIB3MF_ERROR_NOTIMPLEMENTED");
		ErrorDescriptionMap.put(LIB3MF_ERROR_NOTIMPLEMENTED, "functionality not implemented");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDPARAM, "LIB3MF_ERROR_INVALIDPARAM");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDPARAM, "an invalid parameter was passed");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDCAST, "LIB3MF_ERROR_INVALIDCAST");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDCAST, "a type cast failed");
		ErrorCodeMap.put(LIB3MF_ERROR_BUFFERTOOSMALL, "LIB3MF_ERROR_BUFFERTOOSMALL");
		ErrorDescriptionMap.put(LIB3MF_ERROR_BUFFERTOOSMALL, "a provided buffer is too small");
		ErrorCodeMap.put(LIB3MF_ERROR_GENERICEXCEPTION, "LIB3MF_ERROR_GENERICEXCEPTION");
		ErrorDescriptionMap.put(LIB3MF_ERROR_GENERICEXCEPTION, "a generic exception occurred");
		ErrorCodeMap.put(LIB3MF_ERROR_COULDNOTLOADLIBRARY, "LIB3MF_ERROR_COULDNOTLOADLIBRARY");
		ErrorDescriptionMap.put(LIB3MF_ERROR_COULDNOTLOADLIBRARY, "the library could not be loaded");
		ErrorCodeMap.put(LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT, "LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT, "a required exported symbol could not be found in the library");
		ErrorCodeMap.put(LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION, "LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION, "the version of the binary interface does not match the bindings interface");
		ErrorCodeMap.put(LIB3MF_ERROR_CALCULATIONABORTED, "LIB3MF_ERROR_CALCULATIONABORTED");
		ErrorDescriptionMap.put(LIB3MF_ERROR_CALCULATIONABORTED, "a calculation has been aborted");
		ErrorCodeMap.put(LIB3MF_ERROR_SHOULDNOTBECALLED, "LIB3MF_ERROR_SHOULDNOTBECALLED");
		ErrorDescriptionMap.put(LIB3MF_ERROR_SHOULDNOTBECALLED, "functionality should not be called");
		ErrorCodeMap.put(LIB3MF_ERROR_READERCLASSUNKNOWN, "LIB3MF_ERROR_READERCLASSUNKNOWN");
		ErrorDescriptionMap.put(LIB3MF_ERROR_READERCLASSUNKNOWN, "the queried reader class is unknown");
		ErrorCodeMap.put(LIB3MF_ERROR_WRITERCLASSUNKNOWN, "LIB3MF_ERROR_WRITERCLASSUNKNOWN");
		ErrorDescriptionMap.put(LIB3MF_ERROR_WRITERCLASSUNKNOWN, "the queried writer class is unknown");
		ErrorCodeMap.put(LIB3MF_ERROR_ITERATORINVALIDINDEX, "LIB3MF_ERROR_ITERATORINVALIDINDEX");
		ErrorDescriptionMap.put(LIB3MF_ERROR_ITERATORINVALIDINDEX, "the current index of an iterator is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDMODELRESOURCE, "LIB3MF_ERROR_INVALIDMODELRESOURCE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDMODELRESOURCE, "no Model Resource has been given");
		ErrorCodeMap.put(LIB3MF_ERROR_RESOURCENOTFOUND, "LIB3MF_ERROR_RESOURCENOTFOUND");
		ErrorDescriptionMap.put(LIB3MF_ERROR_RESOURCENOTFOUND, "Resource not found");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDMODEL, "LIB3MF_ERROR_INVALIDMODEL");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDMODEL, "A model is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDOBJECT, "LIB3MF_ERROR_INVALIDOBJECT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDOBJECT, "An object is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDMESHOBJECT, "LIB3MF_ERROR_INVALIDMESHOBJECT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDMESHOBJECT, "A mesh object is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT, "LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT, "A components object is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDCOMPONENT, "LIB3MF_ERROR_INVALIDCOMPONENT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDCOMPONENT, "A component is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDBUILDITEM, "LIB3MF_ERROR_INVALIDBUILDITEM");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDBUILDITEM, "A build item is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDBASEMATERIALGROUP, "LIB3MF_ERROR_INVALIDBASEMATERIALGROUP");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDBASEMATERIALGROUP, "A basematerialgroup is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE, "LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE, "A slicestack resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDTEXTURERESOURCE, "LIB3MF_ERROR_INVALIDTEXTURERESOURCE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDTEXTURERESOURCE, "A texture resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDCOLORGROUP, "LIB3MF_ERROR_INVALIDCOLORGROUP");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDCOLORGROUP, "A color group resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDTEXTURE2DGROUP, "LIB3MF_ERROR_INVALIDTEXTURE2DGROUP");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDTEXTURE2DGROUP, "A texture2d group resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS, "LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS, "A composite materials resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP, "LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP, "A MultiPropertyGroup resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDRESOURCEINDEX, "LIB3MF_ERROR_INVALIDRESOURCEINDEX");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDRESOURCEINDEX, "A resource index is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_ATTACHMENTNOTFOUND, "LIB3MF_ERROR_ATTACHMENTNOTFOUND");
		ErrorDescriptionMap.put(LIB3MF_ERROR_ATTACHMENTNOTFOUND, "Attachment not found");
		ErrorCodeMap.put(LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE, "LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE, "A component references one of its ancestors");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDATTACHMENTSTREAM, "LIB3MF_ERROR_INVALIDATTACHMENTSTREAM");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDATTACHMENTSTREAM, "An attachment stream is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDPROPERTYCOUNT, "LIB3MF_ERROR_INVALIDPROPERTYCOUNT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDPROPERTYCOUNT, "Invalid property count.");
		ErrorCodeMap.put(LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER, "LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER");
		ErrorDescriptionMap.put(LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER, "A progress identifier is unknown");
		ErrorCodeMap.put(LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT, "LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT");
		ErrorDescriptionMap.put(LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT, "An element buffer exceeds its spec limit");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDRESOURCE, "LIB3MF_ERROR_INVALIDRESOURCE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDRESOURCE, "A resource is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDLEVELSET, "LIB3MF_ERROR_INVALIDLEVELSET");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDLEVELSET, "A level set is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_COULDNOTFINDTRIANGLESET, "LIB3MF_ERROR_COULDNOTFINDTRIANGLESET");
		ErrorDescriptionMap.put(LIB3MF_ERROR_COULDNOTFINDTRIANGLESET, "Could not find triangle set");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDTRIANGLESETINDEX, "LIB3MF_ERROR_INVALIDTRIANGLESETINDEX");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDTRIANGLESETINDEX, "Invalid triangle set index");
		ErrorCodeMap.put(LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE, "LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE, "This object type is not valid for beamlattices");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDKEYSTORE, "LIB3MF_ERROR_INVALIDKEYSTORE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDKEYSTORE, "The keystore object is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDKEYSTORECONSUMER, "LIB3MF_ERROR_INVALIDKEYSTORECONSUMER");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDKEYSTORECONSUMER, "The consumer keystore object is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND, "LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND");
		ErrorDescriptionMap.put(LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND, "A consumer has not been found");
		ErrorCodeMap.put(LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND, "LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND");
		ErrorDescriptionMap.put(LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND, "A resource data has not been found");
		ErrorCodeMap.put(LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED, "LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED");
		ErrorDescriptionMap.put(LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED, "A Key or Conentent encryption callback has not been registered");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDKEYSIZE, "LIB3MF_ERROR_INVALIDKEYSIZE");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDKEYSIZE, "The key size is invalid");
		ErrorCodeMap.put(LIB3MF_ERROR_INCOMPATIBLEPORTTYPES, "LIB3MF_ERROR_INCOMPATIBLEPORTTYPES");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INCOMPATIBLEPORTTYPES, "Link could not be added, the port types are incompatible");
		ErrorCodeMap.put(LIB3MF_ERROR_GRAPHISCYCLIC, "LIB3MF_ERROR_GRAPHISCYCLIC");
		ErrorDescriptionMap.put(LIB3MF_ERROR_GRAPHISCYCLIC, "The functin graph is cyclic. Only dircected graphs are valid and can be topological sorted.");
		ErrorCodeMap.put(LIB3MF_ERROR_INPUTNOTSET, "LIB3MF_ERROR_INPUTNOTSET");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INPUTNOTSET, "The input of a node is not set.");
		ErrorCodeMap.put(LIB3MF_ERROR_INVALIDNODECONFIGURATION, "LIB3MF_ERROR_INVALIDNODECONFIGURATION");
		ErrorDescriptionMap.put(LIB3MF_ERROR_INVALIDNODECONFIGURATION, "The selected node configuration is not supported");
	}

	protected int mErrorCode;

	protected String mErrorString;

	protected String mErrorDescription;

	public Lib3MFException(int errorCode, String message){
		super(message);
		mErrorCode = errorCode;
		mErrorString = ErrorCodeMap.get(errorCode);
		mErrorString = (mErrorString != null) ? mErrorString : "Unknown error code";
		mErrorDescription = ErrorDescriptionMap.get(errorCode);
		mErrorDescription = (mErrorDescription != null) ? mErrorDescription : "";
	}

	@Override
	public String toString() {
		return mErrorCode + ": " + mErrorString + " (" + mErrorDescription + " - " + getMessage() + ")";
	}
}

