/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.ColumnReferenceCheckingSqlAstWalker;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.jboss.logging.Logger;

public class TableBasedSoftDeleteHandler
extends AbstractMutationHandler
implements DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedSoftDeleteHandler.class);
    private final TemporaryTable idTable;
    private final TemporaryTableStrategy temporaryTableStrategy;
    private final boolean forceDropAfterUse;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> resolvedParameterMappingModelTypes;
    private final @Nullable JdbcParameter sessionUidParameter;
    private final @Nullable CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> idTableInsert;
    private final JdbcOperationQueryMutation softDelete;

    public TableBasedSoftDeleteHandler(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, TemporaryTable idTable, TemporaryTableStrategy temporaryTableStrategy, boolean forceDropAfterUse, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        super(sqmDelete, context.getSession().getSessionFactory());
        boolean needsSubQuery;
        this.idTable = idTable;
        this.temporaryTableStrategy = temporaryTableStrategy;
        this.forceDropAfterUse = forceDropAfterUse;
        this.sessionUidAccess = sessionUidAccess;
        TemporaryTableSessionUidColumn sessionUidColumn = idTable.getSessionUidColumn();
        this.sessionUidParameter = sessionUidColumn == null ? null : new SqlTypedMappingJdbcParameter(sessionUidColumn);
        MultiTableSqmMutationConverter converter = new MultiTableSqmMutationConverter(this.getEntityDescriptor(), (SqmStatement<?>)sqmDelete, (SqmRoot<?>)sqmDelete.getTarget(), domainParameterXref, context.getQueryOptions(), context.getSession().getLoadQueryInfluencers(), context.getQueryParameterBindings(), this.getSessionFactory().getSqlTranslationEngine());
        String targetEntityName = ((SqmRoot)sqmDelete.getTarget()).getEntityName();
        EntityPersister targetEntityDescriptor = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(targetEntityName);
        EntityMappingType rootEntityDescriptor = targetEntityDescriptor.getRootEntityDescriptor();
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        TableGroup deletingTableGroup = converter.getMutatingTableGroup();
        TableDetails softDeleteTable = rootEntityDescriptor.getSoftDeleteTableDetails();
        NamedTableReference rootTableReference = (NamedTableReference)deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), softDeleteTable.getTableName());
        assert (rootTableReference != null);
        Predicate specifiedRestriction = converter.visitWhereClause(sqmDelete.getWhereClause());
        PredicateCollector predicateCollector = new PredicateCollector(specifiedRestriction);
        targetEntityDescriptor.applyBaseRestrictions(predicateCollector, deletingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, converter);
        converter.pruneTableGroupJoins();
        ColumnReferenceCheckingSqlAstWalker walker = new ColumnReferenceCheckingSqlAstWalker(rootTableReference.getIdentificationVariable());
        if (predicateCollector.getPredicate() != null) {
            predicateCollector.getPredicate().accept(walker);
        }
        this.domainParameterXref = domainParameterXref;
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, converter);
        this.resolvedParameterMappingModelTypes = converter.getSqmParameterMappingModelExpressibleResolutions();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedSoftDeleteHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(idTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(sessionUidAccess.apply(context.getSession()))));
        }
        boolean bl = needsSubQuery = !walker.isAllColumnReferencesFromIdentificationVariable() || targetEntityDescriptor != rootEntityDescriptor;
        if (needsSubQuery) {
            if (this.getSessionFactory().getJdbcServices().getDialect().supportsSubqueryOnMutatingTable()) {
                this.idTableInsert = null;
                this.softDelete = this.createDeleteWithSubQuery(rootEntityDescriptor, deletingTableGroup, rootTableReference, predicateCollector, jdbcParameterBindings, converter, executionContext);
            } else {
                this.idTableInsert = ExecuteWithTemporaryTableHelper.createMatchingIdsIntoIdTableInsert(converter, predicateCollector.getPredicate(), idTable, this.sessionUidParameter, jdbcParameterBindings, executionContext);
                this.softDelete = this.createDeleteUsingIdTable(rootEntityDescriptor, rootTableReference, predicateCollector, executionContext);
            }
        } else {
            this.idTableInsert = null;
            this.softDelete = this.createDirectDelete(rootEntityDescriptor, rootTableReference, predicateCollector, jdbcParameterBindings, executionContext);
        }
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
    }

    private JdbcOperationQueryMutation createDeleteUsingIdTable(EntityMappingType rootEntityDescriptor, NamedTableReference targetTableReference, PredicateCollector predicateCollector, SqmJdbcExecutionContextAdapter executionContext) {
        QuerySpec idTableIdentifierSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.getIdTable(), this.sessionUidParameter, this.getEntityDescriptor(), executionContext);
        Assignment softDeleteAssignment = rootEntityDescriptor.getSoftDeleteMapping().createSoftDeleteAssignment(targetTableReference);
        Expression idExpression = TableBasedSoftDeleteHandler.createIdExpression(rootEntityDescriptor, targetTableReference);
        UpdateStatement updateStatement = new UpdateStatement(targetTableReference, Collections.singletonList(softDeleteAssignment), (Predicate)new InSubQueryPredicate(idExpression, idTableIdentifierSubQuery, false));
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, updateStatement).translate(JdbcParameterBindings.NO_BINDINGS, executionContext.getQueryOptions());
    }

    private static Expression createIdExpression(EntityMappingType rootEntityDescriptor, NamedTableReference targetTableReference) {
        TableDetails softDeleteTable = rootEntityDescriptor.getSoftDeleteTableDetails();
        TableDetails.KeyDetails keyDetails = softDeleteTable.getKeyDetails();
        ArrayList idExpressions = new ArrayList(keyDetails.getColumnCount());
        keyDetails.forEachKeyColumn((position, column) -> idExpressions.add(new ColumnReference(targetTableReference, (SelectableMapping)column)));
        Expression idExpression = idExpressions.size() == 1 ? (Expression)idExpressions.get(0) : new SqlTuple(idExpressions, rootEntityDescriptor.getIdentifierMapping());
        return idExpression;
    }

    private JdbcOperationQueryMutation createDeleteWithSubQuery(EntityMappingType rootEntityDescriptor, TableGroup deletingTableGroup, NamedTableReference rootTableReference, PredicateCollector predicateCollector, JdbcParameterBindings jdbcParameterBindings, MultiTableSqmMutationConverter converter, SqmJdbcExecutionContextAdapter executionContext) {
        QuerySpec matchingIdSubQuery = new QuerySpec(false, 1);
        matchingIdSubQuery.getFromClause().addRoot(deletingTableGroup);
        TableDetails identifierTableDetails = rootEntityDescriptor.getIdentifierTableDetails();
        TableDetails.KeyDetails keyDetails = identifierTableDetails.getKeyDetails();
        NamedTableReference targetTable = new NamedTableReference(identifierTableDetails.getTableName(), "to_delete_", false);
        ArrayList idExpressions = new ArrayList(keyDetails.getColumnCount());
        keyDetails.forEachKeyColumn((position, column) -> {
            Expression columnReference = converter.getSqlExpressionResolver().resolveSqlExpression(rootTableReference, column);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, columnReference));
            idExpressions.add(new ColumnReference(targetTable, (SelectableMapping)column));
        });
        matchingIdSubQuery.applyPredicate(predicateCollector.getPredicate());
        Expression idExpression = idExpressions.size() == 1 ? (Expression)idExpressions.get(0) : new SqlTuple(idExpressions, rootEntityDescriptor.getIdentifierMapping());
        Assignment softDeleteAssignment = rootEntityDescriptor.getSoftDeleteMapping().createSoftDeleteAssignment(targetTable);
        UpdateStatement updateStatement = new UpdateStatement(targetTable, Collections.singletonList(softDeleteAssignment), (Predicate)new InSubQueryPredicate(idExpression, matchingIdSubQuery, false));
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, updateStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
    }

    private JdbcOperationQueryMutation createDirectDelete(EntityMappingType rootEntityDescriptor, NamedTableReference rootTableReference, PredicateCollector predicateCollector, JdbcParameterBindings jdbcParameterBindings, SqmJdbcExecutionContextAdapter executionContext) {
        Assignment softDeleteAssignment = rootEntityDescriptor.getSoftDeleteMapping().createSoftDeleteAssignment(rootTableReference);
        UpdateStatement updateStatement = new UpdateStatement(rootTableReference, Collections.singletonList(softDeleteAssignment), predicateCollector.getPredicate());
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, updateStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
    }

    @Override
    public JdbcParameterBindings createJdbcParameterBindings(DomainQueryExecutionContext context) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedSoftDeleteHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.idTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(context.getSession()))));
        }
        return jdbcParameterBindings;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        if (this.idTableInsert != null && this.idTableInsert.jdbcOperation().dependsOnParameterBindings()) {
            return true;
        }
        return this.softDelete.dependsOnParameterBindings();
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (this.idTableInsert != null && !this.idTableInsert.jdbcOperation().isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return false;
        }
        return this.softDelete.isCompatibleWith(jdbcParameterBindings, queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext context) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table delete execution - %s", (Object)((SqmRoot)this.getSqmStatement().getTarget()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcMutationExecutor jdbcMutationExecutor = factory.getJdbcServices().getJdbcMutationExecutor();
        if (this.idTableInsert != null) {
            ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, this.temporaryTableStrategy, (ExecutionContext)executionContext);
            try {
                int rows = ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(this.idTableInsert.jdbcOperation(), jdbcParameterBindings, (ExecutionContext)executionContext);
                JdbcParameterBindingsImpl sessionUidBindings = new JdbcParameterBindingsImpl(1);
                if (this.sessionUidParameter != null) {
                    sessionUidBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.sessionUidParameter.getExpressionType().getSingleJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(executionContext.getSession()))));
                }
                jdbcMutationExecutor.execute(this.softDelete, sessionUidBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
                int n = rows;
                return n;
            }
            finally {
                ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.getAfterUseAction(), executionContext);
            }
        }
        return jdbcMutationExecutor.execute(this.softDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    public @Nullable CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> getIdTableInsert() {
        return this.idTableInsert;
    }

    protected JdbcOperationQueryMutation getSoftDelete() {
        return this.softDelete;
    }

    protected AfterUseAction getAfterUseAction() {
        return this.forceDropAfterUse ? AfterUseAction.DROP : this.temporaryTableStrategy.getTemporaryTableAfterUseAction();
    }

    protected TemporaryTable getIdTable() {
        return this.idTable;
    }

    protected TemporaryTableStrategy getTemporaryTableStrategy() {
        return this.temporaryTableStrategy;
    }

    protected Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    protected @Nullable JdbcParameter getSessionUidParameter() {
        return this.sessionUidParameter;
    }
}

