/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.jetbrains.annotations.Nullable;

public class StatsHttpResponse {
    private static final DateTimeFormatter RFC1123_FORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final DateTimeFormatter RFC1036_FORMAT = DateTimeFormatter.ofPattern("EEE, dd-MMM-yy HH:mm:ss zzz");
    private static final DateTimeFormatter ASCTIME_FORMAT = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy");
    private static final DateTimeFormatter[] DATE_FORMATS = new DateTimeFormatter[]{RFC1123_FORMAT, RFC1036_FORMAT, ASCTIME_FORMAT};
    private final HttpResponse<String> myHttpResponse;
    private final int myCode;

    public StatsHttpResponse(@Nullable HttpResponse<String> httpResponse, int code) {
        this.myHttpResponse = httpResponse;
        this.myCode = code;
    }

    public int getStatusCode() {
        return this.myCode;
    }

    @Nullable
    public Long lastModified() {
        return this.myHttpResponse == null ? null : (Long)this.myHttpResponse.headers().allValues("Last-Modified").stream().map(value -> StatsHttpResponse.parseDate(value)).filter(date -> date != null).max(Long::compareTo).orElse(null);
    }

    @Nullable
    public String readAsString() throws IOException {
        return this.myHttpResponse != null && this.myHttpResponse.body() != null ? this.myHttpResponse.body() : null;
    }

    @Nullable
    public InputStream read() throws IOException {
        return this.myHttpResponse != null && this.myHttpResponse.body() != null ? new ByteArrayInputStream(this.myHttpResponse.body().getBytes(StandardCharsets.UTF_8)) : null;
    }

    @Nullable
    private static Long parseDate(String string) {
        for (DateTimeFormatter format : DATE_FORMATS) {
            try {
                return ZonedDateTime.parse(string, format).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }
}

