/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources.plural;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.plural.PluralCategory;
import org.jetbrains.compose.resources.plural.PluralRuleParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule;", "", "category", "Lorg/jetbrains/compose/resources/plural/PluralCategory;", "condition", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "<init>", "(Lorg/jetbrains/compose/resources/plural/PluralCategory;Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;)V", "", "(Lorg/jetbrains/compose/resources/plural/PluralCategory;Ljava/lang/String;)V", "getCategory", "()Lorg/jetbrains/compose/resources/plural/PluralCategory;", "appliesTo", "", "n", "", "Condition", "library"})
@StabilityInferred(parameters=1)
public final class PluralRule {
    @NotNull
    private final PluralCategory category;
    @NotNull
    private final Condition condition;
    public static final int $stable;

    private PluralRule(PluralCategory category, Condition condition) {
        this.category = category;
        this.condition = condition;
    }

    @NotNull
    public final PluralCategory getCategory() {
        return this.category;
    }

    public PluralRule(@NotNull PluralCategory category, @NotNull String condition) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this(category, Condition.Companion.parse(condition));
    }

    public final boolean appliesTo(int n) {
        return this.condition.isFulfilled(n);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00122\u00020\u0001:\b\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0000H&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0000H&\u0082\u0001\u0005\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "", "<init>", "()V", "isFulfilled", "", "n", "", "simplifyForInteger", "equivalentForInteger", "other", "Operand", "And", "Or", "Relation", "True", "False", "Parser", "Companion", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$And;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$False;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Or;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Relation;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$True;", "library"})
    private static abstract class Condition {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private Condition() {
        }

        public abstract boolean isFulfilled(int var1);

        @NotNull
        public abstract Condition simplifyForInteger();

        public abstract boolean equivalentForInteger(@NotNull Condition var1);

        public /* synthetic */ Condition(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0001H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$And;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "left", "right", "<init>", "(Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;)V", "isFulfilled", "", "n", "", "simplifyForInteger", "equivalentForInteger", "other", "toString", "", "library"})
        @StabilityInferred(parameters=1)
        public static final class And
        extends Condition {
            @NotNull
            private final Condition left;
            @NotNull
            private final Condition right;
            public static final int $stable;

            public And(@NotNull Condition left, @NotNull Condition right) {
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                super(null);
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean isFulfilled(int n) {
                return this.left.isFulfilled(n) && this.right.isFulfilled(n);
            }

            @Override
            @NotNull
            public Condition simplifyForInteger() {
                Condition leftSimplified = this.left.simplifyForInteger();
                if (Intrinsics.areEqual((Object)leftSimplified, (Object)False.INSTANCE)) {
                    return False.INSTANCE;
                }
                Condition rightSimplified = this.right.simplifyForInteger();
                if (Intrinsics.areEqual((Object)leftSimplified, (Object)True.INSTANCE)) {
                    return rightSimplified;
                }
                if (Intrinsics.areEqual((Object)rightSimplified, (Object)False.INSTANCE)) {
                    return False.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)rightSimplified, (Object)True.INSTANCE)) {
                    return leftSimplified;
                }
                if (leftSimplified.equivalentForInteger(rightSimplified)) {
                    return leftSimplified;
                }
                return new And(leftSimplified, rightSimplified);
            }

            @Override
            public boolean equivalentForInteger(@NotNull Condition other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this == other) {
                    return true;
                }
                if (!(other instanceof And)) {
                    return false;
                }
                return this.left.equivalentForInteger(((And)other).left) && this.right.equivalentForInteger(((And)other).right);
            }

            @NotNull
            public String toString() {
                return this.left + " and " + this.right;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Companion;", "", "<init>", "()V", "parse", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "description", "", "library"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Condition parse(@NotNull String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                return new Parser(description).parse().simplifyForInteger();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$False;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "<init>", "()V", "isFulfilled", "", "n", "", "simplifyForInteger", "equivalentForInteger", "other", "toString", "", "library"})
        private static final class False
        extends Condition {
            @NotNull
            public static final False INSTANCE = new False();

            private False() {
                super(null);
            }

            @Override
            public boolean isFulfilled(int n) {
                return false;
            }

            @Override
            @NotNull
            public False simplifyForInteger() {
                return this;
            }

            @Override
            public boolean equivalentForInteger(@NotNull Condition other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return Intrinsics.areEqual((Object)this, (Object)other);
            }

            @NotNull
            public String toString() {
                return "(false)";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Operand;", "", "<init>", "(Ljava/lang/String;I)V", "N", "I", "V", "W", "F", "T", "C", "library"})
        public static final class Operand
        extends Enum<Operand> {
            public static final /* enum */ Operand N = new Operand();
            public static final /* enum */ Operand I = new Operand();
            public static final /* enum */ Operand V = new Operand();
            public static final /* enum */ Operand W = new Operand();
            public static final /* enum */ Operand F = new Operand();
            public static final /* enum */ Operand T = new Operand();
            public static final /* enum */ Operand C = new Operand();
            private static final /* synthetic */ Operand[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Operand[] values() {
                return (Operand[])$VALUES.clone();
            }

            public static Operand valueOf(String value) {
                return Enum.valueOf(Operand.class, value);
            }

            @NotNull
            public static EnumEntries<Operand> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = operandArray = new Operand[]{Operand.N, Operand.I, Operand.V, Operand.W, Operand.F, Operand.T, Operand.C};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0001H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Or;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "left", "right", "<init>", "(Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;)V", "isFulfilled", "", "n", "", "simplifyForInteger", "equivalentForInteger", "other", "toString", "", "library"})
        @StabilityInferred(parameters=1)
        public static final class Or
        extends Condition {
            @NotNull
            private final Condition left;
            @NotNull
            private final Condition right;
            public static final int $stable;

            public Or(@NotNull Condition left, @NotNull Condition right) {
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                super(null);
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean isFulfilled(int n) {
                return this.left.isFulfilled(n) || this.right.isFulfilled(n);
            }

            @Override
            @NotNull
            public Condition simplifyForInteger() {
                Condition leftSimplified = this.left.simplifyForInteger();
                if (Intrinsics.areEqual((Object)leftSimplified, (Object)True.INSTANCE)) {
                    return True.INSTANCE;
                }
                Condition rightSimplified = this.right.simplifyForInteger();
                if (Intrinsics.areEqual((Object)leftSimplified, (Object)False.INSTANCE)) {
                    return rightSimplified;
                }
                if (Intrinsics.areEqual((Object)rightSimplified, (Object)True.INSTANCE)) {
                    return True.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)rightSimplified, (Object)False.INSTANCE)) {
                    return leftSimplified;
                }
                if (leftSimplified.equivalentForInteger(rightSimplified)) {
                    return leftSimplified;
                }
                return new Or(leftSimplified, rightSimplified);
            }

            @Override
            public boolean equivalentForInteger(@NotNull Condition other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Or)) {
                    return false;
                }
                return this.left.equivalentForInteger(((Or)other).left) && this.right.equivalentForInteger(((Or)other).right);
            }

            @NotNull
            public String toString() {
                return this.left + " or " + this.right;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\r\u0010\u001f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Parser;", "", "description", "", "<init>", "(Ljava/lang/String;)V", "currentIdx", "", "eof", "", "nextUnchecked", "", "consumeWhitespaces", "", "raise", "", "assert", "condition", "peekNextOrNull", "()Ljava/lang/Character;", "peekNext", "consumeNext", "consumeNextInt", "parse", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "nextCondition", "nextAndCondition", "nextRelation", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Relation;", "nextOperand", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Operand;", "nextModulusDivisor", "()Ljava/lang/Integer;", "nextComparisonIsNegated", "nextRange", "Lkotlin/ranges/IntRange;", "library"})
        @SourceDebugExtension(value={"SMAP\nPluralRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluralRule.kt\norg/jetbrains/compose/resources/plural/PluralRule$Condition$Parser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,406:1\n37#2:407\n36#2,3:408\n*S KotlinDebug\n*F\n+ 1 PluralRule.kt\norg/jetbrains/compose/resources/plural/PluralRule$Condition$Parser\n*L\n317#1:407\n317#1:408,3\n*E\n"})
        private static final class Parser {
            @NotNull
            private final String description;
            private int currentIdx;

            public Parser(@NotNull String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                this.description = description;
            }

            private final boolean eof() {
                return this.currentIdx >= this.description.length();
            }

            private final char nextUnchecked() {
                return this.description.charAt(this.currentIdx);
            }

            private final void consumeWhitespaces() {
                while (!this.eof() && CharsKt.isWhitespace((char)this.nextUnchecked())) {
                    ++this.currentIdx;
                }
            }

            private final Void raise() {
                throw new PluralRuleParseException(this.description, this.currentIdx + 1);
            }

            private final void assert(boolean condition) {
                if (!condition) {
                    this.raise();
                    throw new KotlinNothingValueException();
                }
            }

            private final Character peekNextOrNull() {
                return StringsKt.getOrNull((CharSequence)this.description, (int)this.currentIdx);
            }

            private final char peekNext() {
                Character c = this.peekNextOrNull();
                if (c == null) {
                    this.raise();
                    throw new KotlinNothingValueException();
                }
                return c.charValue();
            }

            private final char consumeNext() {
                char next = this.peekNext();
                ++this.currentIdx;
                return next;
            }

            private final int consumeNextInt() {
                int integerLastIdx;
                this.assert(Character.isDigit(this.peekNext()));
                int integerValue = 0;
                for (integerLastIdx = this.currentIdx; integerLastIdx < this.description.length() && Character.isDigit(this.description.charAt(integerLastIdx)); ++integerLastIdx) {
                    integerValue *= 10;
                    integerValue += this.description.charAt(integerLastIdx) - 48;
                }
                this.currentIdx = integerLastIdx;
                return integerValue;
            }

            @NotNull
            public final Condition parse() {
                this.consumeWhitespaces();
                if (this.eof()) {
                    return True.INSTANCE;
                }
                Condition condition = this.nextCondition();
                this.consumeWhitespaces();
                this.assert(this.eof());
                return condition;
            }

            private final Condition nextCondition() {
                Condition condition = this.nextAndCondition();
                while (true) {
                    this.consumeWhitespaces();
                    Character c = this.peekNextOrNull();
                    char c2 = 'o';
                    if (c == null || c.charValue() != c2) break;
                    this.consumeNext();
                    this.assert(this.consumeNext() == 'r');
                    condition = new Or(condition, this.nextAndCondition());
                }
                return condition;
            }

            private final Condition nextAndCondition() {
                Condition condition = this.nextRelation();
                while (true) {
                    this.consumeWhitespaces();
                    Character c = this.peekNextOrNull();
                    char c2 = 'a';
                    if (c == null || c.charValue() != c2) break;
                    this.consumeNext();
                    this.assert(this.consumeNext() == 'n');
                    this.assert(this.consumeNext() == 'd');
                    condition = new And(condition, this.nextRelation());
                }
                return condition;
            }

            @NotNull
            public final Relation nextRelation() {
                Operand operand = this.nextOperand();
                Integer divisor = this.nextModulusDivisor();
                boolean negated = this.nextComparisonIsNegated();
                Object[] objectArray = new IntRange[]{this.nextRange()};
                List ranges = CollectionsKt.mutableListOf((Object[])objectArray);
                while (true) {
                    Character c = this.peekNextOrNull();
                    char c2 = ',';
                    if (c == null || c.charValue() != c2) break;
                    this.consumeNext();
                    ranges.add(this.nextRange());
                }
                Collection $this$toTypedArray$iv = ranges;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return new Relation(operand, divisor, negated, thisCollection$iv.toArray(new IntRange[0]));
            }

            @NotNull
            public final Operand nextOperand() {
                Operand operand;
                this.consumeWhitespaces();
                switch (this.consumeNext()) {
                    case 'n': {
                        operand = Operand.N;
                        break;
                    }
                    case 'i': {
                        operand = Operand.I;
                        break;
                    }
                    case 'f': {
                        operand = Operand.F;
                        break;
                    }
                    case 't': {
                        operand = Operand.T;
                        break;
                    }
                    case 'v': {
                        operand = Operand.V;
                        break;
                    }
                    case 'w': {
                        operand = Operand.W;
                        break;
                    }
                    case 'c': 
                    case 'e': {
                        operand = Operand.C;
                        break;
                    }
                    default: {
                        this.raise();
                        throw new KotlinNothingValueException();
                    }
                }
                return operand;
            }

            @Nullable
            public final Integer nextModulusDivisor() {
                this.consumeWhitespaces();
                if (this.peekNext() == '%') {
                    this.consumeNext();
                    this.consumeWhitespaces();
                    return this.consumeNextInt();
                }
                return null;
            }

            public final boolean nextComparisonIsNegated() {
                this.consumeWhitespaces();
                switch (this.peekNext()) {
                    case '!': {
                        this.consumeNext();
                        this.assert(this.consumeNext() == '=');
                        return true;
                    }
                    case '=': {
                        this.consumeNext();
                        return false;
                    }
                }
                this.raise();
                throw new KotlinNothingValueException();
            }

            @NotNull
            public final IntRange nextRange() {
                this.consumeWhitespaces();
                int start = this.consumeNextInt();
                Character c = this.peekNextOrNull();
                char c2 = '.';
                if (c == null || c.charValue() != c2) {
                    return new IntRange(start, start);
                }
                this.consumeNext();
                this.assert(this.consumeNext() == '.');
                int endInclusive = this.consumeNextInt();
                return new IntRange(start, endInclusive);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0001H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Relation;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "operand", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Operand;", "operandDivisor", "", "comparisonIsNegated", "", "ranges", "", "Lkotlin/ranges/IntRange;", "<init>", "(Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$Operand;Ljava/lang/Integer;Z[Lkotlin/ranges/IntRange;)V", "Ljava/lang/Integer;", "[Lkotlin/ranges/IntRange;", "isFulfilled", "n", "simplifyForInteger", "equivalentForInteger", "other", "toString", "", "library"})
        @StabilityInferred(parameters=0)
        @SourceDebugExtension(value={"SMAP\nPluralRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluralRule.kt\norg/jetbrains/compose/resources/plural/PluralRule$Condition$Relation\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,406:1\n12637#2,2:407\n12637#2,2:409\n*S KotlinDebug\n*F\n+ 1 PluralRule.kt\norg/jetbrains/compose/resources/plural/PluralRule$Condition$Relation\n*L\n144#1:407,2\n156#1:409,2\n*E\n"})
        public static final class Relation
        extends Condition {
            @NotNull
            private final Operand operand;
            @Nullable
            private final Integer operandDivisor;
            private final boolean comparisonIsNegated;
            @NotNull
            private final IntRange[] ranges;
            public static final int $stable = 8;

            public Relation(@NotNull Operand operand, @Nullable Integer operandDivisor, boolean comparisonIsNegated, @NotNull IntRange[] ranges) {
                Intrinsics.checkNotNullParameter((Object)((Object)operand), (String)"operand");
                Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
                super(null);
                this.operand = operand;
                this.operandDivisor = operandDivisor;
                this.comparisonIsNegated = comparisonIsNegated;
                this.ranges = ranges;
            }

            @Override
            public boolean isFulfilled(int n) {
                boolean bl;
                block4: {
                    int n2;
                    switch (WhenMappings.$EnumSwitchMapping$0[this.operand.ordinal()]) {
                        case 1: 
                        case 2: {
                            n2 = Math.abs(n);
                            break;
                        }
                        default: {
                            n2 = 0;
                        }
                    }
                    int expressionOperandValue = n2;
                    int moduloAppliedValue = this.operandDivisor != null ? expressionOperandValue % this.operandDivisor : expressionOperandValue;
                    IntRange[] $this$any$iv = this.ranges;
                    boolean $i$f$any = false;
                    int n3 = $this$any$iv.length;
                    for (int i = 0; i < n3; ++i) {
                        IntRange element$iv;
                        IntRange it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        int n4 = it.getFirst();
                        boolean bl3 = moduloAppliedValue <= it.getLast() ? n4 <= moduloAppliedValue : false;
                        if (!bl3) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                return bl != this.comparisonIsNegated;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public Condition simplifyForInteger() {
                boolean bl;
                Condition condition;
                block5: {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.operand.ordinal()]) {
                        case 1: 
                        case 2: {
                            condition = new Relation(Operand.N, this.operandDivisor, this.comparisonIsNegated, this.ranges);
                            return condition;
                        }
                    }
                    IntRange[] $this$any$iv = this.ranges;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        IntRange element$iv;
                        IntRange it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        int n2 = it.getFirst();
                        boolean bl3 = 0 <= it.getLast() ? n2 <= 0 : false;
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                if (bl != this.comparisonIsNegated) {
                    condition = True.INSTANCE;
                    return condition;
                }
                condition = False.INSTANCE;
                return condition;
            }

            @Override
            public boolean equivalentForInteger(@NotNull Condition other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Relation)) {
                    return false;
                }
                if ((this.operand == Operand.N || this.operand == Operand.I) != (((Relation)other).operand == Operand.N || ((Relation)other).operand == Operand.I)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.operandDivisor, (Object)((Relation)other).operandDivisor)) {
                    return false;
                }
                if (this.comparisonIsNegated != ((Relation)other).comparisonIsNegated) {
                    return false;
                }
                return Arrays.equals(this.ranges, ((Relation)other).ranges);
            }

            @NotNull
            public String toString() {
                StringBuilder $this$toString_u24lambda_u242 = new StringBuilder();
                boolean bl = false;
                String string = this.operand.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                $this$toString_u24lambda_u242.append(string);
                if (this.operandDivisor != null) {
                    $this$toString_u24lambda_u242.append(" % ");
                    $this$toString_u24lambda_u242.append(this.operandDivisor);
                }
                $this$toString_u24lambda_u242.append(' ');
                if (this.comparisonIsNegated) {
                    $this$toString_u24lambda_u242.append('!');
                }
                $this$toString_u24lambda_u242.append("= ");
                boolean first = true;
                for (IntRange range : this.ranges) {
                    if (!first) {
                        $this$toString_u24lambda_u242.append(',');
                    }
                    first = false;
                    $this$toString_u24lambda_u242.append(range.getFirst());
                    if (range.getFirst() == range.getLast()) continue;
                    $this$toString_u24lambda_u242.append("..");
                    $this$toString_u24lambda_u242.append(range.getLast());
                }
                String string2 = $this$toString_u24lambda_u242.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"run(...)");
                return string2;
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Operand.values().length];
                    try {
                        nArray[Operand.N.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Operand.I.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/resources/plural/PluralRule$Condition$True;", "Lorg/jetbrains/compose/resources/plural/PluralRule$Condition;", "<init>", "()V", "isFulfilled", "", "n", "", "simplifyForInteger", "equivalentForInteger", "other", "toString", "", "library"})
        private static final class True
        extends Condition {
            @NotNull
            public static final True INSTANCE = new True();

            private True() {
                super(null);
            }

            @Override
            public boolean isFulfilled(int n) {
                return true;
            }

            @Override
            @NotNull
            public True simplifyForInteger() {
                return this;
            }

            @Override
            public boolean equivalentForInteger(@NotNull Condition other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return Intrinsics.areEqual((Object)this, (Object)other);
            }

            @NotNull
            public String toString() {
                return "";
            }
        }
    }
}

