/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.internal.tasks.TaskPropertyRegistration;
import org.gradle.api.tasks.TaskFilePropertyBuilder;

public class FilePropertyContainer<T extends TaskFilePropertyBuilder & TaskPropertyRegistration>
implements Iterable<T> {
    private final List<T> properties = new ArrayList<T>();
    private boolean changed;
    private int unnamedPropertyCounter;

    private FilePropertyContainer() {
    }

    public static <T extends TaskFilePropertyBuilder & TaskPropertyRegistration> FilePropertyContainer<T> create() {
        return new FilePropertyContainer<T>();
    }

    public void add(T property) {
        this.properties.add(property);
        this.changed = true;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.changed) {
            for (TaskFilePropertyBuilder propertySpec : this.properties) {
                String propertyName = ((TaskPropertyRegistration)propertySpec).getPropertyName();
                if (propertyName != null) continue;
                propertyName = "$" + ++this.unnamedPropertyCounter;
                propertySpec.withPropertyName(propertyName);
            }
            this.changed = false;
        }
        return this.properties.iterator();
    }
}

