/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.internal.classpath.RuntimeApiInfo;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginModuleRegistry
implements PluginModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginModuleRegistry.class);
    private final ModuleRegistry moduleRegistry;
    private final RuntimeApiInfo runtimeApiInfo;

    public DefaultPluginModuleRegistry(ModuleRegistry moduleRegistry, RuntimeApiInfo runtimeApiInfo) {
        this.moduleRegistry = moduleRegistry;
        this.runtimeApiInfo = runtimeApiInfo;
    }

    @Override
    public Set<Module> getApiModules() {
        Properties properties = this.runtimeApiInfo.getGradlePluginsProperties();
        return this.loadModules(properties);
    }

    @Override
    public Set<Module> getImplementationModules() {
        Properties properties = this.runtimeApiInfo.getGradleImplementationPluginsProperties();
        return this.loadModules(properties);
    }

    private Set<Module> loadModules(Properties properties) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (String pluginModule : properties.getProperty("plugins").split(",")) {
            try {
                modules.add(this.moduleRegistry.getModule(pluginModule));
            }
            catch (UnknownModuleException e) {
                LOGGER.debug("Cannot find module for plugin {}. Ignoring.", (Object)pluginModule);
            }
        }
        return modules;
    }
}

