---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Stripe live restricted key'
---

## Description

The response body contains content that matches the pattern of a Stripe live restricted key was identified. Restricted keys offer greater security by only allowing read or write access to specific API resources. A malicious actor with access to this key is limited by the scope defined for the key.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate your Stripe live restricted key:

- Sign in to your Stripe account and access <https://dashboard.stripe.com/apikeys>
- Ensure "Test mode" is disabled
- In the "Restricted keys" section, find the key that was identified and select the ellipsis in the right-hand side
- Select "Roll key..."
- In the "Roll API key" dialog, select an expiration date, for example "now"
- Select "Roll API Key"

For more information, please see [Stripe's documentation on rotating API keys](https://docs.stripe.com/keys#rolling-keys).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.175 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
