/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.AbstractMapEntry;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapProposal;
import ghidra.debug.api.modules.RegionMapProposal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegion;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultRegionMapProposal
extends AbstractMapProposal<TraceMemoryRegion, MemoryBlock, RegionMapProposal.RegionMapEntry>
implements RegionMapProposal {
    protected final List<TraceMemoryRegion> regions;
    protected final long snap;
    protected final Address fromBase;
    protected final Address toBase;
    protected final RegionMatcherMap matchers;

    protected static Trace getTrace(Collection<? extends TraceMemoryRegion> regions) {
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        return regions.iterator().next().getTrace();
    }

    protected DefaultRegionMapProposal(Collection<? extends TraceMemoryRegion> regions, long snap, Program program) {
        super(DefaultRegionMapProposal.getTrace(regions), program);
        this.snap = snap;
        this.regions = Collections.unmodifiableList(regions.stream().sorted(Comparator.comparing(r -> r.getMinAddress(snap))).collect(Collectors.toList()));
        this.fromBase = this.computeFromBase();
        this.toBase = program.getImageBase();
        this.matchers = new RegionMatcherMap(snap);
        this.processRegions();
        this.processProgram();
    }

    protected DefaultRegionMapProposal(TraceMemoryRegion region, long snap, Program program, MemoryBlock block) {
        super(region.getTrace(), program);
        this.regions = List.of(region);
        this.snap = snap;
        this.fromBase = region.getMinAddress(snap);
        this.toBase = program.getImageBase();
        this.matchers = new RegionMatcherMap(snap);
        this.processRegions();
        this.matchers.processToObject(block);
    }

    protected Address computeFromBase() {
        if (this.regions.isEmpty()) {
            return null;
        }
        return this.regions.get(0).getMinAddress(this.snap);
    }

    private void processRegions() {
        for (TraceMemoryRegion region : this.regions) {
            this.matchers.processFromObject(region);
        }
    }

    private void processProgram() {
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            this.matchers.processToObject(block);
        }
    }

    public double computeScore() {
        return this.matchers.averageScore();
    }

    public Map<TraceMemoryRegion, RegionMapProposal.RegionMapEntry> computeMap() {
        return this.matchers.computeMap(m -> new DefaultRegionMapEntry((TraceMemoryRegion)m.fromObject, this.snap, this.program, (MemoryBlock)m.toObject));
    }

    public MemoryBlock getToObject(TraceMemoryRegion from) {
        return (MemoryBlock)this.matchers.getToObject(from);
    }

    protected class RegionMatcherMap
    extends AbstractMapProposal.MatcherMap<Void, TraceMemoryRegion, MemoryBlock, RegionMatcher> {
        public RegionMatcherMap(long snap) {
            super(snap);
        }

        @Override
        protected RegionMatcher newMatcher(TraceMemoryRegion region, MemoryBlock block) {
            return new RegionMatcher(region, this.snap, block);
        }

        @Override
        protected Void getFromJoinKey(TraceMemoryRegion region) {
            return null;
        }

        @Override
        protected Void getToJoinKey(MemoryBlock block) {
            return null;
        }
    }

    public static class DefaultRegionMapEntry
    extends AbstractMapEntry<TraceMemoryRegion, MemoryBlock>
    implements RegionMapProposal.RegionMapEntry {
        public DefaultRegionMapEntry(TraceMemoryRegion region, long snap, Program program, MemoryBlock block) {
            super(region.getTrace(), region, snap, program, block);
        }

        public TraceMemoryRegion getRegion() {
            return (TraceMemoryRegion)this.getFromObject();
        }

        public String getRegionName() {
            return this.getRegion().getName(this.snap);
        }

        public Address getRegionMinAddress() {
            return this.getRegion().getMinAddress(this.snap);
        }

        public AddressRange getFromRange() {
            return this.getRegion().getRange(this.snap);
        }

        public MemoryBlock getBlock() {
            return (MemoryBlock)this.getToObject();
        }

        public AddressRange getToRange() {
            return new AddressRangeImpl(this.getBlock().getStart(), this.getBlock().getEnd());
        }

        public void setBlock(Program program, MemoryBlock block) {
            this.setToObject(program, block);
        }
    }

    protected class RegionMatcher
    extends AbstractMapProposal.Matcher<TraceMemoryRegion, MemoryBlock> {
        public RegionMatcher(TraceMemoryRegion region, long snap, MemoryBlock block) {
            super(region, snap, block);
        }

        @Override
        protected AddressRange getFromRange() {
            return this.fromObject == null ? null : ((TraceMemoryRegion)this.fromObject).getRange(this.snap);
        }

        @Override
        protected AddressRange getToRange() {
            return this.toObject == null ? null : new AddressRangeImpl(((MemoryBlock)this.toObject).getStart(), ((MemoryBlock)this.toObject).getEnd());
        }

        @Override
        protected double computeScore() {
            return this.computeLengthScore() + (double)this.computeOffsetScore();
        }

        protected int computeOffsetScore() {
            try {
                long fOff = this.fromRange.getMinAddress().subtract(DefaultRegionMapProposal.this.fromBase);
                long tOff = this.toRange.getMinAddress().subtract(DefaultRegionMapProposal.this.toBase);
                if (fOff == tOff) {
                    return 10;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return 0;
        }
    }
}

