/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import java.io.Serializable;

public class User
implements Comparable<User>,
Serializable {
    public static final long serialVersionUID = 2L;
    public static final String ANONYMOUS_USERNAME = "-anonymous-";
    public static final int READ_ONLY = 0;
    public static final int WRITE = 1;
    public static final int ADMIN = 2;
    private static final String[] types = new String[]{"read-only", "write", "admin"};
    private int permission;
    private String name;

    public User(String name, int permission) {
        this.name = name;
        if (permission < 0 || permission > 2) {
            throw new IllegalArgumentException("Invalid type: " + permission + "; must be READ_ONLY, WRITE, or ADMIN");
        }
        this.permission = permission;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.permission == 0;
    }

    public boolean hasWritePermission() {
        return this.permission == 1 || this.permission == 2;
    }

    public boolean isAdmin() {
        return this.permission == 2;
    }

    public int getPermissionType() {
        return this.permission;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append(" (");
        buf.append(types[this.permission]);
        buf.append(")");
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.permission;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.permission == other.permission;
    }

    @Override
    public int compareTo(User other) {
        int rc;
        if (this.name == null) {
            if (other.name != null) {
                return -1;
            }
        } else if (other.name != null) {
            return 1;
        }
        if ((rc = this.name.compareTo(other.name)) == 0) {
            return this.permission - other.permission;
        }
        return rc;
    }
}

