/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.carbon.OSType;
import org.catacombae.hfsexplorer.types.carbon.Point;

public class FInfo
implements StructElements {
    public static final int STRUCTSIZE = 16;
    private final OSType fdType;
    private final OSType fdCreator;
    private final byte[] fdFlags = new byte[2];
    private final Point fdLocation;
    private final byte[] fdFldr = new byte[2];

    public FInfo(byte[] data, int offset) {
        this.fdType = new OSType(data, offset + 0);
        this.fdCreator = new OSType(data, offset + 4);
        System.arraycopy(data, offset + 8, this.fdFlags, 0, 2);
        this.fdLocation = new Point(data, offset + 10);
        System.arraycopy(data, offset + 14, this.fdFldr, 0, 2);
    }

    public static int length() {
        return 16;
    }

    public OSType getFdType() {
        return this.fdType;
    }

    public OSType getFdCreator() {
        return this.fdCreator;
    }

    public short getFdFlags() {
        return Util.readShortBE(this.fdFlags);
    }

    public Point getFdLocation() {
        return this.fdLocation;
    }

    public short getFdFldr() {
        return Util.readShortBE(this.fdFldr);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " fdType: ");
        this.getFdType().print(ps, prefix + "  ");
        ps.println(prefix + " fdCreator: ");
        this.getFdCreator().print(ps, prefix + "  ");
        ps.println(prefix + " fdFlags: " + this.getFdFlags());
        ps.println(prefix + " fdLocation: ");
        this.getFdLocation().print(ps, prefix + "  ");
        ps.println(prefix + " fdFldr: " + this.getFdFldr());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "FInfo:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[FInfo.length()];
        int offset = 0;
        byte[] tempData = this.fdType.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.fdCreator.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.fdFlags, 0, result, offset += tempData.length, this.fdFlags.length);
        tempData = this.fdLocation.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.fdFlags.length, tempData.length);
        System.arraycopy(this.fdFldr, 0, result, offset += tempData.length, this.fdFldr.length);
        offset += this.fdFldr.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(FInfo.class.getSimpleName());
        db.add("fdType", this.fdType.getStructElements());
        db.add("fdCreator", this.fdCreator.getStructElements());
        db.addUIntBE("fdFlags", this.fdFlags);
        db.add("fdLocation", this.fdLocation.getStructElements());
        db.addSIntBE("fdFldr", this.fdFldr);
        return db.getResult();
    }
}

