/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GComboBox;
import docking.widgets.dialogs.InputDialog;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.RunningToolsPanel;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.model.WorkspaceChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.Border;

class WorkspacePanel
extends JPanel
implements WorkspaceChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String RUNNING_TOOLS_TITLE = "Running Tools";
    private static final Border ACTIVE_WORKSPACE_BORDER = BorderFactory.createTitledBorder("Running Tools");
    private static final String NO_ACTIVE_WORKSPACE = "INACTIVE";
    private static final Border INACTIVE_BORDER = BorderFactory.createTitledBorder("Running Tools: INACTIVE");
    static final int TYPICAL_NUM_RUNNING_TOOLS = 3;
    private JComboBox<String> workspaceChooser;
    private DefaultComboBoxModel<String> workspaceModel;
    private CardLayout workspaceManager;
    private JPanel inactivePanel;
    private JPanel runningToolsCardPanel;
    private HashMap<String, RunningToolsPanel> runningToolsMap;
    private Workspace activeWorkspace;
    private FrontEndPlugin plugin;
    private Project activeProject;
    private boolean valueIsAdjusting;

    WorkspacePanel(FrontEndPlugin plugin) {
        super(new BorderLayout(0, 0));
        this.plugin = plugin;
        this.workspaceManager = new CardLayout();
        this.runningToolsCardPanel = new JPanel(this.workspaceManager);
        this.runningToolsMap = new HashMap(3);
        this.workspaceModel = new DefaultComboBoxModel();
        this.workspaceChooser = new GComboBox(this.workspaceModel);
        this.workspaceChooser.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.chooseWorkspace((String)this.workspaceModel.getSelectedItem());
            }
        });
        this.workspaceChooser.setPreferredSize(new Dimension(200, (int)this.workspaceChooser.getPreferredSize().getHeight()));
        this.setHelpLocation();
        JPanel wcPanel = new JPanel();
        wcPanel.add(this.workspaceChooser);
        this.add((Component)wcPanel, "East");
        this.add((Component)this.runningToolsCardPanel, "Center");
        this.setBorder(INACTIVE_BORDER);
    }

    @Override
    public void toolRemoved(Workspace ws, PluginTool tool) {
        this.removeTool(ws.getName(), tool);
        this.plugin.getToolActionManager().enableConnectTools();
    }

    @Override
    public void toolAdded(Workspace ws, PluginTool tool) {
        this.addTool(ws.getName(), tool);
        this.plugin.getToolActionManager().enableConnectTools();
    }

    @Override
    public void workspaceAdded(Workspace ws) {
        if (ws == null) {
            return;
        }
        String wsName = ws.getName();
        RunningToolsPanel rtp = new RunningToolsPanel(this.plugin, ws);
        this.runningToolsCardPanel.add((Component)rtp, wsName);
        this.runningToolsMap.put(wsName, rtp);
        this.workspaceModel.addElement(wsName);
        this.validate();
    }

    @Override
    public void workspaceRemoved(Workspace ws) {
        if (ws == null) {
            return;
        }
        String workspaceName = ws.getName();
        this.workspaceModel.removeElement(workspaceName);
        RunningToolsPanel rtp = this.runningToolsMap.get(workspaceName);
        this.runningToolsMap.remove(workspaceName);
        this.runningToolsCardPanel.remove(rtp);
    }

    @Override
    public void workspaceSetActive(Workspace ws) {
        if (ws == null) {
            throw new IllegalArgumentException("Active Workspace cannot be null");
        }
        this.workspaceSetActive(ws, ws.getName());
    }

    private void workspaceSetActive(Workspace ws, String workspaceName) {
        this.activeWorkspace = ws;
        if (ws == null) {
            this.showInactiveWorkspace();
            return;
        }
        this.workspaceModel.setSelectedItem(workspaceName);
        this.workspaceManager.show(this.runningToolsCardPanel, workspaceName);
        this.setPanelEnabled(true);
        this.setBorder(ACTIVE_WORKSPACE_BORDER);
        this.validate();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.activeProject == null || this.activeWorkspace == null) {
            return;
        }
        String eventPropertyName = event.getPropertyName();
        if (eventPropertyName.equals("WorkspaceName")) {
            String oldName = (String)event.getOldValue();
            String newName = (String)event.getNewValue();
            this.renameWorkspace(this.activeWorkspace, oldName, newName);
            return;
        }
        Object eventSource = event.getSource();
        if (eventSource instanceof PluginTool) {
            PluginTool tool = (PluginTool)((Object)eventSource);
            ToolTemplate template = tool.getToolTemplate(true);
            ImageIcon icon = tool.getIconURL().getIcon();
            String workspaceName = this.activeWorkspace.getName();
            RunningToolsPanel rtp = this.runningToolsMap.get(workspaceName);
            if (eventPropertyName.equals("ToolName")) {
                rtp.toolNameChanged(tool);
            } else {
                rtp.updateToolButton(tool, template, icon);
            }
        }
    }

    void setActiveProject(Project project) {
        PluginTool[] tools;
        this.clearAll();
        if (project == null) {
            this.showInactiveWorkspace();
            this.activeProject = null;
            return;
        }
        if (this.activeProject != null) {
            ToolManager tm = this.activeProject.getToolManager();
            tm.removeWorkspaceChangeListener(this);
        }
        ToolManager toolManager = project.getToolManager();
        toolManager.addWorkspaceChangeListener(this);
        for (PluginTool tool : tools = toolManager.getRunningTools()) {
            tool.addPropertyChangeListener(this);
        }
        this.setPanelEnabled(true);
        this.activeProject = project;
        this.initProjectState(this.activeProject);
    }

    void addTool(String workspaceName, PluginTool runningTool) {
        RunningToolsPanel rtp = this.runningToolsMap.get(workspaceName);
        if (rtp != null) {
            rtp.addTool(runningTool);
            runningTool.addPropertyChangeListener(this);
        }
        this.validate();
        this.repaint();
    }

    void addWorkspace() {
        InputDialog nameDialog = new InputDialog("Create New Workspace", "Workspace Name", "Workspace");
        this.plugin.getTool().showDialog((DialogComponentProvider)nameDialog);
        if (nameDialog.isCanceled()) {
            return;
        }
        String workspaceName = nameDialog.getValue();
        try {
            ToolManager tm = this.activeProject.getToolManager();
            tm.createWorkspace(workspaceName);
        }
        catch (DuplicateNameException e) {
            String msg = "Workspace named: " + workspaceName + " already exists.";
            Msg.showError(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Workspace Name Exists", (Object)msg);
        }
    }

    private void chooseWorkspace(String workspaceName) {
        if (this.valueIsAdjusting) {
            return;
        }
        ToolManager tm = this.activeProject.getToolManager();
        Workspace[] workspaces = tm.getWorkspaces();
        Workspace ws = null;
        for (int w = 0; ws == null && w < workspaces.length; ++w) {
            if (!workspaces[w].getName().equals(workspaceName)) continue;
            ws = workspaces[w];
        }
        if (ws != null) {
            ws.setActive();
        }
    }

    void removeWorkspace() {
        if (this.activeWorkspace == null) {
            return;
        }
        String workspaceName = this.activeWorkspace.getName();
        if (!this.plugin.confirmDelete("Workspace: " + workspaceName)) {
            return;
        }
        ToolManager tm = this.activeProject.getToolManager();
        tm.removeWorkspace(this.activeWorkspace);
    }

    void renameWorkspace() {
        if (this.activeWorkspace == null) {
            return;
        }
        boolean done = false;
        while (!done) {
            String workspaceName = this.activeWorkspace.getName();
            InputDialog nameDialog = new InputDialog("Rename Workspace", "Workspace Name", workspaceName);
            this.plugin.getTool().showDialog((DialogComponentProvider)nameDialog);
            if (nameDialog.isCanceled()) {
                return;
            }
            String newName = nameDialog.getValue();
            if (newName.equals(workspaceName)) {
                return;
            }
            if (newName.length() <= 0) continue;
            try {
                this.activeWorkspace.setName(newName);
                break;
            }
            catch (DuplicateNameException e) {
                Msg.showError(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Error Renaming Workspace", (Object)("Workspace named: " + newName + " already exists."));
            }
        }
    }

    private void renameWorkspace(Workspace ws, String oldName, String newName) {
        RunningToolsPanel rtp = this.runningToolsMap.get(oldName);
        this.runningToolsMap.remove(oldName);
        this.runningToolsMap.put(newName, rtp);
        this.valueIsAdjusting = true;
        this.workspaceModel.removeElement(oldName);
        this.workspaceModel.addElement(newName);
        this.valueIsAdjusting = false;
        this.runningToolsCardPanel.remove(rtp);
        this.runningToolsCardPanel.add((Component)rtp, newName);
        this.workspaceSetActive(ws, newName);
    }

    private void initProjectState(Project project) {
        Workspace[] workspaces;
        this.valueIsAdjusting = true;
        ToolManager tm = project.getToolManager();
        for (Workspace workspace : workspaces = tm.getWorkspaces()) {
            this.workspaceAdded(workspace);
        }
        this.valueIsAdjusting = false;
        this.workspaceSetActive(tm.getActiveWorkspace());
    }

    Workspace getActiveWorkspace() {
        return this.activeWorkspace;
    }

    void setActiveWorkspace(Workspace ws) {
        this.chooseWorkspace(ws.getName());
    }

    private void clearAll() {
        this.runningToolsMap.clear();
        this.workspaceModel.removeAllElements();
        this.runningToolsCardPanel.removeAll();
        this.validate();
    }

    private void showInactiveWorkspace() {
        if (this.inactivePanel == null) {
            this.inactivePanel = new JPanel();
            this.runningToolsCardPanel.add((Component)this.inactivePanel, NO_ACTIVE_WORKSPACE);
        }
        if (this.runningToolsCardPanel.getComponentCount() == 0) {
            this.runningToolsCardPanel.add((Component)this.inactivePanel, NO_ACTIVE_WORKSPACE);
        }
        this.activeWorkspace = null;
        this.setPanelEnabled(false);
        this.workspaceManager.show(this.runningToolsCardPanel, NO_ACTIVE_WORKSPACE);
        this.setBorder(INACTIVE_BORDER);
    }

    private void removeTool(String workspaceName, PluginTool tool) {
        RunningToolsPanel rtp = this.runningToolsMap.get(workspaceName);
        if (rtp != null) {
            rtp.removeTool(tool);
            tool.removePropertyChangeListener(this);
        }
        this.validate();
        this.repaint();
    }

    private void setPanelEnabled(boolean enabled) {
        this.workspaceChooser.setEnabled(enabled);
        this.runningToolsCardPanel.setEnabled(enabled);
        this.validate();
        this.repaint();
    }

    private void setHelpLocation() {
        HelpService help = Help.getHelpService();
        help.registerHelp(this.workspaceChooser, new HelpLocation(this.plugin.getName(), "Workspace"));
    }
}

