/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class X86_32_ElfExtension
extends ElfExtension {
    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 3 && elf.is32Bit();
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "x86".equals(language.getProcessor().toString()) && language.getLanguageDescription().getSize() == 32;
    }

    public String getDataTypeSuffix() {
        return "_x86";
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        if (!this.canHandle(elfLoadHelper)) {
            return;
        }
        super.processGotPlt(elfLoadHelper, monitor);
        this.processX86PltSections(elfLoadHelper, monitor);
    }

    private void processX86PltSections(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        long pltgotOffset;
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        ElfDynamicTable dynamicTable = elfHeader.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(ElfDynamicType.DT_PLTGOT)) {
            return;
        }
        try {
            pltgotOffset = elfHeader.adjustAddressForPrelink(dynamicTable.getDynamicValue(ElfDynamicType.DT_PLTGOT));
            pltgotOffset = elfLoadHelper.getDefaultAddress(pltgotOffset).getOffset();
        }
        catch (NotFoundException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
        Program program = elfLoadHelper.getProgram();
        Register ebxReg = program.getRegister("EBX");
        Memory memory = program.getMemory();
        String pltPrefix = ".plt.";
        for (ElfSectionHeader section : elfHeader.getSections()) {
            monitor.checkCancelled();
            String sectionName = section.getNameAsString();
            if (!section.isExecutable() || !sectionName.equals(".plt") && !sectionName.startsWith(pltPrefix)) continue;
            MemoryBlock pltBlock = memory.getBlock(sectionName);
            if (pltBlock == null) {
                elfLoadHelper.log("Skipped processing of " + sectionName + ": memory block not found");
                continue;
            }
            try {
                RegisterValue pltgotValue = new RegisterValue(ebxReg, BigInteger.valueOf(pltgotOffset));
                program.getProgramContext().setRegisterValue(pltBlock.getStart(), pltBlock.getEnd(), pltgotValue);
            }
            catch (ContextChangeException e) {
                throw new AssertException("unexpected", (Throwable)e);
            }
        }
    }
}

