/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeClass;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum DWARFAttribute {
    DW_AT_sibling(1, DWARFAttributeClass.reference),
    DW_AT_location(2, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist, DWARFAttributeClass.block, DWARFAttributeClass.constant),
    DW_AT_name(3, DWARFAttributeClass.string),
    DW_AT_ordering(9, DWARFAttributeClass.constant),
    DW_AT_byte_size(11, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_bit_offset(12, new DWARFAttributeClass[0]),
    DW_AT_bit_size(13, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_stmt_list(16, DWARFAttributeClass.lineptr, DWARFAttributeClass.constant),
    DW_AT_low_pc(17, DWARFAttributeClass.address),
    DW_AT_high_pc(18, DWARFAttributeClass.address, DWARFAttributeClass.constant),
    DW_AT_language(19, DWARFAttributeClass.constant),
    DW_AT_discr(21, DWARFAttributeClass.reference),
    DW_AT_discr_value(22, DWARFAttributeClass.constant),
    DW_AT_visibility(23, DWARFAttributeClass.constant),
    DW_AT_import(24, DWARFAttributeClass.reference),
    DW_AT_string_length(25, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist, DWARFAttributeClass.reference),
    DW_AT_common_reference(26, DWARFAttributeClass.reference),
    DW_AT_comp_dir(27, DWARFAttributeClass.string),
    DW_AT_const_value(28, DWARFAttributeClass.block, DWARFAttributeClass.constant, DWARFAttributeClass.string),
    DW_AT_containing_type(29, DWARFAttributeClass.reference),
    DW_AT_default_value(30, DWARFAttributeClass.constant, DWARFAttributeClass.reference, DWARFAttributeClass.flag),
    DW_AT_inline(32, DWARFAttributeClass.constant),
    DW_AT_is_optional(33, DWARFAttributeClass.flag),
    DW_AT_lower_bound(34, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_producer(37, DWARFAttributeClass.string),
    DW_AT_prototyped(39, DWARFAttributeClass.flag),
    DW_AT_return_addr(42, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist),
    DW_AT_start_scope(44, DWARFAttributeClass.constant, DWARFAttributeClass.rnglist),
    DW_AT_bit_stride(46, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_upper_bound(47, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_abstract_origin(49, DWARFAttributeClass.reference),
    DW_AT_accessibility(50, DWARFAttributeClass.constant),
    DW_AT_address_class(51, DWARFAttributeClass.constant),
    DW_AT_artificial(52, DWARFAttributeClass.flag),
    DW_AT_base_types(53, DWARFAttributeClass.reference),
    DW_AT_calling_convention(54, DWARFAttributeClass.constant),
    DW_AT_count(55, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_data_member_location(56, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist, DWARFAttributeClass.block),
    DW_AT_decl_column(57, DWARFAttributeClass.constant),
    DW_AT_decl_file(58, DWARFAttributeClass.constant),
    DW_AT_decl_line(59, DWARFAttributeClass.constant),
    DW_AT_declaration(60, DWARFAttributeClass.flag),
    DW_AT_discr_list(61, DWARFAttributeClass.block),
    DW_AT_encoding(62, DWARFAttributeClass.constant),
    DW_AT_external(63, DWARFAttributeClass.flag),
    DW_AT_frame_base(64, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist, DWARFAttributeClass.block, DWARFAttributeClass.constant),
    DW_AT_friend(65, DWARFAttributeClass.reference),
    DW_AT_identifier_case(66, DWARFAttributeClass.constant),
    DW_AT_macro_info(67, DWARFAttributeClass.macptr),
    DW_AT_namelist_item(68, DWARFAttributeClass.reference),
    DW_AT_priority(69, DWARFAttributeClass.reference),
    DW_AT_segment(70, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist),
    DW_AT_specification(71, DWARFAttributeClass.reference),
    DW_AT_static_link(72, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist),
    DW_AT_type(73, DWARFAttributeClass.reference),
    DW_AT_use_location(74, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist),
    DW_AT_variable_parameter(75, DWARFAttributeClass.flag),
    DW_AT_virtuality(76, DWARFAttributeClass.constant),
    DW_AT_vtable_elem_location(77, DWARFAttributeClass.exprloc, DWARFAttributeClass.loclist, DWARFAttributeClass.block),
    DW_AT_allocated(78, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_associated(79, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_data_location(80, DWARFAttributeClass.exprloc),
    DW_AT_byte_stride(81, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc, DWARFAttributeClass.reference),
    DW_AT_entry_pc(82, DWARFAttributeClass.address, DWARFAttributeClass.constant),
    DW_AT_use_UTF8(83, DWARFAttributeClass.flag),
    DW_AT_extension(84, DWARFAttributeClass.reference),
    DW_AT_ranges(85, DWARFAttributeClass.rnglist, DWARFAttributeClass.constant),
    DW_AT_trampoline(86, DWARFAttributeClass.address, DWARFAttributeClass.flag, DWARFAttributeClass.reference, DWARFAttributeClass.string),
    DW_AT_call_column(87, DWARFAttributeClass.constant),
    DW_AT_call_file(88, DWARFAttributeClass.constant),
    DW_AT_call_line(89, DWARFAttributeClass.constant),
    DW_AT_description(90, DWARFAttributeClass.string),
    DW_AT_binary_scale(91, DWARFAttributeClass.constant),
    DW_AT_decimal_scale(92, DWARFAttributeClass.constant),
    DW_AT_small(93, DWARFAttributeClass.reference),
    DW_AT_decimal_sign(94, DWARFAttributeClass.constant),
    DW_AT_digit_count(95, DWARFAttributeClass.constant),
    DW_AT_picture_string(96, DWARFAttributeClass.string),
    DW_AT_mutable(97, DWARFAttributeClass.flag),
    DW_AT_threads_scaled(98, DWARFAttributeClass.flag),
    DW_AT_explicit(99, DWARFAttributeClass.flag),
    DW_AT_object_pointer(100, DWARFAttributeClass.reference),
    DW_AT_endianity(101, DWARFAttributeClass.constant),
    DW_AT_elemental(102, DWARFAttributeClass.flag),
    DW_AT_pure(103, DWARFAttributeClass.flag),
    DW_AT_recursive(104, DWARFAttributeClass.flag),
    DW_AT_signature(105, DWARFAttributeClass.reference),
    DW_AT_main_subprogram(106, DWARFAttributeClass.flag),
    DW_AT_data_bit_offset(107, DWARFAttributeClass.constant),
    DW_AT_const_expr(108, DWARFAttributeClass.flag),
    DW_AT_enum_class(109, DWARFAttributeClass.flag),
    DW_AT_linkage_name(110, DWARFAttributeClass.string),
    DW_AT_string_length_bit_size(111, DWARFAttributeClass.constant),
    DW_AT_string_length_byte_size(112, DWARFAttributeClass.constant),
    DW_AT_rank(113, DWARFAttributeClass.constant, DWARFAttributeClass.exprloc),
    DW_AT_str_offsets_base(114, DWARFAttributeClass.stroffsetsptr),
    DW_AT_addr_base(115, DWARFAttributeClass.addrptr),
    DW_AT_rnglists_base(116, DWARFAttributeClass.rnglistsptr),
    DW_AT_dwo_name(118, DWARFAttributeClass.string),
    DW_AT_reference(119, DWARFAttributeClass.flag),
    DW_AT_rvalue_reference(120, DWARFAttributeClass.flag),
    DW_AT_macros(121, DWARFAttributeClass.macptr),
    DW_AT_call_all_calls(122, DWARFAttributeClass.flag),
    DW_AT_call_all_source_calls(123, DWARFAttributeClass.flag),
    DW_AT_call_all_tail_calls(124, DWARFAttributeClass.flag),
    DW_AT_call_return_pc(125, DWARFAttributeClass.address),
    DW_AT_call_value(126, DWARFAttributeClass.exprloc),
    DW_AT_call_origin(127, DWARFAttributeClass.reference),
    DW_AT_call_parameter(128, DWARFAttributeClass.reference),
    DW_AT_call_pc(129, DWARFAttributeClass.address),
    DW_AT_call_tail_call(130, DWARFAttributeClass.flag),
    DW_AT_call_target(131, DWARFAttributeClass.exprloc),
    DW_AT_call_target_clobbered(132, DWARFAttributeClass.exprloc),
    DW_AT_call_data_location(133, DWARFAttributeClass.exprloc),
    DW_AT_call_data_value(134, DWARFAttributeClass.exprloc),
    DW_AT_noreturn(135, DWARFAttributeClass.flag),
    DW_AT_alignment(136, DWARFAttributeClass.constant),
    DW_AT_export_symbols(137, DWARFAttributeClass.flag),
    DW_AT_deleted(138, DWARFAttributeClass.flag),
    DW_AT_defaulted(139, DWARFAttributeClass.constant),
    DW_AT_loclists_base(140, DWARFAttributeClass.loclistsptr),
    DW_AT_lo_user(8192, new DWARFAttributeClass[0]),
    DW_AT_hi_user(16383, new DWARFAttributeClass[0]),
    DW_AT_MIPS_linkage_name(8199, new DWARFAttributeClass[0]),
    DW_AT_GNU_dwo_name(8496, new DWARFAttributeClass[0]),
    DW_AT_GNU_dwo_id(8497, new DWARFAttributeClass[0]),
    DW_AT_GNU_ranges_base(8498, new DWARFAttributeClass[0]),
    DW_AT_GNU_addr_base(8499, new DWARFAttributeClass[0]),
    DW_AT_GNU_pubnames(8500, new DWARFAttributeClass[0]),
    DW_AT_GNU_pubtypes(8501, new DWARFAttributeClass[0]),
    DW_AT_go_kind(10496, new DWARFAttributeClass[0]),
    DW_AT_go_key(10497, new DWARFAttributeClass[0]),
    DW_AT_go_elem(10498, new DWARFAttributeClass[0]),
    DW_AT_go_embedded_field(10499, new DWARFAttributeClass[0]),
    DW_AT_go_runtime_type(10500, new DWARFAttributeClass[0]),
    DW_AT_go_package_name(10501, new DWARFAttributeClass[0]),
    DW_AT_go_dict_index(10502, new DWARFAttributeClass[0]),
    DW_AT_APPLE_ptrauth_key(15876, new DWARFAttributeClass[0]),
    DW_AT_APPLE_ptrauth_address_discriminated(15877, new DWARFAttributeClass[0]),
    DW_AT_APPLE_ptrauth_extra_discriminator(15878, new DWARFAttributeClass[0]),
    DW_AT_APPLE_omit_frame_ptr(16359, new DWARFAttributeClass[0]),
    DW_AT_APPLE_optimized(16353, new DWARFAttributeClass[0]);

    private int id;
    private Set<DWARFAttributeClass> attributeClass;
    public static final int EOL = 0;
    private static Map<Integer, DWARFAttribute> lookupMap;

    private DWARFAttribute(int id, DWARFAttributeClass ... attributeClass) {
        this.id = id;
        this.attributeClass = EnumSet.noneOf(DWARFAttributeClass.class);
        this.attributeClass.addAll(List.of(attributeClass));
    }

    public int getId() {
        return this.id;
    }

    public Set<DWARFAttributeClass> getAttributeClass() {
        return this.attributeClass;
    }

    public static DWARFAttribute of(int attributeInt) {
        return lookupMap.get(attributeInt);
    }

    private static Map<Integer, DWARFAttribute> buildLookup() {
        HashMap<Integer, DWARFAttribute> result = new HashMap<Integer, DWARFAttribute>();
        for (DWARFAttribute attr : DWARFAttribute.values()) {
            result.put(attr.id, attr);
        }
        return result;
    }

    static {
        lookupMap = DWARFAttribute.buildLookup();
    }

    public static class AttrDef
    extends DWARFAttributeDef<DWARFAttribute> {
        public static AttrDef read(BinaryReader reader) throws IOException {
            DWARFAttributeDef<DWARFAttribute> tmp = DWARFAttributeDef.read(reader, DWARFAttribute::of);
            if (tmp == null) {
                return null;
            }
            return new AttrDef(tmp.getAttributeId(), tmp.getRawAttributeId(), tmp.getAttributeForm(), tmp.getImplicitValue());
        }

        public AttrDef(DWARFAttribute attributeId, int rawAttributeId, DWARFForm attributeForm, long implicitValue) {
            super(attributeId, rawAttributeId, attributeForm, implicitValue);
        }

        @Override
        protected String getRawAttributeIdDescription() {
            return "DW_AT_???? %d (0x%x)".formatted(this.rawAttributeId, this.rawAttributeId);
        }

        public AttrDef withForm(DWARFForm newForm) {
            return new AttrDef((DWARFAttribute)this.attributeId, this.rawAttributeId, newForm, this.implicitValue);
        }
    }
}

