/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class MarkerPanel
extends JPanel {
    private MarkerManager manager;
    private Program program;
    private AddressIndexMap addrMap;
    private VerticalPixelAddressMap pixmap;

    MarkerPanel(MarkerManager manager) {
        this.manager = manager;
        this.setPreferredSize(new Dimension(16, 1));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    void setProgram(Program program, AddressIndexMap addrMap, VerticalPixelAddressMap pixmap) {
        this.program = program;
        this.addrMap = addrMap;
        this.pixmap = pixmap;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.manager.paintMarkers(this.program, g, this.pixmap, this.addrMap);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip = this.generateToolTip(event);
        this.manager.showToolTipPopup(event, tip);
        return null;
    }

    private static String toHTML(List<String> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        StringBuilder buffy = new StringBuilder("<html><font size=\"4\">");
        for (String string : lines) {
            buffy.append(string).append("<BR>");
        }
        return buffy.toString();
    }

    String generateToolTip(MouseEvent event) {
        if (this.pixmap == null) {
            return null;
        }
        int y = event.getY();
        int x = event.getX();
        int layoutIndex = this.pixmap.findLayoutAt(y);
        Address layoutAddress = this.pixmap.getLayoutAddress(layoutIndex);
        if (layoutAddress == null) {
            return null;
        }
        List<String> lines = this.getMarkerTooltipLines(y, x, layoutIndex, layoutAddress);
        return MarkerPanel.toHTML(lines);
    }

    private List<String> getMarkerTooltipLines(int y, int x, int layoutIndex, Address layoutAddress) {
        Address endAddr = this.pixmap.getLayoutEndAddress(layoutIndex);
        return this.manager.getMarkerTooltipLines(this.program, y, layoutIndex, layoutAddress, endAddr);
    }
}

