/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import help.validator.LinkDatabase;
import help.validator.model.TOCItem;
import help.validator.model.TOCItemDefinition;
import help.validator.model.TOCItemExternal;
import java.nio.file.Path;

public class TOCItemReference
extends TOCItem
implements Comparable<TOCItemReference> {
    public TOCItemReference(TOCItem parentItem, Path sourceTOCFile, String ID2, int lineNumber) {
        super(parentItem, sourceTOCFile, ID2, lineNumber);
    }

    @Override
    public boolean validate(LinkDatabase linkDatabase) {
        TOCItemDefinition definition = linkDatabase.getTOCDefinition(this);
        if (definition != null) {
            return true;
        }
        TOCItemExternal external = linkDatabase.getTOCExternal(this);
        return external != null;
    }

    @Override
    public String getTargetAttribute() {
        throw new IllegalStateException("TOC reference item has not been validated!: " + String.valueOf(this));
    }

    @Override
    public String generateTOCItemTag(LinkDatabase linkDatabase, boolean isInlineTag, int indentLevel) {
        String indent = INDENTS[indentLevel];
        StringBuilder buildy = new StringBuilder();
        buildy.append(indent).append("<!-- WARNING: Unresolved reference ID\n");
        buildy.append(indent).append('\t').append(this.generateXMLString()).append("\n");
        buildy.append(indent).append("-->");
        return buildy.toString();
    }

    @Override
    public int compareTo(TOCItemReference other) {
        if (other == null) {
            return 1;
        }
        int fileComparison = this.getSourceFile().compareTo(other.getSourceFile());
        if (fileComparison != 0) {
            return fileComparison;
        }
        return this.getIDAttribute().compareTo(other.getIDAttribute());
    }

    public String toString() {
        return this.generateXMLString() + "\n\t[source file=\"" + String.valueOf(this.getSourceFile()) + "\" (line:" + this.getLineNumber() + ")]";
    }

    private String generateXMLString() {
        return "<tocref id=\"" + this.getIDAttribute() + "\"/>";
    }
}

