/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.features.codecompare.functiongraph.actions.AbstractFgAction;
import ghidra.util.HelpLocation;
import java.awt.Component;
import javax.swing.JComponent;

public class FgResetGraphAction
extends AbstractFgAction {
    private FgDisplay display;

    public FgResetGraphAction(FgDisplay display) {
        super(display, "Reset Graph");
        this.display = display;
        this.setPopupMenuData(new MenuData(new String[]{"Reset Graph"}));
        this.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Reload_Graph"));
    }

    public void actionPerformed(ActionContext context) {
        FGController controller = this.display.getController();
        JComponent component = controller.getViewComponent();
        int choice = OptionDialog.showYesNoDialog((Component)component, (String)"Reset Graph?", (String)"<html>Erase all vertex position and grouping information?");
        if (choice != 1) {
            return;
        }
        controller.resetGraph();
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        if (!super.isEnabledForContext(context)) {
            return false;
        }
        FGController controller = this.display.getController();
        return controller.hasResults();
    }
}

