/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.AcceptMatchTask;
import ghidra.feature.vt.gui.task.ApplyMatchTask;
import ghidra.feature.vt.gui.task.CreateManualMatchTask;
import ghidra.program.model.listing.Function;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class CreateAndAcceptApplyManualMatchTask
extends CreateManualMatchTask {
    private VTController controller;
    private boolean applyMarkup;

    public CreateAndAcceptApplyManualMatchTask(VTController controller, Function sourceFunction, Function destinationFunction, boolean applyMarkup) {
        super("Create And Accept/Apply Manual Match", controller.getSession(), sourceFunction, destinationFunction);
        this.controller = controller;
        this.applyMarkup = applyMarkup;
    }

    @Override
    protected boolean runFollowOnTasks(TaskMonitor monitor) throws Exception {
        if (this.newlyCreatedMatch == null) {
            return false;
        }
        ArrayList<VTMatch> list = new ArrayList<VTMatch>();
        list.add(this.newlyCreatedMatch);
        if (this.applyMarkup) {
            ApplyMatchTask applyMatchTask = new ApplyMatchTask(this.controller, list);
            boolean result = applyMatchTask.doWork(monitor);
            this.addErrors(applyMatchTask);
            return result;
        }
        AcceptMatchTask acceptMatchTask = new AcceptMatchTask(this.controller, list);
        boolean result = acceptMatchTask.doWork(monitor);
        this.addErrors(acceptMatchTask);
        return result;
    }
}

