/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.util.Date;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.dialogs.ValueViewDialog;

public class DateTimeStandaloneEditor
extends ValueViewDialog {
    private CustomTimeEditor timeEditor;
    private boolean dirty;
    private IValueController valueController;

    public DateTimeStandaloneEditor(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        this.valueController = this.getValueController();
        Object value = this.valueController.getValue();
        Composite dialogGroup = super.createDialogArea(parent);
        Composite panel = UIUtils.createComposite((Composite)dialogGroup, (int)3);
        panel.setLayoutData((Object)new GridData(768));
        int style = 0;
        if (this.valueController.isReadOnly()) {
            style |= 8;
        }
        this.timeEditor = new CustomTimeEditor(panel, style, false, false);
        this.timeEditor.getControl().addListener(24, event -> {
            this.dirty = true;
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.timeEditor.getControl().setLayoutData((Object)gd);
        this.timeEditor.createDateFormat(this.valueController.getValueType());
        this.timeEditor.setEditable(!this.valueController.isReadOnly());
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.datetime.editor")) {
            this.timeEditor.setToTextComposite();
        }
        this.primeEditorValue(value);
        Button button = UIUtils.createPushButton((Composite)panel, (String)"Set Current", null);
        button.setEnabled(!this.valueController.isReadOnly());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeStandaloneEditor.this.primeEditorValue(new Date());
            }
        });
        return dialogGroup;
    }

    private boolean isCalendarMode() {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.datetime.editor");
    }

    @Override
    public Object extractEditorValue() throws DBException {
        try (DBCSession session = this.getValueController().getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make datetime value from editor");){
            if (!this.isCalendarMode()) {
                String strValue = this.timeEditor.getValueAsString();
                Object object = this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)strValue, false, true);
                return object;
            }
            Date dateValue = this.timeEditor.getValueAsDate();
            Object object = this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)dateValue, false, true);
            return object;
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) {
        this.timeEditor.setTextValue(this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT));
        try {
            this.timeEditor.setValue(value);
        }
        catch (DBCException e) {
            DBWorkbench.getPlatformUI().showWarningMessageBox(ResultSetMessages.dialog_value_view_error_parsing_date_title, ResultSetMessages.dialog_value_view_error_parsing_date_message);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public Control getControl() {
        return null;
    }
}

