/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.util.function.Consumer;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetThemeSettings;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;

public abstract class BaseValueEditor<T extends Control>
implements IValueEditor {
    private static final String RESULTS_EDIT_CONTEXT_ID = "org.jkiss.dbeaver.ui.context.resultset.edit";
    private static final Log log = Log.getLog(BaseValueEditor.class);
    protected final IValueController valueController;
    protected T control;
    protected boolean dirty;
    protected boolean autoSaveEnabled;
    @Nullable
    private Consumer<TraverseEvent> additionalTraverseActions;

    protected BaseValueEditor(IValueController valueController) {
        this.valueController = valueController;
    }

    public IValueController getValueController() {
        return this.valueController;
    }

    @Override
    public void createControl() {
        T control = this.createControl(this.valueController.getEditPlaceholder());
        this.setControl(control);
        control.setFont(this.getDefaultFont());
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public boolean isReadOnly() {
        return this.valueController.isReadOnly();
    }

    @Override
    public void dispose() {
    }

    @NotNull
    protected Font getDefaultFont() {
        return ResultSetThemeSettings.instance.resultSetFont;
    }

    public void setControl(T control) {
        this.control = control;
        if (this.control != null && control != this.valueController.getEditPlaceholder()) {
            this.initInlineControl((Control)this.control);
        }
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
    }

    protected abstract T createControl(Composite var1);

    protected void initInlineControl(Control inlineControl) {
        boolean isInline;
        boolean bl = isInline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        if (!isInline || UIUtils.isInDialog((Control)inlineControl)) {
            // empty if block
        }
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.valueController.getValueSite(), (Control)inlineControl);
        if (inlineControl instanceof Composite) {
            for (Control childControl : ((Composite)inlineControl).getChildren()) {
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.valueController.getValueSite(), (Control)childControl);
            }
        }
        if (isInline) {
            EditorUtils.trackControlContext((IWorkbenchSite)this.valueController.getValueSite(), (Control)inlineControl, (String)RESULTS_EDIT_CONTEXT_ID);
            if (this.valueController instanceof IMultiController) {
                inlineControl.addTraverseListener(e -> {
                    if (e.detail == 4) {
                        if (!this.valueController.isReadOnly()) {
                            this.saveValue();
                        }
                        ((IMultiController)((Object)this.valueController)).closeInlineEditor();
                        if (this.additionalTraverseActions != null) {
                            this.additionalTraverseActions.accept(e);
                        }
                        e.doit = false;
                        e.detail = 0;
                    } else if (e.detail == 2) {
                        ((IMultiController)((Object)this.valueController)).closeInlineEditor();
                        if (this.additionalTraverseActions != null) {
                            this.additionalTraverseActions.accept(e);
                        }
                        e.doit = false;
                        e.detail = 0;
                    } else if (e.detail == 16 || e.detail == 8) {
                        this.saveValue();
                        ((IMultiController)((Object)this.valueController)).nextInlineEditor(e.detail == 16);
                        if (this.additionalTraverseActions != null) {
                            this.additionalTraverseActions.accept(e);
                        }
                        e.doit = false;
                        e.detail = 0;
                    }
                });
                if (!UIUtils.isInDialog((Control)inlineControl)) {
                    if (inlineControl instanceof Composite) {
                        for (Control childControl : ((Composite)inlineControl).getChildren()) {
                            if (childControl.isDisposed()) continue;
                            this.addAutoSaveSupport(childControl);
                            EditorUtils.trackControlContext((IWorkbenchSite)this.valueController.getValueSite(), (Control)childControl, (String)RESULTS_EDIT_CONTEXT_ID);
                        }
                    } else {
                        this.addAutoSaveSupport(inlineControl);
                    }
                } else {
                    ((IMultiController)((Object)this.valueController)).closeInlineEditor();
                }
            }
            if (!UIUtils.isInDialog((Control)inlineControl)) {
                inlineControl.setFont(ResultSetThemeSettings.instance.resultSetFont);
            }
        }
        ControlModifyListener modifyListener = new ControlModifyListener();
        this.addInlineListeners(inlineControl, modifyListener);
    }

    protected void addInlineListeners(@NotNull Control inlineControl, @NotNull Listener listener) {
        inlineControl.addListener(24, listener);
        inlineControl.addListener(13, listener);
    }

    private void addAutoSaveSupport(Control inlineControl) {
        final BaseValueEditor editor = this;
        inlineControl.addFocusListener(new FocusListener(){
            final /* synthetic */ BaseValueEditor this$0;
            {
                this.this$0 = this$0;
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Point relativeCursorLocation;
                Rectangle controlBounds = editor.control.getBounds();
                if (controlBounds.contains(relativeCursorLocation = editor.control.toControl(e.display.getCursorLocation()))) {
                    return;
                }
                this.this$0.onFocusLost(this.this$0.valueController::updateSelectionValue);
            }
        });
        UIUtils.installMacOSFocusLostSubstitution((Widget)inlineControl, () -> this.onFocusLost(value -> this.valueController.updateValue(value, true)));
    }

    private void onFocusLost(@NotNull Consumer<Object> valueSaver) {
        if (!this.valueController.isReadOnly()) {
            this.saveValue(false, valueSaver);
        }
        if (this.valueController instanceof IMultiController) {
            ((IMultiController)((Object)this.valueController)).closeInlineEditor();
        }
    }

    protected void saveValue() {
        this.saveValue(true);
    }

    protected void saveValue(boolean showError) {
        this.saveValue(showError, this.valueController::updateSelectionValue);
    }

    private void saveValue(boolean showError, @NotNull Consumer<Object> valueUpdater) {
        try {
            Object newValue = this.extractEditorValue();
            if (this.dirty || this.control instanceof Combo || this.control instanceof CCombo || this.control instanceof List) {
                valueUpdater.accept(newValue);
            }
        }
        catch (DBException e) {
            if (this.valueController instanceof IMultiController) {
                ((IMultiController)((Object)this.valueController)).closeInlineEditor();
            }
            if (showError) {
                DBWorkbench.getPlatformUI().showError("Value save", "Can't save edited value", (Throwable)e);
            }
            log.debug((Object)("Error saving value: " + e.getMessage()));
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isAutoSaveEnabled() {
        return this.autoSaveEnabled;
    }

    public void setAutoSaveEnabled(boolean autoSaveEnabled) {
        this.autoSaveEnabled = autoSaveEnabled;
    }

    public void addAdditionalTraverseActions(@NotNull Consumer<TraverseEvent> method) {
        this.additionalTraverseActions = method;
    }

    private class ControlModifyListener
    implements Listener {
        private ControlModifyListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 13 && !this.isListControl(event.widget)) {
                return;
            }
            BaseValueEditor.this.setDirty(true);
            if (BaseValueEditor.this.autoSaveEnabled && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.edit.value.autoupdate")) {
                BaseValueEditor.this.saveValue(false);
            }
        }

        private boolean isListControl(Widget control) {
            return !(control instanceof StyledText) && !(control instanceof Text) && !(control instanceof Table) && !(control instanceof Tree);
        }
    }
}

