/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.sql.SQLDialectInsertReplaceMethod;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadataRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLInsertReplaceMethodDescriptor;
import org.jkiss.utils.CommonUtils;

public class SQLDialectRegistry
implements SQLDialectMetadataRegistry {
    static final String TAG_DIALECT = "dialect";
    private static final String TAG_METHOD = "method";
    private final Map<String, SQLDialectDescriptor> dialects = new LinkedHashMap<String, SQLDialectDescriptor>();
    private final List<SQLInsertReplaceMethodDescriptor> insertMethods = new ArrayList<SQLInsertReplaceMethodDescriptor>();

    public SQLDialectRegistry() {
        this.loadExtensions(Platform.getExtensionRegistry());
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement ext : extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlDialect")) {
            if (!TAG_DIALECT.equals(ext.getName())) continue;
            SQLDialectDescriptor dialectDescriptor = new SQLDialectDescriptor(ext);
            this.dialects.put(dialectDescriptor.getId(), dialectDescriptor);
        }
        for (IConfigurationElement ext : extConfigs) {
            if (!TAG_DIALECT.equals(ext.getName())) continue;
            String dialectId = ext.getAttribute("id");
            String parentDialectId = ext.getAttribute("parent");
            if (CommonUtils.isEmpty((String)dialectId) || CommonUtils.isEmpty((String)parentDialectId)) continue;
            SQLDialectDescriptor dialect = this.dialects.get(dialectId);
            SQLDialectDescriptor parentDialect = this.dialects.get(parentDialectId);
            if (dialect == null || parentDialect == null) continue;
            dialect.setParentDialect(parentDialect);
        }
        for (IConfigurationElement ext : registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlInsertMethod")) {
            if (!TAG_METHOD.equals(ext.getName())) continue;
            this.insertMethods.add(new SQLInsertReplaceMethodDescriptor(ext));
        }
    }

    public void dispose() {
        this.dialects.clear();
    }

    public List<SQLDialectMetadata> getDialects() {
        return new ArrayList<SQLDialectMetadata>(this.dialects.values());
    }

    public SQLDialectDescriptor getDialect(String id) {
        return this.dialects.get(id);
    }

    public List<SQLDialectMetadata> getRootDialects() {
        ArrayList<SQLDialectMetadata> roots = new ArrayList<SQLDialectMetadata>();
        for (SQLDialectDescriptor dd : this.dialects.values()) {
            if (dd.getParentDialect() != null) continue;
            roots.add(dd);
        }
        return roots;
    }

    public List<SQLInsertReplaceMethodDescriptor> getInsertMethods() {
        return new ArrayList<SQLInsertReplaceMethodDescriptor>(this.insertMethods);
    }

    public SQLDialectInsertReplaceMethod getInsertReplaceMethod(String insertMethodId) {
        for (SQLInsertReplaceMethodDescriptor method : this.insertMethods) {
            if (!method.getId().equalsIgnoreCase(insertMethodId)) continue;
            return method;
        }
        return null;
    }

    public SQLInsertReplaceMethodDescriptor getInsertMethodOnLabel(String label) {
        for (SQLInsertReplaceMethodDescriptor method : this.insertMethods) {
            if (!method.getLabel().equalsIgnoreCase(label)) continue;
            return method;
        }
        return null;
    }
}

