/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DriverCategoryDescriptor;
import org.jkiss.dbeaver.registry.DriverManagerRegistry;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.finder.viewer.AdvancedListViewer;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderComposite;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DriverTabbedViewer
extends StructuredViewer {
    private static final Log log = Log.getLog(DriverTabbedViewer.class);
    private static final String DIALOG_ID = "DBeaver.DriverTabbedViewer";
    private static final String PARAM_LAST_FOLDER = "folder";
    private final TabbedFolderComposite folderComposite;
    private final List<DBPDataSourceContainer> dataSources;
    private ViewerFilter[] curFilters;
    private Comparator<DBPDriver> listComparator;

    public DriverTabbedViewer(Composite parent, int style, List<DBPDataSourceContainer> dataSources, Comparator<DBPDriver> driverComparator) {
        this.dataSources = dataSources;
        this.listComparator = driverComparator;
        List allDrivers = DriverUtils.getAllDrivers();
        ArrayList<DBPDriver> ratedDrivers = new ArrayList<DBPDriver>(allDrivers);
        List recentDrivers = DriverUtils.getRecentDrivers((List)allDrivers, (int)12);
        this.folderComposite = new TabbedFolderComposite(this, parent, style){

            public boolean setFocus() {
                ITabbedFolder activeFolder = this.getActiveFolder();
                if (activeFolder != null) {
                    activeFolder.setFocus();
                    return true;
                }
                return super.setFocus();
            }
        };
        ArrayList<Object> folders = new ArrayList<Object>();
        folders.add(new TabbedFolderInfo("all", UIConnectionMessages.dialog_driver_category_all_label, (DBPImage)DBIcon.TREE_DATABASE, UIConnectionMessages.dialog_driver_category_all_tip, false, (ITabbedFolder)new DriverListFolder(null, ratedDrivers)));
        folders.add(new TabbedFolderInfo("popular", UIConnectionMessages.dialog_driver_category_popular_label, (DBPImage)DBIcon.TREE_DATABASE, UIConnectionMessages.dialog_driver_category_popular_tip, false, (ITabbedFolder)new DriverListFolder(null, recentDrivers)));
        ArrayList<TabbedFolderInfo> extFolders = new ArrayList<TabbedFolderInfo>();
        for (DriverCategoryDescriptor category : DriverManagerRegistry.getInstance().getCategories()) {
            List<DBPDriver> drivers;
            if (!category.isPromoted() || (drivers = this.getCategoryDrivers(category, allDrivers)).isEmpty()) continue;
            extFolders.add(new TabbedFolderInfo(category.getId(), category.getName(), category.getIcon(), category.getDescription(), false, (ITabbedFolder)new DriverListFolder(category, drivers)));
        }
        extFolders.sort((o1, o2) -> {
            DriverCategoryDescriptor cat1 = ((DriverListFolder)o1.getContents()).category;
            DriverCategoryDescriptor cat2 = ((DriverListFolder)o2.getContents()).category;
            int cmp = cat1.getRank() - cat2.getRank();
            if (cmp == 0) {
                cmp = cat1.getName().compareTo(cat2.getName());
            }
            return cmp;
        });
        folders.addAll(extFolders);
        String folderId = UIUtils.getDialogSettings((String)DIALOG_ID).get(PARAM_LAST_FOLDER);
        if (CommonUtils.isEmpty((String)folderId)) {
            folderId = "all";
        }
        this.folderComposite.setFolders(((Object)((Object)this)).getClass().getSimpleName(), folders.toArray(new TabbedFolderInfo[0]));
        this.folderComposite.switchFolder(folderId, false);
        this.folderComposite.addFolderListener(folderId1 -> {
            if (this.curFilters != null) {
                ((DriverListFolder)this.folderComposite.getActiveFolder()).viewer.setFilters(this.curFilters);
            }
            UIUtils.getDialogSettings((String)DIALOG_ID).put(PARAM_LAST_FOLDER, folderId1);
            StructuredViewer currentViewer = this.getCurrentViewer();
            if (currentViewer == null) return;
            ISelection selection = currentViewer.getSelection();
            if (selection.isEmpty()) {
                DriverCategoryDescriptor category = DriverManagerRegistry.getInstance().getCategory(folderId1);
                if (category == null) return;
            }
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)currentViewer, selection));
        });
    }

    private List<DBPDriver> getCategoryDrivers(DriverCategoryDescriptor category, List<DBPDriver> allDrivers) {
        ArrayList<DBPDriver> drivers = new ArrayList<DBPDriver>();
        for (DBPDriver driver : allDrivers) {
            if (!driver.getCategories().contains(category.getId())) continue;
            drivers.add(driver);
        }
        return drivers;
    }

    public TabbedFolderComposite getFolderComposite() {
        return this.folderComposite;
    }

    private StructuredViewer getCurrentViewer() {
        ITabbedFolder activeFolder = this.folderComposite.getActiveFolder();
        if (activeFolder instanceof DriverListFolder) {
            return ((DriverListFolder)activeFolder).viewer;
        }
        return null;
    }

    public void setListComparator(Comparator<DBPDriver> listComparator) {
        this.listComparator = listComparator;
        TabbedFolderInfo[] folders = this.folderComposite.getFolders();
        if (folders != null) {
            for (TabbedFolderInfo folder : folders) {
                if (!(folder.getContents() instanceof DriverListFolder)) continue;
                ((DriverListFolder)folder.getContents()).refreshDrivers();
            }
        }
    }

    public Control getControl() {
        return this.folderComposite;
    }

    public Object getInput() {
        StructuredViewer viewer = this.getCurrentViewer();
        return viewer == null ? null : viewer.getInput();
    }

    public ISelection getSelection() {
        StructuredViewer viewer = this.getCurrentViewer();
        return viewer == null ? null : viewer.getSelection();
    }

    public void refresh() {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.setSelection(selection, reveal);
        }
    }

    public void setFilters(ViewerFilter ... filters) {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.setFilters(filters);
        }
        this.curFilters = filters;
    }

    public void resetFilters() {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.resetFilters();
        }
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        return null;
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.reveal(element);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    private void registerViewer(AdvancedListViewer viewer) {
        DriverTabbedViewer driverTabbedViewer = this;
        viewer.addSelectionChangedListener(x$0 -> driverTabbedViewer.fireSelectionChanged(x$0));
        driverTabbedViewer = this;
        viewer.addDoubleClickListener(x$0 -> driverTabbedViewer.fireDoubleClick(x$0));
    }

    private class DriverListFolder
    implements ITabbedFolder {
        private final DriverCategoryDescriptor category;
        private AdvancedListViewer viewer;
        private final List<DBPDriver> drivers;
        private boolean activated;

        DriverListFolder(DriverCategoryDescriptor category, List<DBPDriver> drivers) {
            this.category = category;
            this.drivers = new ArrayList<DBPDriver>(drivers);
        }

        public void createControl(Composite parent) {
            this.viewer = new AdvancedListViewer(parent, 0);
            this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new DriverLabelProvider());
            DriverTabbedViewer.this.registerViewer(this.viewer);
        }

        public void aboutToBeShown() {
            if (!this.activated) {
                this.refreshDrivers();
                this.activated = true;
            }
        }

        public void aboutToBeHidden() {
        }

        public void setFocus() {
            Control control = this.viewer.getControl();
            if (!control.isDisposed()) {
                control.setFocus();
            }
        }

        public void dispose() {
        }

        void refreshDrivers() {
            if (DriverTabbedViewer.this.listComparator != null) {
                this.drivers.sort(DriverTabbedViewer.this.listComparator);
            }
            if (this.viewer != null) {
                this.viewer.setInput(this.drivers);
            }
        }

        private class DriverLabelProvider
        extends LabelProvider
        implements IToolTipProvider {
            private DriverLabelProvider() {
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)((DBPDriver)element).getIconBig());
            }

            public String getText(Object element) {
                return ((DBPDriver)element).getName();
            }

            public String getToolTipText(Object element) {
                DBPDriver driver = (DBPDriver)element;
                List usedBy = DriverUtils.getUsedBy((DBPDriver)driver, DriverTabbedViewer.this.dataSources);
                StringBuilder toolTip = new StringBuilder();
                toolTip.append(driver.getFullName());
                toolTip.append("\n");
                if (!usedBy.isEmpty()) {
                    toolTip.append(NLS.bind((String)UIConnectionMessages.driver_labal_provider_tip_saved_connections, (Object)usedBy.size()));
                } else {
                    toolTip.append(UIConnectionMessages.driver_labal_provider_tip_no_saved_connections);
                }
                if (!CommonUtils.isEmpty((String)driver.getDescription())) {
                    if (toolTip.length() > 0) {
                        toolTip.append("\n\n");
                    }
                    toolTip.append(driver.getDescription());
                }
                return toolTip.toString();
            }
        }
    }
}

