/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.DBDummyNumberTransformer;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCAttribute;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCTableColumn<TABLE_TYPE extends DBSEntity>
extends JDBCAttribute
implements DBSTableColumn,
DBSEntityAttribute,
DBSAttributeEnumerable,
DBPSaveableObject {
    private static final Log log = Log.getLog(JDBCTableColumn.class);
    private final TABLE_TYPE table;
    private boolean persisted;
    private String defaultValue;

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted) {
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted, String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated, String defaultValue) {
        super(name, typeName, valueType, ordinalPosition, maxLength, scale, precision, required, autoGenerated);
        this.defaultValue = defaultValue;
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, DBSEntityAttribute source, boolean persisted) {
        super((DBSAttributeBase)source);
        this.table = table;
        this.persisted = persisted;
        this.defaultValue = source.getDefaultValue();
    }

    public TABLE_TYPE getTable() {
        return this.table;
    }

    @NotNull
    public TABLE_TYPE getParentObject() {
        return this.getTable();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=10)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=true, order=20, listProvider=ColumnTypeNameListProvider.class)
    @NotNull
    public String getTypeName() {
        return super.getTypeName();
    }

    public void setTypeName(@NotNull String typeName) throws DBException {
        super.setTypeName(typeName);
        DBPDataTypeProvider dataTypeProvider = (DBPDataTypeProvider)DBUtils.getParentOfType(DBPDataTypeProvider.class, (DBSObject)this);
        if (dataTypeProvider != null) {
            DBSDataType dataType = dataTypeProvider.getLocalDataType(typeName);
            if (dataType != null) {
                this.valueType = dataType.getTypeID();
                JDBCTableColumn jDBCTableColumn = this;
                if (jDBCTableColumn instanceof DBSTypedObjectExt4) {
                    DBSTypedObjectExt4 toe = (DBSTypedObjectExt4)jDBCTableColumn;
                    try {
                        toe.setDataType(dataType);
                    }
                    catch (Throwable e) {
                        log.debug((Object)e);
                    }
                }
            } else {
                this.valueType = -1;
            }
        }
    }

    @Property(viewable=true, editable=true, order=40, valueRenderer=DBDummyNumberTransformer.class)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Property(viewable=true, editable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Property(viewable=true, editable=true, order=70)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @NotNull
    public List<DBDLabelValuePair> getValueEnumeration(@NotNull DBCSession session, @Nullable Object valuePattern, int maxResults, boolean calcCount, boolean formatValues, boolean caseInsensitiveSearch) throws DBException {
        String str;
        SQLDialect dialect = this.getDataSource().getSQLDialect();
        String identifier = DBUtils.getQuotedIdentifier((DBSObject)this, (DBPAttributeReferencePurpose)DBPAttributeReferencePurpose.DATA_SELECTION);
        String castedIdentifier = dialect.getCastedAttributeName((DBSAttributeBase)this, identifier);
        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)this);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        if (!calcCount) {
            query.append("DISTINCT ");
        }
        query.append(identifier);
        if (calcCount) {
            query.append(", count(");
            String asterisk = dialect.getDefaultGroupAttribute();
            if (asterisk == null) {
                asterisk = "";
            }
            query.append(asterisk);
            query.append(")");
        }
        query.append("\nFROM ").append(DBUtils.getObjectFullName(this.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        if (valuePattern instanceof String && !(str = (String)valuePattern).isBlank()) {
            query.append("\nWHERE ");
            if (this.getDataKind() == DBPDataKind.STRING) {
                SQLExpressionFormatter caseInsensitiveFormatter;
                SQLExpressionFormatter sQLExpressionFormatter = caseInsensitiveFormatter = caseInsensitiveSearch ? dialect.getCaseInsensitiveExpressionFormatter(DBCLogicalOperator.LIKE) : null;
                if (caseInsensitiveSearch && caseInsensitiveFormatter != null) {
                    query.append(caseInsensitiveFormatter.format(castedIdentifier, "?"));
                } else {
                    query.append(castedIdentifier).append(" LIKE ?");
                }
            } else {
                query.append(castedIdentifier).append(" = ?");
            }
        }
        if (calcCount) {
            query.append("\nGROUP BY ").append(identifier);
            query.append("\nORDER BY 2 DESC");
        } else {
            query.append("\nORDER BY 1");
        }
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);){
            String str2;
            if (valuePattern instanceof String && !(str2 = (String)valuePattern).isBlank()) {
                if (this.getDataKind() == DBPDataKind.STRING) {
                    valueHandler.bindValueObject(session, dbStat, (DBSTypedObject)this, 0, (Object)("%" + String.valueOf(valuePattern) + "%"));
                } else {
                    valueHandler.bindValueObject(session, dbStat, (DBSTypedObject)this, 0, valuePattern);
                }
            }
            dbStat.setLimit(0L, (long)maxResults);
            if (dbStat.executeStatement()) {
                try (DBCResultSet dbResult = dbStat.openResultSet();){
                    List list = DBVUtils.readDictionaryRows((DBCSession)session, Collections.singletonList(this), Collections.singletonList(valueHandler), (DBCResultSet)dbResult, (boolean)formatValues, (boolean)calcCount);
                    return list;
                }
            }
            List<DBDLabelValuePair> list = Collections.emptyList();
            return list;
        }
    }

    @Nullable
    public Long getDistinctValuesCount(@NotNull DBCSession session) throws DBException {
        block14: {
            String query = "SELECT COUNT(DISTINCT " + DBUtils.getQuotedIdentifier((DBSObject)this, (DBPAttributeReferencePurpose)DBPAttributeReferencePurpose.DATA_SELECTION) + ")\nFROM " + DBUtils.getObjectFullName(this.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DML);
            try (DBCStatement stmt = session.prepareStatement(DBCStatementType.QUERY, query, false, false, false);){
                if (!stmt.executeStatement()) break block14;
                try (DBCResultSet resultSet = Objects.requireNonNull(stmt.openResultSet());){
                    if (resultSet.nextRow()) {
                        Long l = CommonUtils.toLong((Object)resultSet.getAttributeValue(0));
                        return l;
                    }
                }
            }
        }
        return null;
    }

    public static class ColumnTypeNameListProvider
    implements IPropertyValueListProvider<JDBCTableColumn<?>> {
        public boolean allowCustomValue() {
            return true;
        }

        @Nullable
        public Object[] getPossibleValues(JDBCTableColumn<?> column) {
            TreeSet<String> typeNames = new TreeSet<String>();
            if (column.getDataSource() instanceof DBPDataTypeProvider) {
                for (DBSDataType type : ((DBPDataTypeProvider)column.getDataSource()).getLocalDataTypes()) {
                    if (type.getDataKind() == DBPDataKind.UNKNOWN || CommonUtils.isEmpty((String)type.getName()) || !Character.isLetter(type.getName().charAt(0))) continue;
                    typeNames.add(type.getName());
                }
            }
            return typeNames.toArray(new String[0]);
        }
    }
}

