/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.cache.DBSStructCache;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;

public abstract class JDBCStructCache<OWNER extends DBSObject, OBJECT extends DBSObject, CHILD extends DBSObject>
extends JDBCObjectCache<OWNER, OBJECT>
implements DBSStructCache<OWNER, OBJECT, CHILD> {
    private static final Log log = Log.getLog(JDBCStructCache.class);
    private final Object objectNameColumn;
    private volatile boolean childrenCached = false;
    private final Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> childrenCache = new IdentityHashMap<OBJECT, SimpleObjectCache<OBJECT, CHILD>>();

    protected abstract JDBCStatement prepareChildrenStatement(@NotNull JDBCSession var1, @NotNull OWNER var2, @Nullable OBJECT var3) throws SQLException;

    protected abstract CHILD fetchChild(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull OBJECT var3, @NotNull JDBCResultSet var4) throws SQLException, DBException;

    protected JDBCStructCache(Object objectNameColumn) {
        this.objectNameColumn = objectNameColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadChildren(DBRProgressMonitor monitor, OWNER owner, @Nullable OBJECT forObject) throws DBException {
        DBPDataSource dataSource;
        if (monitor.isForceCacheUsage() || monitor.isCanceled() || forObject == null && this.childrenCached || forObject != null && (!forObject.isPersisted() || this.isChildrenCached(forObject))) {
            return;
        }
        if (forObject == null) {
            super.loadObjects(monitor, owner);
        }
        if ((dataSource = owner.getDataSource()) == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)"Load child objects");){
            HashMap<DBSObject, List> objectMap = new HashMap<DBSObject, List>();
            try (JDBCStatement dbStat = this.prepareChildrenStatement(session, owner, forObject);){
                dbStat.setFetchSize(1000);
                dbStat.executeStatement();
                JDBCResultSet dbResult = dbStat.getResultSet();
                if (dbResult != null) {
                    try {
                        while (dbResult.next()) {
                            CHILD child;
                            if (monitor.isCanceled()) {
                                return;
                            }
                            Object object = forObject;
                            if (object == null) {
                                String objectName = this.objectNameColumn instanceof Number ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.objectNameColumn).intValue()) : JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, this.objectNameColumn.toString());
                                if (objectName == null) {
                                    log.debug((Object)("NULL object name in " + String.valueOf((Object)this)));
                                    continue;
                                }
                                object = super.getCachedObject(objectName);
                                if (object == null) {
                                    log.debug((Object)("Object '" + objectName + "' not found in struct cache (" + ((Object)((Object)this)).getClass().getSimpleName() + ")"));
                                    continue;
                                }
                            }
                            if (this.isChildrenCached(object) || (child = this.fetchChild(session, owner, object, dbResult)) == null) continue;
                            List children = objectMap.computeIfAbsent((DBSObject)object, k -> new ArrayList());
                            children.add(child);
                        }
                    }
                    finally {
                        dbResult.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new DBDatabaseException((Throwable)ex, dataSource);
        }
    }

    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        this.clearChildrenCache(object);
    }

    public void clearCache() {
        this.clearChildrenCache(null);
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBSObjectCache<OBJECT, CHILD> getChildrenCache(@NotNull OBJECT forObject) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            if (nestedCache == null) {
                nestedCache = this.createNestedCache();
                nestedCache.setCache(new ArrayList());
                this.childrenCache.put(forObject, nestedCache);
            }
            return nestedCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<CHILD> getChildren(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, OBJECT forObject) throws DBException {
        if (!monitor.isForceCacheUsage()) {
            this.loadChildren(monitor, owner, forObject);
        }
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            return nestedCache == null ? null : nestedCache.getAllObjects(monitor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CHILD getChild(@Nullable DBRProgressMonitor monitor, @NotNull OWNER owner, OBJECT forObject, @NotNull String objectName) throws DBException {
        if (monitor != null) {
            this.loadChildren(monitor, owner, forObject);
        }
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            return (CHILD)(nestedCache == null ? null : nestedCache.getObject(monitor, forObject, objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildrenCache(OBJECT forParent) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            if (forParent != null) {
                this.childrenCache.remove(forParent);
            } else {
                this.childrenCache.clear();
            }
            this.childrenCached = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isChildrenCached(OBJECT parent) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            return this.childrenCache.containsKey(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheChildren(OBJECT parent, List<CHILD> children) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(parent);
            if (nestedCache == null) {
                nestedCache = this.createNestedCache();
                this.childrenCache.put(parent, nestedCache);
            }
            nestedCache.setCache(children);
        }
    }

    @NotNull
    protected SimpleObjectCache<OBJECT, CHILD> createNestedCache() {
        SimpleObjectCache nestedCache = new SimpleObjectCache();
        nestedCache.setCaseSensitive(this.caseSensitive);
        return nestedCache;
    }
}

