/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.cache.DBSCompositeCache;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCObjectWithParentCache<OWNER extends DBSObject, PARENT extends DBSObject, OBJECT extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT>
implements DBSCompositeCache<PARENT, OBJECT> {
    protected static final Log log = Log.getLog(JDBCObjectWithParentCache.class);
    private final JDBCStructCache<OWNER, ?, ?> parentCache;
    private final Class<PARENT> parentType;
    private final Object parentColumnName;
    private final Object objectColumnName;
    private final Map<PARENT, List<OBJECT>> objectCache = new IdentityHashMap<PARENT, List<OBJECT>>();

    protected JDBCObjectWithParentCache(JDBCStructCache<OWNER, ?, ?> parentCache, Class<PARENT> parentType, Object parentColumnName, Object objectColumnName) {
        this.parentCache = parentCache;
        this.parentType = parentType;
        this.parentColumnName = parentColumnName;
        this.objectColumnName = objectColumnName;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2, @Nullable PARENT var3) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull PARENT var3, String var4, @NotNull JDBCResultSet var5) throws SQLException, DBException;

    protected PARENT getParent(OBJECT object) {
        return (PARENT)object.getParentObject();
    }

    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        return this.getObjects(monitor, owner, null);
    }

    public List<OBJECT> getObjects(@NotNull DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        if (!monitor.isCanceled() && !monitor.isForceCacheUsage()) {
            this.loadObjects(monitor, owner, forParent);
        }
        return this.getCachedObjects(forParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OBJECT> getCachedObjects(@Nullable PARENT forParent) {
        if (forParent == null) {
            return this.getCachedObjects();
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return this.objectCache.get(forParent);
        }
    }

    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String objectName) throws DBException {
        this.loadObjects(monitor, owner, null);
        return (OBJECT)this.getCachedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBJECT getObject(DBRProgressMonitor monitor, OWNER owner, PARENT forParent, String objectName) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        if (forParent == null) {
            return (OBJECT)this.getCachedObject(objectName);
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return (OBJECT)((DBSObject)DBUtils.findObject((Collection)this.objectCache.get(forParent), (String)objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheObject(@NotNull OBJECT object) {
        super.cacheObject(object);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            List objects = this.objectCache.computeIfAbsent(parent, k -> new ArrayList());
            objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            if (resetFullCache) {
                this.objectCache.remove(parent);
            } else {
                List<OBJECT> subCache = this.objectCache.get(parent);
                if (subCache != null) {
                    subCache.remove(object);
                }
            }
        }
    }

    public void clearObjectCache(@NotNull PARENT forParent) {
        if (forParent == null) {
            super.clearCache();
            this.objectCache.clear();
        } else {
            List<OBJECT> removedObjects = this.objectCache.remove(forParent);
            if (removedObjects != null) {
                for (DBSObject obj : removedObjects) {
                    super.removeObject(obj, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
        }
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(@NotNull List<OBJECT> objects) {
        super.setCache(objects);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            for (DBSObject object : objects) {
                PARENT parent = this.getParent(object);
                List parentObjects = this.objectCache.computeIfAbsent(parent, k -> new ArrayList());
                parentObjects.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadObjects(@NotNull DBRProgressMonitor monitor, OWNER owner, @Nullable PARENT forParent) throws DBException {
        LinkedHashMap<DBSObject, Map> parentObjectMap;
        block50: {
            Map<PARENT, List<OBJECT>> map = this.objectCache;
            synchronized (map) {
                if (monitor.isForceCacheUsage() || forParent == null && this.isFullyCached() || forParent != null && (!forParent.isPersisted() || this.objectCache.containsKey(forParent))) {
                    return;
                }
            }
            if (forParent == null) {
                this.parentCache.loadObjects(monitor, owner);
            }
            parentObjectMap = new LinkedHashMap<DBSObject, Map>();
            monitor.beginTask("Load parent and object cache", 1);
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)"Load parent and object objects");){
                dbStat.setFetchSize(1000);
                try (JDBCStatement dbStat = this.prepareObjectsStatement(session, owner, forParent);){
                    dbStat.executeStatement();
                    JDBCResultSet dbResult = dbStat.getResultSet();
                    if (dbResult == null) break block50;
                    try {
                        while (dbResult.next()) {
                            OBJECT object;
                            String objectName;
                            if (monitor.isCanceled()) {
                                return;
                            }
                            Iterator<List<OBJECT>> parentName = forParent != null ? forParent.getName() : (this.parentColumnName instanceof Number ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.parentColumnName).intValue()) : JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, this.parentColumnName.toString()));
                            String string = objectName = this.objectColumnName instanceof Number ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.objectColumnName).intValue()) : JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, this.objectColumnName.toString());
                            if (forParent == null && CommonUtils.isEmpty(parentName)) {
                                log.debug((Object)("Empty parent name in " + String.valueOf((Object)this)));
                                continue;
                            }
                            Object parent = forParent;
                            if (parent == null && (parent = (DBSObject)this.parentCache.getObject(monitor, (DBSObject)owner, (String)((Object)parentName), this.parentType)) == null) {
                                log.debug((Object)("Parent object '" + parentName + "' not found"));
                                continue;
                            }
                            Map<PARENT, List<OBJECT>> map2 = this.objectCache;
                            synchronized (map2) {
                                if (this.objectCache.containsKey(parent)) {
                                    continue;
                                }
                            }
                            Map objectMap = parentObjectMap.computeIfAbsent((DBSObject)parent, k -> new TreeMap());
                            Object objectInfo = (DBSObject)objectMap.get(objectName);
                            if (objectInfo != null || (object = this.fetchObject(session, owner, parent, objectName, dbResult)) == null || !this.isValidObject(monitor, (DBSObject)owner, (DBSObject)object)) continue;
                            objectName = object.getName();
                            objectInfo = object;
                            objectMap.put(objectName, objectInfo);
                        }
                    }
                    finally {
                        dbResult.close();
                    }
                }
            }
            catch (SQLException ex) {
                if (JDBCUtils.isFeatureNotSupportedError(owner.getDataSource(), ex)) {
                    log.debug((Object)("Error reading cache " + ((Object)((Object)this)).getClass().getSimpleName() + ", feature not supported: " + ex.getMessage()));
                    break block50;
                }
                DBPDataSource dataSource = owner.getDataSource();
                throw new DBDatabaseException((Throwable)ex, dataSource);
            }
            finally {
                monitor.done();
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        JDBCObjectWithParentCache jDBCObjectWithParentCache = this;
        synchronized (jDBCObjectWithParentCache) {
            Map<PARENT, List<OBJECT>> map = this.objectCache;
            synchronized (map) {
                if (!(forParent == null && parentObjectMap.isEmpty() || forParent != null)) {
                    ArrayList<Object> globalCache = new ArrayList<Object>();
                    for (Map objMap : parentObjectMap.values()) {
                        if (objMap == null) continue;
                        globalCache.addAll(objMap.values());
                    }
                    for (List<OBJECT> objects : this.objectCache.values()) {
                        globalCache.addAll(objects);
                    }
                    super.setCache(globalCache);
                    this.invalidateObjects(monitor, (DBSObject)owner, (Iterator)new AbstractObjectCache.CacheIterator((AbstractObjectCache)this));
                }
                for (Map.Entry colEntry : parentObjectMap.entrySet()) {
                    if (colEntry.getValue() == null || this.objectCache.containsKey(colEntry.getKey())) continue;
                    Collection objectInfos = ((Map)colEntry.getValue()).values();
                    ArrayList objects = new ArrayList(objectInfos.size());
                    objects.addAll(objectInfos);
                    this.objectCache.put((DBSObject)colEntry.getKey(), objects);
                }
                if (forParent == null) {
                    for (DBSObject tmpParent : this.parentCache.getTypedObjects(monitor, (DBSObject)owner, this.parentType)) {
                        if (parentObjectMap.containsKey(tmpParent) || this.objectCache.containsKey(tmpParent)) continue;
                        this.objectCache.put(tmpParent, new ArrayList());
                    }
                } else if (!parentObjectMap.containsKey(forParent) && !this.objectCache.containsKey(forParent)) {
                    this.objectCache.put(forParent, new ArrayList());
                }
            }
        }
    }
}

