/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.views;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.dbeaver.ext.cubrid.ui.internal.CubridMessages;
import org.jkiss.dbeaver.ext.cubrid.ui.views.CubridOIDSearch;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class CubridOIDSearchDialog
extends BaseDialog {
    private static DBIcon cubridIcon = new DBIcon("platform:/plugin/org.jkiss.dbeaver.ext.cubrid/icons/cubrid_icon.png");
    private Text oidValueText;
    private Button findButton;
    private Tree resultTree;
    private Font boldFont;
    private CubridOIDSearch oidSearch;

    public CubridOIDSearchDialog(Shell parentShell, JDBCSession session) {
        super(parentShell, CubridMessages.cubrid_oid_search_navigator_title, (DBPImage)cubridIcon);
        this.oidSearch = new CubridOIDSearch(session);
    }

    protected Point getInitialSize() {
        Point calculatedSize = super.getInitialSize();
        calculatedSize.x = 500;
        return calculatedSize;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Composite createDialogArea(Composite parent) {
        FontData[] fD;
        Composite container = super.createDialogArea(parent);
        Label title = new Label(container, 0);
        title.setText(CubridMessages.cubrid_oid_search_navigator_title);
        for (FontData fd : fD = title.getFont().getFontData()) {
            fd.setHeight(10);
            fd.setStyle(1);
        }
        this.boldFont = new Font((Device)container.getDisplay(), fD);
        title.setFont(this.boldFont);
        Label desc = new Label(container, 0);
        desc.setText(CubridMessages.cubrid_oid_search_navigator_desc);
        Label separator = new Label(container, 258);
        GridData sepLayout = new GridData(768);
        separator.setLayoutData((Object)sepLayout);
        Composite inputArea = new Composite(container, 0);
        inputArea.setLayout((Layout)new GridLayout(3, false));
        inputArea.setLayoutData((Object)new GridData(768));
        Label oidLabel = new Label(inputArea, 0);
        oidLabel.setText(CubridMessages.cubrid_oid_search_value_label + ":");
        this.oidValueText = new Text(inputArea, 18432);
        this.oidValueText.setLayoutData((Object)new GridData(768));
        this.findButton = new Button(inputArea, 8);
        this.findButton.setText(CubridMessages.cubrid_oid_search_find);
        this.findButton.setEnabled(false);
        GridData buttonLayout = new GridData(4, 0x1000000, false, false);
        buttonLayout.widthHint = 80;
        this.findButton.setLayoutData((Object)buttonLayout);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CubridOIDSearchDialog.this.resultTree.removeAll();
                CubridOIDSearchDialog.this.oidSearch.searchOID(CubridOIDSearchDialog.this.oidValueText.getText(), CubridOIDSearchDialog.this.resultTree);
            }
        });
        this.oidValueText.addModifyListener(e -> this.findButton.setEnabled(!this.oidValueText.getText().trim().isEmpty()));
        this.resultTree = new Tree(container, 2816);
        GridData treeLayout = new GridData(1808);
        treeLayout.horizontalSpan = 2;
        treeLayout.heightHint = 150;
        this.resultTree.setLayoutData((Object)treeLayout);
        return container;
    }

    public boolean close() {
        this.boldFont.dispose();
        return super.close();
    }
}

