/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

public enum QuoteStrategy {
    DISABLED("disabled"),
    ALL("all"),
    STRINGS("strings"),
    ALL_BUT_NUMBERS("all but numbers"),
    ALL_INCLUDING_NULLS("all including nulls");

    private final String value;

    private QuoteStrategy(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static QuoteStrategy fromValue(String v) {
        for (QuoteStrategy s : QuoteStrategy.values()) {
            if (!s.value.equals(v)) continue;
            return s;
        }
        if ("true".equalsIgnoreCase(v)) {
            return ALL;
        }
        if ("false".equalsIgnoreCase(v)) {
            return DISABLED;
        }
        return DISABLED;
    }
}

