/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryGenerator;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class StandardSQLDialectQueryGenerator
implements SQLQueryGenerator {
    private static final Log log = Log.getLog(StandardSQLDialectQueryGenerator.class);
    private static final String NESTED_QUERY_AlIAS = "z_q";
    public static StandardSQLDialectQueryGenerator INSTANCE = new StandardSQLDialectQueryGenerator();
    public static final Pattern PATTERN_COLUMN_NAME = Pattern.compile("(([a-z_][a-z0-9_]*)|(\\\"([a-z_][a-z0-9_]*)\\\"))(\\.(([a-z_][a-z0-9_]*)|(\\\"([a-z_][a-z0-9_]*)\\\")))*", 2);

    @Override
    public void appendQueryConditions(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) throws DBException {
        if (dataFilter != null && dataFilter.hasConditions()) {
            query.append("\nWHERE ");
            this.appendConditionString(dataFilter, dataSource, tableAlias, query, true);
        }
    }

    @Override
    public void appendQueryOrder(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasOrdering()) {
            query.append("\nORDER BY ");
            this.appendOrderString(dataFilter, dataSource, tableAlias, false, query);
        }
    }

    @Override
    public void appendConditionString(@NotNull DBDDataFilter filter, @NotNull List<DBDAttributeConstraint> constraints, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) {
        if (filter.isUseDisjunctiveNormalForm() && constraints.size() > 1) {
            int i;
            List<String> names = constraints.stream().map(constraint -> this.getConstraintAttributeName(dataSource, conditionTable, (DBDAttributeConstraint)constraint, subQuery, true)).toList();
            List<Object[]> values = constraints.stream().map(DBDAttributeConstraintBase::getValue).map(Object[].class::cast).toList();
            int count = values.get(0).length;
            for (i = 0; i < count; ++i) {
                if (i > 0) {
                    query.append(" OR ");
                }
                query.append('(');
                for (int j = 0; j < constraints.size(); ++j) {
                    if (j > 0) {
                        query.append(" AND ");
                    }
                    query.append(names.get(j)).append(" = ");
                    query.append(StandardSQLDialectQueryGenerator.getStringValue(dataSource, constraints.get(j), inlineCriteria, values.get(j)[i]));
                }
                query.append(')');
            }
            if (count == 0) {
                for (i = 0; i < constraints.size(); ++i) {
                    if (i > 0) {
                        query.append(" AND ");
                    }
                    query.append(names.get(i)).append(" IS NULL");
                }
            }
        } else {
            String operator = filter.isAnyConstraint() ? " OR " : " AND ";
            for (int index = 0; index < constraints.size(); ++index) {
                DBDAttributeConstraint constraint2 = constraints.get(index);
                if (index > 0) {
                    query.append(operator);
                }
                if (constraints.size() > 1) {
                    query.append('(');
                }
                String attrName = this.getConstraintAttributeName(dataSource, conditionTable, constraint2, subQuery, true);
                if (constraint2.getAttribute() != null) {
                    attrName = dataSource.getSQLDialect().getTypeCastClause(constraint2.getAttribute(), attrName, true);
                }
                query.append(attrName).append(' ').append(this.getConstraintCondition(dataSource, constraint2, conditionTable, inlineCriteria));
                if (constraints.size() <= 1) continue;
                query.append(')');
            }
            if (!CommonUtils.isEmpty((String)filter.getWhere())) {
                if (!constraints.isEmpty()) {
                    query.append(operator).append('(').append(filter.getWhere()).append(')');
                } else {
                    query.append(filter.getWhere());
                }
            }
        }
    }

    @Override
    @NotNull
    public String getQueryWithAppliedFilters(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        boolean isForceFilterSubQuery;
        boolean bl = isForceFilterSubQuery = dataSource.getSQLDialect().supportsSubqueries() && dataSource.getContainer().getPreferenceStore().getBoolean("sql.query.filter.force.subselect");
        if (isForceFilterSubQuery) {
            return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
        }
        try {
            return SQLSemanticProcessor.injectFiltersToQuery(monitor, dataSource, sqlQuery, dataFilter);
        }
        catch (DBException ignored) {
            return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
        }
    }

    @Override
    @NotNull
    public String getWrappedFilterQuery(@NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        StringBuilder modifiedQuery = new StringBuilder(sqlQuery.length() + 100);
        modifiedQuery.append("SELECT * FROM (\n");
        modifiedQuery.append(sqlQuery);
        modifiedQuery.append("\n) ").append(NESTED_QUERY_AlIAS);
        if (dataFilter.hasConditions()) {
            modifiedQuery.append(" WHERE ");
            SQLUtils.appendConditionString(dataFilter, dataSource, NESTED_QUERY_AlIAS, modifiedQuery, true, true);
        }
        if (dataFilter.hasOrdering()) {
            modifiedQuery.append(" ORDER BY ");
            SQLUtils.appendOrderString(dataFilter, dataSource, NESTED_QUERY_AlIAS, true, modifiedQuery);
        }
        return modifiedQuery.toString();
    }

    @Override
    public void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        boolean hasOrder = false;
        for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
            if (hasOrder) {
                query.append(',');
            }
            Object orderString = null;
            if (co.isPlainNameReference() || co.getAttribute() == null || co.getAttribute() instanceof DBDAttributeBindingMeta || co.getAttribute() instanceof DBDAttributeBindingType) {
                String orderColumn;
                String string = orderColumn = subQuery ? co.getAttributeLabel() : co.getAttributeName();
                if (StandardSQLDialectQueryGenerator.canOrderByName(dataSource, co, orderColumn) && !filter.hasNameDuplicates(orderColumn)) {
                    DBDAttributeBinding attrBinding;
                    DBSEntityAttribute dBSEntityAttribute;
                    DBSAttributeBase attr = co.getAttribute();
                    if (attr instanceof DBDAttributeBinding && (dBSEntityAttribute = (attrBinding = (DBDAttributeBinding)attr).getEntityAttribute()) instanceof DBSContextBoundAttribute) {
                        DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)dBSEntityAttribute;
                        orderString = entityAttribute.formatMemberReference(true, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION);
                    } else {
                        orderString = co.getFullAttributeName();
                        if (conditionTable != null) {
                            orderString = conditionTable + "." + (String)orderString;
                        }
                    }
                }
            }
            if (orderString == null) {
                int orderIndex = SQLUtils.getConstraintOrderIndex(filter, co);
                if (orderIndex == -1) {
                    log.debug("Can't generate column order: no name and no position found");
                    continue;
                }
                orderString = String.valueOf(orderIndex);
            }
            query.append((String)orderString);
            if (co.isOrderDescending()) {
                query.append(" DESC");
            }
            hasOrder = true;
        }
        if (!CommonUtils.isEmpty((String)filter.getOrder())) {
            if (hasOrder) {
                query.append(',');
            }
            query.append(filter.getOrder());
        }
    }

    protected static boolean canOrderByName(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @NotNull String constraintName) {
        if (constraint.getAttribute() == null) {
            return true;
        }
        if (!dataSource.getSQLDialect().supportsOrderByIndex()) {
            return true;
        }
        return PATTERN_COLUMN_NAME.matcher(constraintName).matches();
    }

    @Override
    @Nullable
    public String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @Nullable String conditionTable, boolean inlineCriteria) {
        String criteria = constraint.getCriteria();
        if (!CommonUtils.isEmpty((String)criteria)) {
            char firstChar = criteria.trim().charAt(0);
            if (!Character.isLetter(firstChar) && firstChar != '=' && firstChar != '>' && firstChar != '<' && firstChar != '!') {
                return "=" + criteria;
            }
            return criteria;
        }
        if (constraint.getOperator() != null) {
            DBCLogicalOperator operator = constraint.getOperator();
            StringBuilder conString = new StringBuilder();
            Object[] value = constraint.getValue();
            if (DBUtils.isNullValue(value)) {
                if (operator.getArgumentCount() == 0) {
                    return operator.getExpression();
                }
                if (dataSource.getSQLDialect().useEmptyStringForNulls()) {
                    conString.append("=''");
                } else {
                    conString.append("IS ");
                    if (constraint.isReverseOperator()) {
                        conString.append("NOT ");
                    }
                    conString.append("NULL");
                }
                return conString.toString();
            }
            if (constraint.isReverseOperator()) {
                conString.append("NOT ");
            }
            if (operator.getArgumentCount() > 0) {
                if (operator.equals((Object)DBCLogicalOperator.EQUALS) && value instanceof Object[]) {
                    Object[] array = value;
                    for (int i = 0; i < array.length; ++i) {
                        if (i > 0) {
                            conString.append(" OR ");
                            conString.append(DBUtils.getQuotedIdentifier(dataSource, CommonUtils.isEmpty((String)constraint.getAttributeLabel()) ? constraint.getAttributeName() : constraint.getAttributeLabel()));
                            conString.append(' ');
                        }
                        conString.append(operator.getExpression());
                        String strValue = StandardSQLDialectQueryGenerator.getStringValue(dataSource, constraint, inlineCriteria, array[i]);
                        conString.append(' ').append(strValue);
                    }
                } else {
                    conString.append(operator.getExpression());
                    for (int i = 0; i < operator.getArgumentCount(); ++i) {
                        if (i > 0) {
                            conString.append(" AND");
                        }
                        String strValue = StandardSQLDialectQueryGenerator.getStringValue(dataSource, constraint, inlineCriteria, value);
                        conString.append(' ').append(strValue);
                    }
                }
            } else if (operator.getArgumentCount() < 0) {
                int valueCount = Array.getLength(value);
                boolean hasNull = false;
                boolean hasNotNull = false;
                for (int i = 0; i < valueCount; ++i) {
                    boolean isNull = DBUtils.isNullValue(Array.get(value, i));
                    if (isNull && !hasNull) {
                        hasNull = true;
                    }
                    if (isNull || hasNotNull) continue;
                    hasNotNull = true;
                }
                if (!hasNotNull) {
                    return "IS NULL";
                }
                if (hasNull) {
                    DBDAttributeBinding attrBinding;
                    DBSEntityAttribute dBSEntityAttribute;
                    conString.append("IS NULL OR ");
                    DBSAttributeBase attr = constraint.getAttribute();
                    if (attr instanceof DBDAttributeBinding && (dBSEntityAttribute = (attrBinding = (DBDAttributeBinding)attr).getEntityAttribute()) instanceof DBSContextBoundAttribute) {
                        DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)dBSEntityAttribute;
                        conString.append(entityAttribute.formatMemberReference(true, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION));
                    } else {
                        if (constraint.getEntityAlias() != null) {
                            conString.append(constraint.getEntityAlias()).append('.');
                        } else if (conditionTable != null) {
                            conString.append(conditionTable).append('.');
                        }
                        conString.append(DBUtils.getObjectFullName(dataSource, constraint.getAttribute(), DBPEvaluationContext.DML, DBPAttributeReferencePurpose.DATA_SELECTION));
                    }
                    conString.append(" ");
                }
                Pair<String, String> brackets = dataSource.getSQLDialect().getInClauseParentheses();
                conString.append(operator.getExpression());
                conString.append(' ').append((String)brackets.getFirst());
                if (!value.getClass().isArray()) {
                    value = new Object[]{value};
                }
                boolean hasValue = false;
                for (int i = 0; i < valueCount; ++i) {
                    Object itemValue = Array.get(value, i);
                    if (DBUtils.isNullValue(itemValue)) continue;
                    if (hasValue) {
                        conString.append(",");
                    }
                    hasValue = true;
                    if (inlineCriteria) {
                        conString.append(SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), itemValue));
                        continue;
                    }
                    conString.append(dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?", true));
                }
                conString.append((String)brackets.getSecond());
            }
            return conString.toString();
        }
        return null;
    }

    public static String getStringValue(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, boolean inlineCriteria, Object value) {
        String strValue;
        if (constraint.getAttribute() == null) {
            strValue = value instanceof CharSequence ? dataSource.getSQLDialect().getQuotedString(value.toString()) : CommonUtils.toString((Object)value);
        } else if (inlineCriteria) {
            DBDValueHandler valueHandler = DBUtils.findValueHandler(dataSource, (DBSTypedObject)constraint.getAttribute());
            strValue = SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), valueHandler, value, DBDDisplayFormat.NATIVE, true);
        } else {
            strValue = dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?", true);
        }
        return strValue;
    }

    @NotNull
    public String getConstraintAttributeName(@NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull DBDAttributeConstraint constraint, boolean subQuery, boolean includeContainerName) {
        DBSAttributeBase cAttr = constraint.getAttribute();
        if (cAttr instanceof DBDAttributeBinding) {
            DBDAttributeBinding binding = (DBDAttributeBinding)cAttr;
            if (binding.getEntityAttribute() != null && binding.getMetaAttribute() != null && binding.getEntityAttribute().getName().equals(binding.getMetaAttribute().getName()) || binding instanceof DBDAttributeBindingType) {
                DBSEntityAttribute dBSEntityAttribute = binding.getEntityAttribute();
                if (dBSEntityAttribute instanceof DBSContextBoundAttribute) {
                    DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)dBSEntityAttribute;
                    return entityAttribute.formatMemberReference(includeContainerName, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION);
                }
                return DBUtils.getObjectFullName(dataSource, binding, DBPEvaluationContext.DML, DBPAttributeReferencePurpose.DATA_SELECTION);
            }
            if (binding.getMetaAttribute() == null || binding.getEntityAttribute() != null) {
                return DBUtils.getQuotedIdentifier(dataSource, subQuery ? constraint.getAttributeLabel() : constraint.getAttributeName());
            }
            String metaName = binding.getMetaAttribute().getName();
            String attrName = CommonUtils.isNotEmpty((String)metaName) ? binding.getMetaAttribute().getName() : binding.getMetaAttribute().getLabel();
            return DBUtils.getQuotedIdentifier(dataSource, attrName);
        }
        if (cAttr != null) {
            return DBUtils.getObjectFullName(dataSource, cAttr, DBPEvaluationContext.DML, DBPAttributeReferencePurpose.DATA_SELECTION);
        }
        return DBUtils.getQuotedIdentifier(dataSource, constraint.getAttributeName());
    }

    protected StandardSQLDialectQueryGenerator() {
    }
}

