/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.AbstractDataSource;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public abstract class AbstractSimpleDataSource<EXEC_CONTEXT extends DBCExecutionContext>
extends AbstractDataSource
implements DBSInstance,
DBSObjectContainer,
DBSObject {
    private static final Log log = Log.getLog(AbstractSimpleDataSource.class);
    protected EXEC_CONTEXT executionContext;
    @NotNull
    protected List<EXEC_CONTEXT> allContexts = new ArrayList<EXEC_CONTEXT>();
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();

    public AbstractSimpleDataSource(@NotNull DBPDataSourceContainer container) {
        super(container);
    }

    @NotNull
    public EXEC_CONTEXT getDefaultContext(@NotNull DBRProgressMonitor monitor, boolean meta) {
        return this.executionContext;
    }

    public EXEC_CONTEXT getDefaultContext() {
        return this.executionContext;
    }

    @Override
    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new DBCExecutionContext[0]);
    }

    @NotNull
    public abstract EXEC_CONTEXT openIsolatedContext(@NotNull DBRProgressMonitor var1, @NotNull String var2, @Nullable DBCExecutionContext var3) throws DBException;

    @Override
    @NotNull
    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    public void addExecutionContext(EXEC_CONTEXT context) {
        this.allContexts.add(context);
    }

    public void removeExecutionContext(EXEC_CONTEXT context) {
        this.allContexts.remove(context);
    }

    @Override
    @NotNull
    public DBSInstance getDefaultInstance() {
        return this;
    }

    @Override
    @NotNull
    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(@NotNull DBRProgressMonitor monitor) {
        Object lock = this.exclusiveLock.acquireExclusiveLock();
        try {
            this.executionContext.close();
        }
        catch (DBException e) {
            log.error("Rrror shutting down datasource", e);
        }
        finally {
            this.exclusiveLock.releaseExclusiveLock(lock);
        }
    }
}

