/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceTransactionModeContributor;
import org.jkiss.utils.CommonUtils;

public class ToolsContextMenuHandler
extends AbstractDataSourceHandler {
    private MenuManager menuManager = new MenuManager();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (part == null || activeShell == null) {
            return null;
        }
        Control focusControl = activeShell.getDisplay().getFocusControl();
        if (focusControl == null) {
            return null;
        }
        Point location = ActionUtils.getLocationFromControl((Shell)activeShell, (Control)focusControl);
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        this.menuManager = new MenuManager();
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.connect"));
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.disconnect"));
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.invalidate"));
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.connection.readonly"));
        if (part instanceof IEditorPart) {
            this.menuManager.add((IContributionItem)new Separator());
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.commit"));
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.rollback"));
            MenuManager txnMenu = new MenuManager(DBeaverActivator.getPluginResourceBundle().getString("command.org.jkiss.dbeaver.core.transaction_mode.name"));
            txnMenu.add((IContributionItem)new DataSourceTransactionModeContributor());
            this.menuManager.add((IContributionItem)txnMenu);
        }
        this.menuManager.add((IContributionItem)new Separator());
        if (ActionUtils.isCommandEnabled((String)"org.jkiss.dbeaver.core.sql.editor.open", (IServiceLocator)part.getSite())) {
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.sql.editor.open"));
        }
        if (part instanceof IEditorPart) {
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), (String)"org.jkiss.dbeaver.core.navigator.linkeditor", (String)CoreMessages.action_menu_tools_find_in_navigator, null));
        }
        final Menu contextMenu = this.menuManager.createContextMenu(focusControl);
        if (location != null) {
            contextMenu.setLocation(location);
        }
        contextMenu.setVisible(true);
        contextMenu.addMenuListener((MenuListener)new MenuAdapter(this){

            public void menuShown(MenuEvent e) {
                int keyIndex = 0;
                for (MenuItem item : contextMenu.getItems()) {
                    if (CommonUtils.isEmpty((String)item.getText())) continue;
                    item.setText(ActionUtils.getLabelWithIndexMnemonic((String)item.getText(), (int)keyIndex));
                    ++keyIndex;
                }
            }
        });
        return null;
    }
}

