/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jface.wizard.WizardPage;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;

class ProjectImportData {
    private File importFile = null;
    private boolean importDriverLibraries = true;
    private Document metaTree;
    private Map<String, String> projectNameMap = new HashMap<String, String>();

    ProjectImportData() {
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
        this.metaTree = null;
    }

    public boolean isImportDriverLibraries() {
        return this.importDriverLibraries;
    }

    public void setImportDriverLibraries(boolean importDriverLibraries) {
        this.importDriverLibraries = importDriverLibraries;
    }

    public Document getMetaTree() {
        return this.metaTree;
    }

    boolean isFileSpecified(WizardPage page) {
        if (this.importFile == null) {
            page.setMessage("Import file not specified", 3);
            return false;
        }
        if (!this.importFile.exists()) {
            page.setMessage("File '" + this.importFile.getAbsolutePath() + "' doesn't exist", 3);
            return false;
        }
        if (!this.importFile.isFile()) {
            page.setMessage("File '" + this.importFile.getAbsolutePath() + "' is a directory", 3);
            return false;
        }
        page.setMessage("Configure project import settings", 0);
        return true;
    }

    public boolean isProjectsSelected(WizardPage page) {
        return !this.projectNameMap.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadArchiveMeta(WizardPage page) {
        try (ZipFile zipFile = new ZipFile(this.importFile, 1);){
            ZipEntry metaEntry = zipFile.getEntry("meta.xml");
            if (metaEntry == null) {
                page.setMessage("Cannot find meta file", 3);
                boolean bl = false;
                return bl;
            }
            try (InputStream metaStream = zipFile.getInputStream(metaEntry);){
                this.metaTree = XMLUtils.parseDocument((InputStream)metaStream);
            }
            catch (XMLException e) {
                page.setMessage("Cannot parse meta file: " + e.getMessage(), 3);
                boolean bl = false;
                zipFile.close();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            page.setMessage("Cannot open archive '" + this.importFile.getAbsolutePath() + "': " + e.getMessage(), 3);
            return false;
        }
    }

    public String getTargetProjectName(String projectName) {
        return this.projectNameMap.get(projectName);
    }

    public void clearProjectNameMap() {
        this.projectNameMap.clear();
    }

    public void addProjectName(String sourceName, String targetName) {
        this.projectNameMap.put(sourceName, targetName);
    }
}

