/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.EnumMap;
import org.eclipse.jface.viewers.StyledString;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposalContext;

public class SQLEditorQueryCompletionProposalContext
extends SQLQueryCompletionProposalContext {
    private static final EnumMap<SQLQueryCompletionItemKind, String> registryStyleByItemKind = new EnumMap<SQLQueryCompletionItemKind, String>(SQLQueryCompletionItemKind.class){
        {
            this.put(SQLQueryCompletionItemKind.RESERVED, "org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
            this.put(SQLQueryCompletionItemKind.SUBQUERY_ALIAS, "org.jkiss.dbeaver.sql.editor.color.table.alias.foreground");
            this.put(SQLQueryCompletionItemKind.RELATED_SUBQUERY_ALIAS, "org.jkiss.dbeaver.sql.editor.color.table.alias.foreground");
            this.put(SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME, "org.jkiss.dbeaver.sql.editor.color.column.derived.foreground");
            this.put(SQLQueryCompletionItemKind.NEW_TABLE_NAME, "org.jkiss.dbeaver.sql.editor.color.table.foreground");
            this.put(SQLQueryCompletionItemKind.USED_TABLE_NAME, "org.jkiss.dbeaver.sql.editor.color.table.foreground");
            this.put(SQLQueryCompletionItemKind.RELATED_TABLE_NAME, "org.jkiss.dbeaver.sql.editor.color.table.foreground");
            this.put(SQLQueryCompletionItemKind.TABLE_COLUMN_NAME, "org.jkiss.dbeaver.sql.editor.color.column.foreground");
            this.put(SQLQueryCompletionItemKind.PROCEDURE, "org.jkiss.dbeaver.sql.editor.color.function.foreground");
            this.put(SQLQueryCompletionItemKind.COMPOSITE_FIELD_NAME, "org.jkiss.dbeaver.sql.editor.color.composite.field.foreground");
        }
    };
    private final EnumMap<SQLQueryCompletionItemKind, StyledString.Styler> stylerByItemKind = new EnumMap<SQLQueryCompletionItemKind, StyledString.Styler>(SQLQueryCompletionItemKind.class){
        {
            registryStyleByItemKind.forEach((k, v) -> this.put(k, StyledString.createColorRegistryStyler((String)v, null)));
        }
    };
    private final boolean insertSpaceAfterProposal;

    public SQLEditorQueryCompletionProposalContext(@NotNull SQLCompletionRequest completionRequest, int requestOffset) {
        super(completionRequest, requestOffset);
        DBCExecutionContext executionContext = completionRequest.getContext().getExecutionContext();
        if (executionContext != null) {
            DBPPreferenceStore prefStore = executionContext.getDataSource().getContainer().getPreferenceStore();
            this.insertSpaceAfterProposal = prefStore.getBoolean("SQLEditor.ContentAssistant.insert.space.after.proposal");
        } else {
            this.insertSpaceAfterProposal = true;
        }
    }

    @Nullable
    public StyledString.Styler getStyler(@NotNull SQLQueryCompletionItemKind itemKind) {
        return this.stylerByItemKind.get(itemKind);
    }

    public boolean isInsertSpaceAfterProposal() {
        return this.insertSpaceAfterProposal;
    }
}

