/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;

public class ClassLoaderScriptSource
implements SQLSchemaScriptSource {
    private static final Log log = Log.getLog(ClassLoaderScriptSource.class);
    private final ClassLoader classLoader;
    private final String createScriptPath;
    private final String updateScriptPrefix;

    public ClassLoaderScriptSource(ClassLoader classLoader, String createScriptPath, String updateScriptPrefix) {
        this.classLoader = classLoader;
        this.createScriptPath = createScriptPath;
        this.updateScriptPrefix = updateScriptPrefix;
    }

    @Override
    @NotNull
    public Reader openSchemaCreateScript(@NotNull DBRProgressMonitor monitor, @Nullable String specificPrefix) throws IOException, DBException {
        List<CallSite> attemptedPaths = specificPrefix == null ? List.of(this.createScriptPath + ".sql") : List.of(this.createScriptPath + "_" + specificPrefix + ".sql", this.createScriptPath + ".sql");
        Reader reader = this.findScript(attemptedPaths.toArray(new String[0]));
        if (reader == null) {
            throw new IOException("Create script not found. Searched paths: " + String.join((CharSequence)", ", attemptedPaths));
        }
        return reader;
    }

    @Override
    @Nullable
    public Reader openSchemaUpdateScript(@NotNull DBRProgressMonitor monitor, int versionNumber, @Nullable String specificPrefix) throws IOException, DBException {
        List<CallSite> attemptedPaths = specificPrefix == null ? List.of(this.updateScriptPrefix + versionNumber + ".sql") : List.of(this.updateScriptPrefix + versionNumber + "_" + specificPrefix + ".sql", this.updateScriptPrefix + versionNumber + ".sql");
        return this.findScript(attemptedPaths.toArray(new String[0]));
    }

    @Nullable
    public Reader findScript(String ... paths) {
        for (String path : paths) {
            InputStream resource = this.classLoader.getResourceAsStream(path);
            if (resource == null) continue;
            log.debug((Object)("Reading script file: '" + path + "'"));
            return new InputStreamReader(resource);
        }
        return null;
    }
}

