/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.pgadmin;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.config.migration.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.pgadmin.ConfigImportWizardPgAdmin;
import org.jkiss.dbeaver.ui.config.migration.wizards.pgadmin.PgAdminImportConfigurationService;

public class ConfigImportWizardPagePgAdminConnections
extends ConfigImportWizardPage {
    private static final Log log = Log.getLog(ConfigImportWizardPagePgAdminConnections.class);
    private static final PgAdminImportConfigurationService IMPORT_CONFIGURATION_SERVICE = PgAdminImportConfigurationService.INSTANCE;

    public ConfigImportWizardPagePgAdminConnections() {
        super(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setTitle(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setDescription(ImportConfigMessages.config_import_wizard_header_import_configuration);
    }

    @Override
    protected void loadConnections(@NotNull ImportData importData) throws DBException {
        this.setErrorMessage(null);
        ConfigImportWizardPgAdmin wizard = (ConfigImportWizardPgAdmin)this.getWizard();
        File inputFile = wizard.getInputFile();
        try (BufferedReader reader = Files.newBufferedReader(inputFile.toPath());){
            IMPORT_CONFIGURATION_SERVICE.importJSON(importData, reader);
        }
        catch (Exception e) {
            log.warn((Object)"Exception during loading connections", (Throwable)e);
            this.setErrorMessage(e.getMessage());
        }
    }
}

