/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDependencyType;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleDependency
extends OracleObject<DBSObject>
implements DBPUniqueObject,
DBPImageProvider {
    private final String objectOwnerName;
    private final String objectName;
    private final OracleObjectType objectType;
    private final OracleDependencyType dependencyType;

    public OracleDependency(DBSObject parent, String objectOwnerName, String objectName, String objectType, String dependencyType) {
        super(parent, null, parent.isPersisted());
        this.objectOwnerName = objectOwnerName;
        this.objectName = objectName;
        this.objectType = OracleObjectType.getByType(objectType);
        this.dependencyType = OracleDependencyType.getByType(dependencyType);
    }

    @NotNull
    public static List<OracleDependency> readDependencies(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, boolean dependents) throws DBException {
        ArrayList<OracleDependency> dependencies = new ArrayList<OracleDependency>();
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)"Load object dependencies");){
            OracleDataSource dataSource = (OracleDataSource)object.getDataSource();
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(dataSource) + " *\nFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "DEPENDENCIES") + "\nWHERE " + (dependents ? "REFERENCED_OWNER=? AND REFERENCED_NAME=?" : "OWNER=? AND NAME=? AND REFERENCED_TYPE <> 'NON-EXISTENT'") + "\nORDER BY " + (dependents ? "NAME" : "REFERENCED_NAME"));){
                dbStat.setString(1, object.getParentObject().getName());
                dbStat.setString(2, object.getName());
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        dependencies.add(new OracleDependency(object, JDBCUtils.safeGetString((ResultSet)dbResult, (String)(dependents ? "OWNER" : "REFERENCED_OWNER")), JDBCUtils.safeGetString((ResultSet)dbResult, (String)(dependents ? "NAME" : "REFERENCED_NAME")), JDBCUtils.safeGetString((ResultSet)dbResult, (String)(dependents ? "TYPE" : "REFERENCED_TYPE")), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEPENDENCY_TYPE")));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DBCException("Error reading dependencies", (Throwable)e);
        }
        return dependencies;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.objectName;
    }

    @Property(viewable=true, order=2)
    public OracleObjectType getObjectType() {
        return this.objectType;
    }

    @Property(viewable=true, order=3)
    public OracleSchema getObjectOwner(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getSchema(monitor, this.objectOwnerName);
    }

    @Property(viewable=true, order=4)
    public DBSObject getObject(DBRProgressMonitor monitor) throws DBException {
        return this.objectType.findObject(monitor, this.getObjectOwner(monitor), this.objectName);
    }

    @Property(viewable=true, order=5)
    public OracleDependencyType getDependencyType() {
        return this.dependencyType;
    }

    public DBPImage getObjectImage() {
        return this.objectType.getImage();
    }

    @NotNull
    public String getUniqueName() {
        return this.objectOwnerName + "." + this.objectName + "(" + String.valueOf((Object)this.dependencyType) + ")";
    }
}

