/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary.dialogs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.ui.editors.binary.HexManager;
import org.jkiss.dbeaver.ui.editors.binary.internal.BinaryEditorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class FindReplaceDialog
extends Dialog {
    private static final Pattern patternHexDigits = Pattern.compile("[0-9a-fA-F]*");
    private static final String text1Replacement = BinaryEditorMessages.dialog_find_replace_1_replacement;
    private static final String textBackward = BinaryEditorMessages.dialog_find_replace_backward;
    private static final String textCancel = BinaryEditorMessages.dialog_find_replace_cancel;
    private static final String textClose = BinaryEditorMessages.dialog_find_replace_close;
    private static final String textDirection = BinaryEditorMessages.dialog_find_replace_direction;
    private static final String textError = BinaryEditorMessages.dialog_find_replace_error_;
    private static final String textFind = BinaryEditorMessages.dialog_find_replace_find;
    private static final String textFindLiteral = BinaryEditorMessages.dialog_find_replace_find_literal;
    private static final String textFindReplace = BinaryEditorMessages.dialog_find_replace_find_replace;
    private static final String textForward = BinaryEditorMessages.dialog_find_replace_forward;
    private static final String textFoundLiteral = BinaryEditorMessages.dialog_find_replace_found_literal;
    private static final String textHex = "Hex";
    private static final String textIgnoreCase = BinaryEditorMessages.dialog_find_replace_ignore_case;
    private static final String textLiteralNotFound = BinaryEditorMessages.dialog_find_replace_literal_not_found;
    private static final String textNewFind = BinaryEditorMessages.dialog_find_replace_new_find;
    private static final String textReplace = BinaryEditorMessages.dialog_find_replace_replace;
    private static final String textReplaceAll = BinaryEditorMessages.dialog_find_replace_replace_all;
    private static final String textReplaceFind = BinaryEditorMessages.dialog_find_replace_replace_find;
    private static final String textReplaceWith = BinaryEditorMessages.dialog_find_replace_replace_with;
    private static final String textReplacements = BinaryEditorMessages.dialog_find_replace_replacements;
    private static final String textSearching = BinaryEditorMessages.dialog_find_replace_searching;
    private static final String textStop = BinaryEditorMessages.dialog_find_replace_stop;
    private static final String textText = BinaryEditorMessages.dialog_find_replace_text;
    SelectionAdapter defaultSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (FindReplaceDialog.this.lastIgnoreCase != FindReplaceDialog.this.checkBox.getSelection() || FindReplaceDialog.this.lastForward != FindReplaceDialog.this.forwardRadioButton.getSelection() || FindReplaceDialog.this.lastFindHexButtonSelected != FindReplaceDialog.this.findGroup.hexRadioButton.getSelection() || FindReplaceDialog.this.lastReplaceHexButtonSelected != FindReplaceDialog.this.replaceGroup.hexRadioButton.getSelection()) {
                FindReplaceDialog.this.feedbackLabel.setText("");
            }
            FindReplaceDialog.this.lastFocused.textCombo.setFocus();
        }
    };
    private static final List<Object[]> findReplaceFindList = new ArrayList<Object[]>();
    private static final List<Object[]> findReplaceReplaceList = new ArrayList<Object[]>();
    private HexEditControl editControl = null;
    private TextHexInputGroup lastFocused = null;
    private boolean lastForward = true;
    private boolean lastFindHexButtonSelected = true;
    private boolean lastReplaceHexButtonSelected = true;
    private boolean lastIgnoreCase = false;
    private boolean searching = false;
    private Shell sShell = null;
    private TextHexInputGroup findGroup = null;
    private TextHexInputGroup replaceGroup = null;
    private Group directionGroup = null;
    private Button forwardRadioButton = null;
    private Button backwardRadioButton = null;
    private Button checkBox = null;
    private Composite findReplaceButtonsComposite = null;
    private Button findButton = null;
    private Button replaceFindButton = null;
    private Button replaceButton = null;
    private Button replaceAllButton = null;
    private Label feedbackLabel = null;
    private Composite progressComposite = null;
    private ProgressBar progressBar = null;
    private Button progressCancelButton = null;
    private Button closeButton = null;

    public FindReplaceDialog(Shell aShell) {
        super(aShell);
    }

    private void activateProgressBar() {
        Display.getCurrent().timerExec(500, new Runnable(){

            @Override
            public void run() {
                if (FindReplaceDialog.this.searching && !FindReplaceDialog.this.progressComposite.isDisposed()) {
                    FindReplaceDialog.this.progressComposite.setVisible(true);
                }
            }
        });
        long max = this.editControl.getContent().length();
        long min = this.editControl.getCaretPos();
        if (this.backwardRadioButton.getSelection()) {
            max = min;
            min = 0L;
        }
        int factor = 0;
        while (max > Integer.MAX_VALUE) {
            max >>>= 1;
            min >>>= 1;
            ++factor;
        }
        this.progressBar.setMaximum((int)max);
        this.progressBar.setMinimum((int)min);
        this.progressBar.setSelection(0);
        final int finalFactor = factor;
        Display.getCurrent().timerExec(1000, new Runnable(){
            final /* synthetic */ FindReplaceDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.this$0.searching || this.this$0.progressBar.isDisposed()) {
                    return;
                }
                int selection = 0;
                if (this.this$0.editControl.getFinder() != null) {
                    selection = (int)(this.this$0.editControl.getFinder().getSearchPosition() >>> finalFactor);
                    if (this.this$0.backwardRadioButton.getSelection()) {
                        selection = this.this$0.progressBar.getMaximum() - selection;
                    }
                }
                this.this$0.progressBar.setSelection(selection);
                Display.getCurrent().timerExec(1000, (Runnable)this);
            }
        });
    }

    public void open() {
        if (this.sShell == null || this.sShell.isDisposed()) {
            this.createSShell();
        }
        this.sShell.pack();
        HexManager.reduceDistance(this.getParent(), this.sShell);
        this.findGroup.refreshCombo();
        long selectionLength = this.editControl.getSelection()[1] - this.editControl.getSelection()[0];
        if (selectionLength > 0L && selectionLength <= 2048L) {
            this.findGroup.refreshHexOrText(true);
            this.checkBox.setEnabled(false);
            StringBuilder selectedText = new StringBuilder();
            byte[] selection = new byte[(int)selectionLength];
            try {
                this.editControl.getContent().get(ByteBuffer.wrap(selection), this.editControl.getSelection()[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            int i = 0;
            while ((long)i < selectionLength) {
                selectedText.append(GeneralUtils.byteToHex[selection[i] & 0xFF]);
                ++i;
            }
            this.findGroup.textCombo.setText(selectedText.toString());
            this.findGroup.selectText();
        } else {
            this.findGroup.refreshHexOrText(this.lastFindHexButtonSelected);
            this.checkBox.setEnabled(!this.lastFindHexButtonSelected);
        }
        this.replaceGroup.refreshHexOrText(this.lastReplaceHexButtonSelected);
        this.replaceGroup.refreshCombo();
        this.checkBox.setSelection(this.lastIgnoreCase);
        if (this.lastForward) {
            this.forwardRadioButton.setSelection(true);
        } else {
            this.backwardRadioButton.setSelection(true);
        }
        this.feedbackLabel.setText(textNewFind);
        this.lastFocused = this.findGroup;
        this.lastFocused.textCombo.setFocus();
        this.enableDisableControls();
        this.sShell.open();
    }

    private void createFindReplaceButtonsComposite() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.findReplaceButtonsComposite = new Composite((Composite)this.sShell, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.directionGroup);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.findReplaceButtonsComposite.setLayoutData((Object)formData);
        this.findReplaceButtonsComposite.setLayout((Layout)gridLayout);
        this.findButton = new Button(this.findReplaceButtonsComposite, 0);
        this.findButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.findButton.setText(textFind);
        this.findButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.doFind();
            }
        });
        this.replaceFindButton = new Button(this.findReplaceButtonsComposite, 0);
        this.replaceFindButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.replaceFindButton.setText(textReplaceFind);
        this.replaceFindButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.replaceFindButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.doReplaceFind();
            }
        });
        this.replaceButton = new Button(this.findReplaceButtonsComposite, 0);
        this.replaceButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.replaceButton.setText(textReplace);
        this.replaceButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.replaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.doReplace();
            }
        });
        this.replaceAllButton = new Button(this.findReplaceButtonsComposite, 0);
        this.replaceAllButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.replaceAllButton.setText(textReplaceAll);
        this.replaceAllButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.replaceAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.doReplaceAll();
            }
        });
        this.sShell.setDefaultButton(this.findButton);
    }

    private void createIgnoreCaseComposite() {
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        Composite ignoreCaseComposite = new Composite((Composite)this.sShell, 0);
        ignoreCaseComposite.setLayout((Layout)fillLayout);
        this.checkBox = new Button(ignoreCaseComposite, 32);
        this.checkBox.setText(textIgnoreCase);
        this.checkBox.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.replaceGroup.group);
        formData.left = new FormAttachment((Control)this.directionGroup);
        ignoreCaseComposite.setLayoutData((Object)formData);
    }

    private void createDirectionGroup() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.fill = true;
        rowLayout.type = 512;
        this.directionGroup = new Group((Composite)this.sShell, 0);
        this.directionGroup.setText(textDirection);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.replaceGroup.group);
        this.directionGroup.setLayoutData((Object)formData);
        this.directionGroup.setLayout((Layout)rowLayout);
        this.forwardRadioButton = new Button((Composite)this.directionGroup, 16);
        this.forwardRadioButton.setText(textForward);
        this.forwardRadioButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.backwardRadioButton = new Button((Composite)this.directionGroup, 16);
        this.backwardRadioButton.setText(textBackward);
        this.backwardRadioButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
    }

    private void createSShell() {
        this.sShell = new Shell(this.getParent(), 2144);
        this.sShell.setText(textFindReplace);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        formLayout.spacing = 5;
        this.sShell.setLayout((Layout)formLayout);
        this.sShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                FindReplaceDialog.this.enableDisableControls();
            }
        });
        if (this.findGroup == null) {
            this.findGroup = new TextHexInputGroup(findReplaceFindList);
        }
        this.findGroup.initialise();
        this.findGroup.group.setText(textFindLiteral);
        SelectionAdapter hexTextSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.checkBox.setEnabled(e.widget == FindReplaceDialog.this.findGroup.textRadioButton);
            }
        };
        this.findGroup.textRadioButton.addSelectionListener((SelectionListener)hexTextSelectionAdapter);
        this.findGroup.hexRadioButton.addSelectionListener((SelectionListener)hexTextSelectionAdapter);
        if (this.replaceGroup == null) {
            this.replaceGroup = new TextHexInputGroup(findReplaceReplaceList);
        }
        this.replaceGroup.initialise();
        this.replaceGroup.group.setText(textReplaceWith);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.findGroup.group);
        this.replaceGroup.group.setLayoutData((Object)formData);
        this.createDirectionGroup();
        this.createIgnoreCaseComposite();
        this.createFindReplaceButtonsComposite();
        Composite feedbackComposite = new Composite((Composite)this.sShell, 0);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.findReplaceButtonsComposite);
        formData2.left = new FormAttachment(0);
        formData2.bottom = new FormAttachment(100);
        feedbackComposite.setLayoutData((Object)formData2);
        FormLayout formLayout2 = new FormLayout();
        feedbackComposite.setLayout((Layout)formLayout2);
        this.feedbackLabel = new Label(feedbackComposite, 0x1000000);
        this.feedbackLabel.setText(textNewFind);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment(0);
        formData3.left = new FormAttachment(0);
        formData3.right = new FormAttachment(100);
        this.feedbackLabel.setLayoutData((Object)formData3);
        this.progressComposite = new Composite(feedbackComposite, 0);
        FormLayout formLayout3 = new FormLayout();
        formLayout3.spacing = 5;
        this.progressComposite.setLayout((Layout)formLayout3);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.feedbackLabel);
        formData4.bottom = new FormAttachment(100);
        formData4.left = new FormAttachment(0);
        formData4.right = new FormAttachment(100);
        this.progressComposite.setLayoutData((Object)formData4);
        this.progressBar = new ProgressBar(this.progressComposite, 0);
        FormData formData5 = new FormData();
        formData5.bottom = new FormAttachment(100);
        formData5.left = new FormAttachment(0);
        formData5.height = this.progressBar.computeSize((int)-1, (int)-1, (boolean)false).y;
        this.progressBar.setLayoutData((Object)formData5);
        this.progressCancelButton = new Button(this.progressComposite, 0);
        this.progressCancelButton.setText(textCancel);
        FormData formData6 = new FormData();
        formData6.right = new FormAttachment(100);
        this.progressCancelButton.setLayoutData((Object)formData6);
        formData5.right = new FormAttachment((Control)this.progressCancelButton);
        this.progressCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.editControl.stopSearching();
            }
        });
        this.progressComposite.setVisible(false);
        this.closeButton = new Button((Composite)this.sShell, 0);
        this.closeButton.setText(textClose);
        FormData formData1 = new FormData();
        formData1.right = new FormAttachment(100);
        formData1.bottom = new FormAttachment(100);
        this.closeButton.setLayoutData((Object)formData1);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.sShell.close();
            }
        });
        formData2.right = new FormAttachment((Control)this.closeButton);
        this.sShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                FindReplaceDialog.this.editControl.stopSearching();
            }
        });
    }

    private void doReplace() {
        this.replace();
        this.enableDisableControls();
        this.feedbackLabel.setText("");
    }

    private void doReplaceFind() {
        this.replace();
        this.doFind();
    }

    private void doFind() {
        this.prepareToRun();
        this.progressCancelButton.setText(textCancel);
        Object message = textLiteralNotFound;
        String literal = this.findGroup.textCombo.getText();
        if (this.editControl != null && literal.length() > 0) {
            try {
                if (this.editControl.findAndSelect(literal, this.findGroup.hexRadioButton.getSelection(), this.forwardRadioButton.getSelection(), this.checkBox.getSelection())) {
                    message = textFoundLiteral;
                }
            }
            catch (IOException e) {
                message = textError + String.valueOf(e);
            }
        }
        this.endOfRun((String)message);
    }

    private void doReplaceAll() {
        this.prepareToRun();
        this.progressCancelButton.setText(textStop);
        Object message = textLiteralNotFound;
        String literal = this.findGroup.textCombo.getText();
        if (this.editControl != null && literal.length() > 0) {
            try {
                int replacements = this.editControl.replaceAll(literal, this.findGroup.hexRadioButton.getSelection(), this.forwardRadioButton.getSelection(), this.checkBox.getSelection(), this.replaceGroup.textCombo.getText(), this.replaceGroup.hexRadioButton.getSelection());
                message = replacements + textReplacements;
                if (replacements == 1) {
                    message = text1Replacement;
                }
            }
            catch (IOException e) {
                message = textError + String.valueOf(e);
            }
        }
        this.endOfRun((String)message);
    }

    private void enableDisableControls() {
        this.findGroup.setEnabled(!this.searching);
        this.replaceGroup.setEnabled(!this.searching);
        this.directionGroup.setEnabled(!this.searching);
        this.forwardRadioButton.setEnabled(!this.searching);
        this.backwardRadioButton.setEnabled(!this.searching);
        this.checkBox.setEnabled(!this.searching);
        this.findButton.setEnabled(!this.searching);
        this.replaceFindButton.setEnabled(!this.searching);
        this.replaceButton.setEnabled(!this.searching);
        this.replaceAllButton.setEnabled(!this.searching);
        this.closeButton.setEnabled(!this.searching);
        if (this.searching) {
            return;
        }
        boolean somethingToFind = this.findGroup.textCombo.getText().length() > 0;
        this.findButton.setEnabled(somethingToFind);
        this.replaceAllButton.setEnabled(somethingToFind);
        long selectionLength = 0L;
        if (this.editControl != null) {
            selectionLength = this.editControl.getSelection()[1] - this.editControl.getSelection()[0];
        }
        this.replaceFindButton.setEnabled(selectionLength > 0L && somethingToFind);
        this.replaceButton.setEnabled(selectionLength > 0L);
    }

    private void endOfRun(String message) {
        this.searching = false;
        if (this.progressComposite.isDisposed()) {
            return;
        }
        this.progressComposite.setVisible(false);
        this.feedbackLabel.setText(message);
        this.enableDisableControls();
    }

    private void prepareToRun() {
        this.searching = true;
        this.lastFindHexButtonSelected = this.findGroup.hexRadioButton.getSelection();
        this.lastReplaceHexButtonSelected = this.replaceGroup.hexRadioButton.getSelection();
        this.replaceGroup.rememberText();
        this.findGroup.rememberText();
        this.lastForward = this.forwardRadioButton.getSelection();
        this.lastIgnoreCase = this.checkBox.getSelection();
        this.feedbackLabel.setText(textSearching);
        this.enableDisableControls();
        this.activateProgressBar();
    }

    private void replace() {
        this.editControl.replace(this.replaceGroup.textCombo.getText(), this.replaceGroup.hexRadioButton.getSelection());
    }

    public void setTarget(HexEditControl aTarget) {
        this.editControl = aTarget;
    }

    class TextHexInputGroup {
        private List<Object[]> items = null;
        private Group group = null;
        private Composite composite = null;
        private Button hexRadioButton = null;
        private Button textRadioButton = null;
        private Combo textCombo = null;

        public TextHexInputGroup(List<Object[]> oldItems) {
            this.items = oldItems;
        }

        private void initialise() {
            this.group = new Group((Composite)FindReplaceDialog.this.sShell, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            this.group.setLayout((Layout)gridLayout);
            this.createComposite();
            this.textCombo = new Combo((Composite)this.group, 2048);
            int columns = 35;
            GC gc = new GC((Drawable)this.textCombo);
            FontMetrics fm = gc.getFontMetrics();
            int width = columns * fm.getAverageCharWidth();
            gc.dispose();
            this.textCombo.setLayoutData((Object)new GridData(width, -1));
            this.textCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.keyCode == 0) {
                        return;
                    }
                    if (TextHexInputGroup.this.hexRadioButton.getSelection()) {
                        Matcher numberMatcher = patternHexDigits.matcher(e.text);
                        e.doit = numberMatcher.matches();
                    }
                }
            });
            this.textCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = TextHexInputGroup.this.textCombo.getSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    Boolean selection = (Boolean)(TextHexInputGroup.this.items == null ? null : TextHexInputGroup.this.items.get(index)[1]);
                    if (selection != null) {
                        TextHexInputGroup.this.refreshHexOrText(selection);
                    }
                }
            });
            this.textCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FindReplaceDialog.this.feedbackLabel.setText("");
                    if (TextHexInputGroup.this == FindReplaceDialog.this.findGroup) {
                        FindReplaceDialog.this.enableDisableControls();
                    }
                }
            });
        }

        private void createComposite() {
            RowLayout rowLayout1 = new RowLayout();
            rowLayout1.marginTop = 2;
            rowLayout1.marginBottom = 2;
            rowLayout1.type = 512;
            this.composite = new Composite((Composite)this.group, 0);
            this.composite.setLayout((Layout)rowLayout1);
            this.hexRadioButton = new Button(this.composite, 16);
            this.hexRadioButton.setText(FindReplaceDialog.textHex);
            this.hexRadioButton.addSelectionListener((SelectionListener)FindReplaceDialog.this.defaultSelectionAdapter);
            this.hexRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Matcher numberMatcher = patternHexDigits.matcher(TextHexInputGroup.this.textCombo.getText());
                    if (!numberMatcher.matches()) {
                        TextHexInputGroup.this.textCombo.setText("");
                    }
                }
            });
            this.textRadioButton = new Button(this.composite, 16);
            this.textRadioButton.setText(textText);
            this.textRadioButton.addSelectionListener((SelectionListener)FindReplaceDialog.this.defaultSelectionAdapter);
        }

        private void refreshCombo() {
            if (this.items == null) {
                return;
            }
            if (this.textCombo.getItemCount() > 0) {
                this.textCombo.remove(0, this.textCombo.getItemCount() - 1);
            }
            for (Object[] item : this.items) {
                String itemString = (String)item[0];
                this.textCombo.add(itemString);
            }
            if (!this.items.isEmpty()) {
                this.textCombo.setText((String)this.items.get(0)[0]);
            }
            this.selectText();
        }

        private void refreshHexOrText(boolean hex) {
            this.hexRadioButton.setSelection(hex);
            this.textRadioButton.setSelection(!hex);
        }

        private void rememberText() {
            String lastText = this.textCombo.getText();
            if ("".equals(lastText) || this.items == null) {
                return;
            }
            Iterator<Object[]> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                String itemString = (String)iterator.next()[0];
                if (!lastText.equals(itemString)) continue;
                iterator.remove();
            }
            this.items.add(0, new Object[]{lastText, this.hexRadioButton.getSelection()});
            this.refreshCombo();
        }

        private void selectText() {
            this.textCombo.setSelection(new Point(0, this.textCombo.getText().length()));
        }

        private void setEnabled(boolean enabled) {
            this.group.setEnabled(enabled);
            this.hexRadioButton.setEnabled(enabled);
            this.textRadioButton.setEnabled(enabled);
            this.textCombo.setEnabled(enabled);
        }
    }
}

